/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output for <a>GetTemplate</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTemplateResponse extends CloudFormationResponse implements
        ToCopyableBuilder<GetTemplateResponse.Builder, GetTemplateResponse> {
    private static final SdkField<String> TEMPLATE_BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetTemplateResponse::templateBody)).setter(setter(Builder::templateBody))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateBody").build()).build();

    private static final SdkField<List<String>> STAGES_AVAILABLE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(GetTemplateResponse::stagesAvailableAsStrings))
            .setter(setter(Builder::stagesAvailableWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StagesAvailable").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_BODY_FIELD,
            STAGES_AVAILABLE_FIELD));

    private final String templateBody;

    private final List<String> stagesAvailable;

    private GetTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.templateBody = builder.templateBody;
        this.stagesAvailable = builder.stagesAvailable;
    }

    /**
     * <p>
     * Structure containing the template body. (For more information, go to <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
     * in the AWS CloudFormation User Guide.)
     * </p>
     * <p>
     * AWS CloudFormation returns the same template that was used when the stack was created.
     * </p>
     * 
     * @return Structure containing the template body. (For more information, go to <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template
     *         Anatomy</a> in the AWS CloudFormation User Guide.)</p>
     *         <p>
     *         AWS CloudFormation returns the same template that was used when the stack was created.
     */
    public String templateBody() {
        return templateBody;
    }

    /**
     * <p>
     * The stage of the template that you can retrieve. For stacks, the <code>Original</code> and <code>Processed</code>
     * templates are always available. For change sets, the <code>Original</code> template is always available. After
     * AWS CloudFormation finishes creating the change set, the <code>Processed</code> template becomes available.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The stage of the template that you can retrieve. For stacks, the <code>Original</code> and
     *         <code>Processed</code> templates are always available. For change sets, the <code>Original</code>
     *         template is always available. After AWS CloudFormation finishes creating the change set, the
     *         <code>Processed</code> template becomes available.
     */
    public List<TemplateStage> stagesAvailable() {
        return StageListCopier.copyStringToEnum(stagesAvailable);
    }

    /**
     * <p>
     * The stage of the template that you can retrieve. For stacks, the <code>Original</code> and <code>Processed</code>
     * templates are always available. For change sets, the <code>Original</code> template is always available. After
     * AWS CloudFormation finishes creating the change set, the <code>Processed</code> template becomes available.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The stage of the template that you can retrieve. For stacks, the <code>Original</code> and
     *         <code>Processed</code> templates are always available. For change sets, the <code>Original</code>
     *         template is always available. After AWS CloudFormation finishes creating the change set, the
     *         <code>Processed</code> template becomes available.
     */
    public List<String> stagesAvailableAsStrings() {
        return stagesAvailable;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(templateBody());
        hashCode = 31 * hashCode + Objects.hashCode(stagesAvailableAsStrings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTemplateResponse)) {
            return false;
        }
        GetTemplateResponse other = (GetTemplateResponse) obj;
        return Objects.equals(templateBody(), other.templateBody())
                && Objects.equals(stagesAvailableAsStrings(), other.stagesAvailableAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetTemplateResponse").add("TemplateBody", templateBody())
                .add("StagesAvailable", stagesAvailableAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TemplateBody":
            return Optional.ofNullable(clazz.cast(templateBody()));
        case "StagesAvailable":
            return Optional.ofNullable(clazz.cast(stagesAvailableAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTemplateResponse, T> g) {
        return obj -> g.apply((GetTemplateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFormationResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetTemplateResponse> {
        /**
         * <p>
         * Structure containing the template body. (For more information, go to <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template
         * Anatomy</a> in the AWS CloudFormation User Guide.)
         * </p>
         * <p>
         * AWS CloudFormation returns the same template that was used when the stack was created.
         * </p>
         * 
         * @param templateBody
         *        Structure containing the template body. (For more information, go to <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template
         *        Anatomy</a> in the AWS CloudFormation User Guide.)</p>
         *        <p>
         *        AWS CloudFormation returns the same template that was used when the stack was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateBody(String templateBody);

        /**
         * <p>
         * The stage of the template that you can retrieve. For stacks, the <code>Original</code> and
         * <code>Processed</code> templates are always available. For change sets, the <code>Original</code> template is
         * always available. After AWS CloudFormation finishes creating the change set, the <code>Processed</code>
         * template becomes available.
         * </p>
         * 
         * @param stagesAvailable
         *        The stage of the template that you can retrieve. For stacks, the <code>Original</code> and
         *        <code>Processed</code> templates are always available. For change sets, the <code>Original</code>
         *        template is always available. After AWS CloudFormation finishes creating the change set, the
         *        <code>Processed</code> template becomes available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stagesAvailableWithStrings(Collection<String> stagesAvailable);

        /**
         * <p>
         * The stage of the template that you can retrieve. For stacks, the <code>Original</code> and
         * <code>Processed</code> templates are always available. For change sets, the <code>Original</code> template is
         * always available. After AWS CloudFormation finishes creating the change set, the <code>Processed</code>
         * template becomes available.
         * </p>
         * 
         * @param stagesAvailable
         *        The stage of the template that you can retrieve. For stacks, the <code>Original</code> and
         *        <code>Processed</code> templates are always available. For change sets, the <code>Original</code>
         *        template is always available. After AWS CloudFormation finishes creating the change set, the
         *        <code>Processed</code> template becomes available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stagesAvailableWithStrings(String... stagesAvailable);

        /**
         * <p>
         * The stage of the template that you can retrieve. For stacks, the <code>Original</code> and
         * <code>Processed</code> templates are always available. For change sets, the <code>Original</code> template is
         * always available. After AWS CloudFormation finishes creating the change set, the <code>Processed</code>
         * template becomes available.
         * </p>
         * 
         * @param stagesAvailable
         *        The stage of the template that you can retrieve. For stacks, the <code>Original</code> and
         *        <code>Processed</code> templates are always available. For change sets, the <code>Original</code>
         *        template is always available. After AWS CloudFormation finishes creating the change set, the
         *        <code>Processed</code> template becomes available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stagesAvailable(Collection<TemplateStage> stagesAvailable);

        /**
         * <p>
         * The stage of the template that you can retrieve. For stacks, the <code>Original</code> and
         * <code>Processed</code> templates are always available. For change sets, the <code>Original</code> template is
         * always available. After AWS CloudFormation finishes creating the change set, the <code>Processed</code>
         * template becomes available.
         * </p>
         * 
         * @param stagesAvailable
         *        The stage of the template that you can retrieve. For stacks, the <code>Original</code> and
         *        <code>Processed</code> templates are always available. For change sets, the <code>Original</code>
         *        template is always available. After AWS CloudFormation finishes creating the change set, the
         *        <code>Processed</code> template becomes available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stagesAvailable(TemplateStage... stagesAvailable);
    }

    static final class BuilderImpl extends CloudFormationResponse.BuilderImpl implements Builder {
        private String templateBody;

        private List<String> stagesAvailable = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetTemplateResponse model) {
            super(model);
            templateBody(model.templateBody);
            stagesAvailableWithStrings(model.stagesAvailable);
        }

        public final String getTemplateBody() {
            return templateBody;
        }

        @Override
        public final Builder templateBody(String templateBody) {
            this.templateBody = templateBody;
            return this;
        }

        public final void setTemplateBody(String templateBody) {
            this.templateBody = templateBody;
        }

        public final Collection<String> getStagesAvailableAsStrings() {
            return stagesAvailable;
        }

        @Override
        public final Builder stagesAvailableWithStrings(Collection<String> stagesAvailable) {
            this.stagesAvailable = StageListCopier.copy(stagesAvailable);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stagesAvailableWithStrings(String... stagesAvailable) {
            stagesAvailableWithStrings(Arrays.asList(stagesAvailable));
            return this;
        }

        @Override
        public final Builder stagesAvailable(Collection<TemplateStage> stagesAvailable) {
            this.stagesAvailable = StageListCopier.copyEnumToString(stagesAvailable);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stagesAvailable(TemplateStage... stagesAvailable) {
            stagesAvailable(Arrays.asList(stagesAvailable));
            return this;
        }

        public final void setStagesAvailableWithStrings(Collection<String> stagesAvailable) {
            this.stagesAvailable = StageListCopier.copy(stagesAvailable);
        }

        @Override
        public GetTemplateResponse build() {
            return new GetTemplateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
