/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfrontkeyvaluestore.auth.scheme.internal;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.auth.scheme.CloudFrontKeyValueStoreAuthSchemeParams;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.endpoints.CloudFrontKeyValueStoreEndpointProvider;
import software.amazon.awssdk.utils.Validate;

@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public final class DefaultCloudFrontKeyValueStoreAuthSchemeParams implements CloudFrontKeyValueStoreAuthSchemeParams,
        CloudFrontKeyValueStoreEndpointResolverAware {
    private final String operation;

    private final Region region;

    private final String kvsARN;

    private final Boolean useFIPS;

    private final String endpoint;

    private final CloudFrontKeyValueStoreEndpointProvider endpointProvider;

    private DefaultCloudFrontKeyValueStoreAuthSchemeParams(Builder builder) {
        this.operation = Validate.paramNotNull(builder.operation, "operation");
        this.region = builder.region;
        this.kvsARN = builder.kvsARN;
        this.useFIPS = Validate.paramNotNull(builder.useFIPS, "useFIPS");
        this.endpoint = builder.endpoint;
        this.endpointProvider = builder.endpointProvider;
    }

    public static CloudFrontKeyValueStoreAuthSchemeParams.Builder builder() {
        return new Builder();
    }

    @Override
    public String operation() {
        return operation;
    }

    @Override
    public Region region() {
        return region;
    }

    @Override
    public String kvsArn() {
        return kvsARN;
    }

    @Override
    public Boolean useFips() {
        return useFIPS;
    }

    @Override
    public String endpoint() {
        return endpoint;
    }

    @Override
    public CloudFrontKeyValueStoreEndpointProvider endpointProvider() {
        return endpointProvider;
    }

    @Override
    public CloudFrontKeyValueStoreAuthSchemeParams.Builder toBuilder() {
        return new Builder(this);
    }

    private static final class Builder implements CloudFrontKeyValueStoreAuthSchemeParams.Builder,
            CloudFrontKeyValueStoreEndpointResolverAware.Builder {
        private String operation;

        private Region region;

        private String kvsARN;

        private Boolean useFIPS = false;

        private String endpoint;

        private CloudFrontKeyValueStoreEndpointProvider endpointProvider;

        Builder() {
        }

        Builder(DefaultCloudFrontKeyValueStoreAuthSchemeParams params) {
            this.operation = params.operation;
            this.region = params.region;
            this.kvsARN = params.kvsARN;
            this.useFIPS = params.useFIPS;
            this.endpoint = params.endpoint;
            this.endpointProvider = params.endpointProvider;
        }

        @Override
        public Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        @Override
        public Builder region(Region region) {
            this.region = region;
            return this;
        }

        @Override
        public Builder kvsArn(String kvsARN) {
            this.kvsARN = kvsARN;
            return this;
        }

        @Override
        public Builder useFips(Boolean useFIPS) {
            this.useFIPS = useFIPS;
            if (this.useFIPS == null) {
                this.useFIPS = false;
            }
            return this;
        }

        @Override
        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        @Override
        public Builder endpointProvider(CloudFrontKeyValueStoreEndpointProvider endpointProvider) {
            this.endpointProvider = endpointProvider;
            return this;
        }

        @Override
        public CloudFrontKeyValueStoreAuthSchemeParams build() {
            return new DefaultCloudFrontKeyValueStoreAuthSchemeParams(this);
        }
    }
}
