/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfrontkeyvaluestore.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Metadata information about a Key Value Store.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeKeyValueStoreResponse extends CloudFrontKeyValueStoreResponse implements
        ToCopyableBuilder<DescribeKeyValueStoreResponse.Builder, DescribeKeyValueStoreResponse> {
    private static final SdkField<Integer> ITEM_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ItemCount").getter(getter(DescribeKeyValueStoreResponse::itemCount)).setter(setter(Builder::itemCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ItemCount").build()).build();

    private static final SdkField<Long> TOTAL_SIZE_IN_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("TotalSizeInBytes").getter(getter(DescribeKeyValueStoreResponse::totalSizeInBytes))
            .setter(setter(Builder::totalSizeInBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalSizeInBytes").build()).build();

    private static final SdkField<String> KVS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("KvsARN")
            .getter(getter(DescribeKeyValueStoreResponse::kvsARN)).setter(setter(Builder::kvsARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KvsARN").build()).build();

    private static final SdkField<Instant> CREATED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("Created").getter(getter(DescribeKeyValueStoreResponse::created)).setter(setter(Builder::created))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Created").build()).build();

    private static final SdkField<String> E_TAG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ETag")
            .getter(getter(DescribeKeyValueStoreResponse::eTag)).setter(setter(Builder::eTag))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("ETag").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModified").getter(getter(DescribeKeyValueStoreResponse::lastModified))
            .setter(setter(Builder::lastModified))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModified").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribeKeyValueStoreResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureReason").getter(getter(DescribeKeyValueStoreResponse::failureReason))
            .setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ITEM_COUNT_FIELD,
            TOTAL_SIZE_IN_BYTES_FIELD, KVS_ARN_FIELD, CREATED_FIELD, E_TAG_FIELD, LAST_MODIFIED_FIELD, STATUS_FIELD,
            FAILURE_REASON_FIELD));

    private final Integer itemCount;

    private final Long totalSizeInBytes;

    private final String kvsARN;

    private final Instant created;

    private final String eTag;

    private final Instant lastModified;

    private final String status;

    private final String failureReason;

    private DescribeKeyValueStoreResponse(BuilderImpl builder) {
        super(builder);
        this.itemCount = builder.itemCount;
        this.totalSizeInBytes = builder.totalSizeInBytes;
        this.kvsARN = builder.kvsARN;
        this.created = builder.created;
        this.eTag = builder.eTag;
        this.lastModified = builder.lastModified;
        this.status = builder.status;
        this.failureReason = builder.failureReason;
    }

    /**
     * <p>
     * Number of key value pairs in the Key Value Store.
     * </p>
     * 
     * @return Number of key value pairs in the Key Value Store.
     */
    public final Integer itemCount() {
        return itemCount;
    }

    /**
     * <p>
     * Total size of the Key Value Store in bytes.
     * </p>
     * 
     * @return Total size of the Key Value Store in bytes.
     */
    public final Long totalSizeInBytes() {
        return totalSizeInBytes;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Key Value Store.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Key Value Store.
     */
    public final String kvsARN() {
        return kvsARN;
    }

    /**
     * <p>
     * Date and time when the Key Value Store was created.
     * </p>
     * 
     * @return Date and time when the Key Value Store was created.
     */
    public final Instant created() {
        return created;
    }

    /**
     * <p>
     * The version identifier for the current version of the Key Value Store.
     * </p>
     * 
     * @return The version identifier for the current version of the Key Value Store.
     */
    public final String eTag() {
        return eTag;
    }

    /**
     * <p>
     * Date and time when the key value pairs in the Key Value Store was last modified.
     * </p>
     * 
     * @return Date and time when the key value pairs in the Key Value Store was last modified.
     */
    public final Instant lastModified() {
        return lastModified;
    }

    /**
     * <p>
     * The current status of the Key Value Store.
     * </p>
     * 
     * @return The current status of the Key Value Store.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The reason for Key Value Store creation failure.
     * </p>
     * 
     * @return The reason for Key Value Store creation failure.
     */
    public final String failureReason() {
        return failureReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(itemCount());
        hashCode = 31 * hashCode + Objects.hashCode(totalSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(kvsARN());
        hashCode = 31 * hashCode + Objects.hashCode(created());
        hashCode = 31 * hashCode + Objects.hashCode(eTag());
        hashCode = 31 * hashCode + Objects.hashCode(lastModified());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeKeyValueStoreResponse)) {
            return false;
        }
        DescribeKeyValueStoreResponse other = (DescribeKeyValueStoreResponse) obj;
        return Objects.equals(itemCount(), other.itemCount()) && Objects.equals(totalSizeInBytes(), other.totalSizeInBytes())
                && Objects.equals(kvsARN(), other.kvsARN()) && Objects.equals(created(), other.created())
                && Objects.equals(eTag(), other.eTag()) && Objects.equals(lastModified(), other.lastModified())
                && Objects.equals(status(), other.status()) && Objects.equals(failureReason(), other.failureReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeKeyValueStoreResponse").add("ItemCount", itemCount())
                .add("TotalSizeInBytes", totalSizeInBytes()).add("KvsARN", kvsARN()).add("Created", created())
                .add("ETag", eTag()).add("LastModified", lastModified()).add("Status", status())
                .add("FailureReason", failureReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ItemCount":
            return Optional.ofNullable(clazz.cast(itemCount()));
        case "TotalSizeInBytes":
            return Optional.ofNullable(clazz.cast(totalSizeInBytes()));
        case "KvsARN":
            return Optional.ofNullable(clazz.cast(kvsARN()));
        case "Created":
            return Optional.ofNullable(clazz.cast(created()));
        case "ETag":
            return Optional.ofNullable(clazz.cast(eTag()));
        case "LastModified":
            return Optional.ofNullable(clazz.cast(lastModified()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeKeyValueStoreResponse, T> g) {
        return obj -> g.apply((DescribeKeyValueStoreResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFrontKeyValueStoreResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeKeyValueStoreResponse> {
        /**
         * <p>
         * Number of key value pairs in the Key Value Store.
         * </p>
         * 
         * @param itemCount
         *        Number of key value pairs in the Key Value Store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder itemCount(Integer itemCount);

        /**
         * <p>
         * Total size of the Key Value Store in bytes.
         * </p>
         * 
         * @param totalSizeInBytes
         *        Total size of the Key Value Store in bytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalSizeInBytes(Long totalSizeInBytes);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Key Value Store.
         * </p>
         * 
         * @param kvsARN
         *        The Amazon Resource Name (ARN) of the Key Value Store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kvsARN(String kvsARN);

        /**
         * <p>
         * Date and time when the Key Value Store was created.
         * </p>
         * 
         * @param created
         *        Date and time when the Key Value Store was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder created(Instant created);

        /**
         * <p>
         * The version identifier for the current version of the Key Value Store.
         * </p>
         * 
         * @param eTag
         *        The version identifier for the current version of the Key Value Store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eTag(String eTag);

        /**
         * <p>
         * Date and time when the key value pairs in the Key Value Store was last modified.
         * </p>
         * 
         * @param lastModified
         *        Date and time when the key value pairs in the Key Value Store was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModified(Instant lastModified);

        /**
         * <p>
         * The current status of the Key Value Store.
         * </p>
         * 
         * @param status
         *        The current status of the Key Value Store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The reason for Key Value Store creation failure.
         * </p>
         * 
         * @param failureReason
         *        The reason for Key Value Store creation failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);
    }

    static final class BuilderImpl extends CloudFrontKeyValueStoreResponse.BuilderImpl implements Builder {
        private Integer itemCount;

        private Long totalSizeInBytes;

        private String kvsARN;

        private Instant created;

        private String eTag;

        private Instant lastModified;

        private String status;

        private String failureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeKeyValueStoreResponse model) {
            super(model);
            itemCount(model.itemCount);
            totalSizeInBytes(model.totalSizeInBytes);
            kvsARN(model.kvsARN);
            created(model.created);
            eTag(model.eTag);
            lastModified(model.lastModified);
            status(model.status);
            failureReason(model.failureReason);
        }

        public final Integer getItemCount() {
            return itemCount;
        }

        public final void setItemCount(Integer itemCount) {
            this.itemCount = itemCount;
        }

        @Override
        public final Builder itemCount(Integer itemCount) {
            this.itemCount = itemCount;
            return this;
        }

        public final Long getTotalSizeInBytes() {
            return totalSizeInBytes;
        }

        public final void setTotalSizeInBytes(Long totalSizeInBytes) {
            this.totalSizeInBytes = totalSizeInBytes;
        }

        @Override
        public final Builder totalSizeInBytes(Long totalSizeInBytes) {
            this.totalSizeInBytes = totalSizeInBytes;
            return this;
        }

        public final String getKvsARN() {
            return kvsARN;
        }

        public final void setKvsARN(String kvsARN) {
            this.kvsARN = kvsARN;
        }

        @Override
        public final Builder kvsARN(String kvsARN) {
            this.kvsARN = kvsARN;
            return this;
        }

        public final Instant getCreated() {
            return created;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        @Override
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final String getETag() {
            return eTag;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final Instant getLastModified() {
            return lastModified;
        }

        public final void setLastModified(Instant lastModified) {
            this.lastModified = lastModified;
        }

        @Override
        public final Builder lastModified(Instant lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        @Override
        public DescribeKeyValueStoreResponse build() {
            return new DescribeKeyValueStoreResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
