/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfrontkeyvaluestore.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A key value pair.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetKeyResponse extends CloudFrontKeyValueStoreResponse implements
        ToCopyableBuilder<GetKeyResponse.Builder, GetKeyResponse> {
    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Key")
            .getter(getter(GetKeyResponse::key)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Key").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Value")
            .getter(getter(GetKeyResponse::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final SdkField<Integer> ITEM_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ItemCount").getter(getter(GetKeyResponse::itemCount)).setter(setter(Builder::itemCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ItemCount").build()).build();

    private static final SdkField<Long> TOTAL_SIZE_IN_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("TotalSizeInBytes").getter(getter(GetKeyResponse::totalSizeInBytes))
            .setter(setter(Builder::totalSizeInBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalSizeInBytes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, VALUE_FIELD,
            ITEM_COUNT_FIELD, TOTAL_SIZE_IN_BYTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String key;

    private final String value;

    private final Integer itemCount;

    private final Long totalSizeInBytes;

    private GetKeyResponse(BuilderImpl builder) {
        super(builder);
        this.key = builder.key;
        this.value = builder.value;
        this.itemCount = builder.itemCount;
        this.totalSizeInBytes = builder.totalSizeInBytes;
    }

    /**
     * <p>
     * The key of the key value pair.
     * </p>
     * 
     * @return The key of the key value pair.
     */
    public final String key() {
        return key;
    }

    /**
     * <p>
     * The value of the key value pair.
     * </p>
     * 
     * @return The value of the key value pair.
     */
    public final String value() {
        return value;
    }

    /**
     * <p>
     * Number of key value pairs in the Key Value Store.
     * </p>
     * 
     * @return Number of key value pairs in the Key Value Store.
     */
    public final Integer itemCount() {
        return itemCount;
    }

    /**
     * <p>
     * Total size of the Key Value Store in bytes.
     * </p>
     * 
     * @return Total size of the Key Value Store in bytes.
     */
    public final Long totalSizeInBytes() {
        return totalSizeInBytes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(itemCount());
        hashCode = 31 * hashCode + Objects.hashCode(totalSizeInBytes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetKeyResponse)) {
            return false;
        }
        GetKeyResponse other = (GetKeyResponse) obj;
        return Objects.equals(key(), other.key()) && Objects.equals(value(), other.value())
                && Objects.equals(itemCount(), other.itemCount()) && Objects.equals(totalSizeInBytes(), other.totalSizeInBytes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetKeyResponse").add("Key", key())
                .add("Value", value() == null ? null : "*** Sensitive Data Redacted ***").add("ItemCount", itemCount())
                .add("TotalSizeInBytes", totalSizeInBytes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Key":
            return Optional.ofNullable(clazz.cast(key()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        case "ItemCount":
            return Optional.ofNullable(clazz.cast(itemCount()));
        case "TotalSizeInBytes":
            return Optional.ofNullable(clazz.cast(totalSizeInBytes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Key", KEY_FIELD);
        map.put("Value", VALUE_FIELD);
        map.put("ItemCount", ITEM_COUNT_FIELD);
        map.put("TotalSizeInBytes", TOTAL_SIZE_IN_BYTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetKeyResponse, T> g) {
        return obj -> g.apply((GetKeyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFrontKeyValueStoreResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetKeyResponse> {
        /**
         * <p>
         * The key of the key value pair.
         * </p>
         * 
         * @param key
         *        The key of the key value pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * The value of the key value pair.
         * </p>
         * 
         * @param value
         *        The value of the key value pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);

        /**
         * <p>
         * Number of key value pairs in the Key Value Store.
         * </p>
         * 
         * @param itemCount
         *        Number of key value pairs in the Key Value Store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder itemCount(Integer itemCount);

        /**
         * <p>
         * Total size of the Key Value Store in bytes.
         * </p>
         * 
         * @param totalSizeInBytes
         *        Total size of the Key Value Store in bytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalSizeInBytes(Long totalSizeInBytes);
    }

    static final class BuilderImpl extends CloudFrontKeyValueStoreResponse.BuilderImpl implements Builder {
        private String key;

        private String value;

        private Integer itemCount;

        private Long totalSizeInBytes;

        private BuilderImpl() {
        }

        private BuilderImpl(GetKeyResponse model) {
            super(model);
            key(model.key);
            value(model.value);
            itemCount(model.itemCount);
            totalSizeInBytes(model.totalSizeInBytes);
        }

        public final String getKey() {
            return key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final Integer getItemCount() {
            return itemCount;
        }

        public final void setItemCount(Integer itemCount) {
            this.itemCount = itemCount;
        }

        @Override
        public final Builder itemCount(Integer itemCount) {
            this.itemCount = itemCount;
            return this;
        }

        public final Long getTotalSizeInBytes() {
            return totalSizeInBytes;
        }

        public final void setTotalSizeInBytes(Long totalSizeInBytes) {
            this.totalSizeInBytes = totalSizeInBytes;
        }

        @Override
        public final Builder totalSizeInBytes(Long totalSizeInBytes) {
            this.totalSizeInBytes = totalSizeInBytes;
            return this;
        }

        @Override
        public GetKeyResponse build() {
            return new GetKeyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
