/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfrontkeyvaluestore.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A key value pair.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutKeyRequest extends CloudFrontKeyValueStoreRequest implements
        ToCopyableBuilder<PutKeyRequest.Builder, PutKeyRequest> {
    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Key")
            .getter(getter(PutKeyRequest::key)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Key").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Value")
            .getter(getter(PutKeyRequest::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final SdkField<String> KVS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("KvsARN")
            .getter(getter(PutKeyRequest::kvsARN)).setter(setter(Builder::kvsARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("KvsARN").build()).build();

    private static final SdkField<String> IF_MATCH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IfMatch").getter(getter(PutKeyRequest::ifMatch)).setter(setter(Builder::ifMatch))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("If-Match").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, VALUE_FIELD,
            KVS_ARN_FIELD, IF_MATCH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String key;

    private final String value;

    private final String kvsARN;

    private final String ifMatch;

    private PutKeyRequest(BuilderImpl builder) {
        super(builder);
        this.key = builder.key;
        this.value = builder.value;
        this.kvsARN = builder.kvsARN;
        this.ifMatch = builder.ifMatch;
    }

    /**
     * <p>
     * The key to put.
     * </p>
     * 
     * @return The key to put.
     */
    public final String key() {
        return key;
    }

    /**
     * <p>
     * The value to put.
     * </p>
     * 
     * @return The value to put.
     */
    public final String value() {
        return value;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Key Value Store.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Key Value Store.
     */
    public final String kvsARN() {
        return kvsARN;
    }

    /**
     * <p>
     * The current version (ETag) of the Key Value Store that you are putting keys into, which you can get using
     * DescribeKeyValueStore.
     * </p>
     * 
     * @return The current version (ETag) of the Key Value Store that you are putting keys into, which you can get using
     *         DescribeKeyValueStore.
     */
    public final String ifMatch() {
        return ifMatch;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(kvsARN());
        hashCode = 31 * hashCode + Objects.hashCode(ifMatch());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutKeyRequest)) {
            return false;
        }
        PutKeyRequest other = (PutKeyRequest) obj;
        return Objects.equals(key(), other.key()) && Objects.equals(value(), other.value())
                && Objects.equals(kvsARN(), other.kvsARN()) && Objects.equals(ifMatch(), other.ifMatch());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutKeyRequest").add("Key", key())
                .add("Value", value() == null ? null : "*** Sensitive Data Redacted ***").add("KvsARN", kvsARN())
                .add("IfMatch", ifMatch()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Key":
            return Optional.ofNullable(clazz.cast(key()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        case "KvsARN":
            return Optional.ofNullable(clazz.cast(kvsARN()));
        case "IfMatch":
            return Optional.ofNullable(clazz.cast(ifMatch()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Key", KEY_FIELD);
        map.put("Value", VALUE_FIELD);
        map.put("KvsARN", KVS_ARN_FIELD);
        map.put("If-Match", IF_MATCH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutKeyRequest, T> g) {
        return obj -> g.apply((PutKeyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFrontKeyValueStoreRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutKeyRequest> {
        /**
         * <p>
         * The key to put.
         * </p>
         * 
         * @param key
         *        The key to put.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * The value to put.
         * </p>
         * 
         * @param value
         *        The value to put.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Key Value Store.
         * </p>
         * 
         * @param kvsARN
         *        The Amazon Resource Name (ARN) of the Key Value Store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kvsARN(String kvsARN);

        /**
         * <p>
         * The current version (ETag) of the Key Value Store that you are putting keys into, which you can get using
         * DescribeKeyValueStore.
         * </p>
         * 
         * @param ifMatch
         *        The current version (ETag) of the Key Value Store that you are putting keys into, which you can get
         *        using DescribeKeyValueStore.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ifMatch(String ifMatch);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFrontKeyValueStoreRequest.BuilderImpl implements Builder {
        private String key;

        private String value;

        private String kvsARN;

        private String ifMatch;

        private BuilderImpl() {
        }

        private BuilderImpl(PutKeyRequest model) {
            super(model);
            key(model.key);
            value(model.value);
            kvsARN(model.kvsARN);
            ifMatch(model.ifMatch);
        }

        public final String getKey() {
            return key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final String getKvsARN() {
            return kvsARN;
        }

        public final void setKvsARN(String kvsARN) {
            this.kvsARN = kvsARN;
        }

        @Override
        public final Builder kvsARN(String kvsARN) {
            this.kvsARN = kvsARN;
            return this;
        }

        public final String getIfMatch() {
            return ifMatch;
        }

        public final void setIfMatch(String ifMatch) {
            this.ifMatch = ifMatch;
        }

        @Override
        public final Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutKeyRequest build() {
            return new PutKeyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
