/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfrontkeyvaluestore.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateKeysRequest extends CloudFrontKeyValueStoreRequest implements
        ToCopyableBuilder<UpdateKeysRequest.Builder, UpdateKeysRequest> {
    private static final SdkField<String> KVS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("KvsARN")
            .getter(getter(UpdateKeysRequest::kvsARN)).setter(setter(Builder::kvsARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("KvsARN").build()).build();

    private static final SdkField<String> IF_MATCH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IfMatch").getter(getter(UpdateKeysRequest::ifMatch)).setter(setter(Builder::ifMatch))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("If-Match").build()).build();

    private static final SdkField<List<PutKeyRequestListItem>> PUTS_FIELD = SdkField
            .<List<PutKeyRequestListItem>> builder(MarshallingType.LIST)
            .memberName("Puts")
            .getter(getter(UpdateKeysRequest::puts))
            .setter(setter(Builder::puts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Puts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PutKeyRequestListItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(PutKeyRequestListItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DeleteKeyRequestListItem>> DELETES_FIELD = SdkField
            .<List<DeleteKeyRequestListItem>> builder(MarshallingType.LIST)
            .memberName("Deletes")
            .getter(getter(UpdateKeysRequest::deletes))
            .setter(setter(Builder::deletes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Deletes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DeleteKeyRequestListItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(DeleteKeyRequestListItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KVS_ARN_FIELD, IF_MATCH_FIELD,
            PUTS_FIELD, DELETES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String kvsARN;

    private final String ifMatch;

    private final List<PutKeyRequestListItem> puts;

    private final List<DeleteKeyRequestListItem> deletes;

    private UpdateKeysRequest(BuilderImpl builder) {
        super(builder);
        this.kvsARN = builder.kvsARN;
        this.ifMatch = builder.ifMatch;
        this.puts = builder.puts;
        this.deletes = builder.deletes;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Key Value Store.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Key Value Store.
     */
    public final String kvsARN() {
        return kvsARN;
    }

    /**
     * <p>
     * The current version (ETag) of the Key Value Store that you are updating keys of, which you can get using
     * DescribeKeyValueStore.
     * </p>
     * 
     * @return The current version (ETag) of the Key Value Store that you are updating keys of, which you can get using
     *         DescribeKeyValueStore.
     */
    public final String ifMatch() {
        return ifMatch;
    }

    /**
     * For responses, this returns true if the service returned a value for the Puts property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasPuts() {
        return puts != null && !(puts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of key value pairs to put.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPuts} method.
     * </p>
     * 
     * @return List of key value pairs to put.
     */
    public final List<PutKeyRequestListItem> puts() {
        return puts;
    }

    /**
     * For responses, this returns true if the service returned a value for the Deletes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDeletes() {
        return deletes != null && !(deletes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of keys to delete.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDeletes} method.
     * </p>
     * 
     * @return List of keys to delete.
     */
    public final List<DeleteKeyRequestListItem> deletes() {
        return deletes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(kvsARN());
        hashCode = 31 * hashCode + Objects.hashCode(ifMatch());
        hashCode = 31 * hashCode + Objects.hashCode(hasPuts() ? puts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDeletes() ? deletes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateKeysRequest)) {
            return false;
        }
        UpdateKeysRequest other = (UpdateKeysRequest) obj;
        return Objects.equals(kvsARN(), other.kvsARN()) && Objects.equals(ifMatch(), other.ifMatch())
                && hasPuts() == other.hasPuts() && Objects.equals(puts(), other.puts()) && hasDeletes() == other.hasDeletes()
                && Objects.equals(deletes(), other.deletes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateKeysRequest").add("KvsARN", kvsARN()).add("IfMatch", ifMatch())
                .add("Puts", hasPuts() ? puts() : null).add("Deletes", hasDeletes() ? deletes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KvsARN":
            return Optional.ofNullable(clazz.cast(kvsARN()));
        case "IfMatch":
            return Optional.ofNullable(clazz.cast(ifMatch()));
        case "Puts":
            return Optional.ofNullable(clazz.cast(puts()));
        case "Deletes":
            return Optional.ofNullable(clazz.cast(deletes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("KvsARN", KVS_ARN_FIELD);
        map.put("If-Match", IF_MATCH_FIELD);
        map.put("Puts", PUTS_FIELD);
        map.put("Deletes", DELETES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateKeysRequest, T> g) {
        return obj -> g.apply((UpdateKeysRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudFrontKeyValueStoreRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateKeysRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Key Value Store.
         * </p>
         * 
         * @param kvsARN
         *        The Amazon Resource Name (ARN) of the Key Value Store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kvsARN(String kvsARN);

        /**
         * <p>
         * The current version (ETag) of the Key Value Store that you are updating keys of, which you can get using
         * DescribeKeyValueStore.
         * </p>
         * 
         * @param ifMatch
         *        The current version (ETag) of the Key Value Store that you are updating keys of, which you can get
         *        using DescribeKeyValueStore.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ifMatch(String ifMatch);

        /**
         * <p>
         * List of key value pairs to put.
         * </p>
         * 
         * @param puts
         *        List of key value pairs to put.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder puts(Collection<PutKeyRequestListItem> puts);

        /**
         * <p>
         * List of key value pairs to put.
         * </p>
         * 
         * @param puts
         *        List of key value pairs to put.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder puts(PutKeyRequestListItem... puts);

        /**
         * <p>
         * List of key value pairs to put.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.PutKeyRequestListItem.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.PutKeyRequestListItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.PutKeyRequestListItem.Builder#build()}
         * is called immediately and its result is passed to {@link #puts(List<PutKeyRequestListItem>)}.
         * 
         * @param puts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.PutKeyRequestListItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #puts(java.util.Collection<PutKeyRequestListItem>)
         */
        Builder puts(Consumer<PutKeyRequestListItem.Builder>... puts);

        /**
         * <p>
         * List of keys to delete.
         * </p>
         * 
         * @param deletes
         *        List of keys to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletes(Collection<DeleteKeyRequestListItem> deletes);

        /**
         * <p>
         * List of keys to delete.
         * </p>
         * 
         * @param deletes
         *        List of keys to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletes(DeleteKeyRequestListItem... deletes);

        /**
         * <p>
         * List of keys to delete.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.DeleteKeyRequestListItem.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.DeleteKeyRequestListItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.DeleteKeyRequestListItem.Builder#build()}
         * is called immediately and its result is passed to {@link #deletes(List<DeleteKeyRequestListItem>)}.
         * 
         * @param deletes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.DeleteKeyRequestListItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deletes(java.util.Collection<DeleteKeyRequestListItem>)
         */
        Builder deletes(Consumer<DeleteKeyRequestListItem.Builder>... deletes);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFrontKeyValueStoreRequest.BuilderImpl implements Builder {
        private String kvsARN;

        private String ifMatch;

        private List<PutKeyRequestListItem> puts = DefaultSdkAutoConstructList.getInstance();

        private List<DeleteKeyRequestListItem> deletes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateKeysRequest model) {
            super(model);
            kvsARN(model.kvsARN);
            ifMatch(model.ifMatch);
            puts(model.puts);
            deletes(model.deletes);
        }

        public final String getKvsARN() {
            return kvsARN;
        }

        public final void setKvsARN(String kvsARN) {
            this.kvsARN = kvsARN;
        }

        @Override
        public final Builder kvsARN(String kvsARN) {
            this.kvsARN = kvsARN;
            return this;
        }

        public final String getIfMatch() {
            return ifMatch;
        }

        public final void setIfMatch(String ifMatch) {
            this.ifMatch = ifMatch;
        }

        @Override
        public final Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public final List<PutKeyRequestListItem.Builder> getPuts() {
            List<PutKeyRequestListItem.Builder> result = PutKeyRequestsListCopier.copyToBuilder(this.puts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPuts(Collection<PutKeyRequestListItem.BuilderImpl> puts) {
            this.puts = PutKeyRequestsListCopier.copyFromBuilder(puts);
        }

        @Override
        public final Builder puts(Collection<PutKeyRequestListItem> puts) {
            this.puts = PutKeyRequestsListCopier.copy(puts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder puts(PutKeyRequestListItem... puts) {
            puts(Arrays.asList(puts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder puts(Consumer<PutKeyRequestListItem.Builder>... puts) {
            puts(Stream.of(puts).map(c -> PutKeyRequestListItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DeleteKeyRequestListItem.Builder> getDeletes() {
            List<DeleteKeyRequestListItem.Builder> result = DeleteKeyRequestsListCopier.copyToBuilder(this.deletes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDeletes(Collection<DeleteKeyRequestListItem.BuilderImpl> deletes) {
            this.deletes = DeleteKeyRequestsListCopier.copyFromBuilder(deletes);
        }

        @Override
        public final Builder deletes(Collection<DeleteKeyRequestListItem> deletes) {
            this.deletes = DeleteKeyRequestsListCopier.copy(deletes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deletes(DeleteKeyRequestListItem... deletes) {
            deletes(Arrays.asList(deletes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deletes(Consumer<DeleteKeyRequestListItem.Builder>... deletes) {
            deletes(Stream.of(deletes).map(c -> DeleteKeyRequestListItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateKeysRequest build() {
            return new UpdateKeysRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
