/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfrontkeyvaluestore;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.AccessDeniedException;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.CloudFrontKeyValueStoreException;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.ConflictException;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.DeleteKeyRequest;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.DeleteKeyResponse;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.DescribeKeyValueStoreRequest;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.DescribeKeyValueStoreResponse;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.GetKeyRequest;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.GetKeyResponse;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.InternalServerException;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.ListKeysRequest;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.ListKeysResponse;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.PutKeyRequest;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.PutKeyResponse;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.ResourceNotFoundException;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.UpdateKeysRequest;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.UpdateKeysResponse;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.ValidationException;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.paginators.ListKeysIterable;

/**
 * Service client for accessing Amazon CloudFront KeyValueStore. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * Amazon CloudFront KeyValueStore Service to View and Update Data in a KVS Resource
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface CloudFrontKeyValueStoreClient extends AwsClient {
    String SERVICE_NAME = "cloudfront-keyvaluestore";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "cloudfront-keyvaluestore";

    /**
     * <p>
     * Deletes the key value pair specified by the key.
     * </p>
     *
     * @param deleteKeyRequest
     * @return Result of the DeleteKey operation returned by the service.
     * @throws ConflictException
     *         Resource is not in expected state.
     * @throws ValidationException
     *         Validation failed.
     * @throws InternalServerException
     *         Internal server error.
     * @throws ServiceQuotaExceededException
     *         Limit exceeded.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontKeyValueStoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontKeyValueStoreClient.DeleteKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-keyvaluestore-2022-07-26/DeleteKey"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteKeyResponse deleteKey(DeleteKeyRequest deleteKeyRequest) throws ConflictException, ValidationException,
            InternalServerException, ServiceQuotaExceededException, ResourceNotFoundException, AccessDeniedException,
            AwsServiceException, SdkClientException, CloudFrontKeyValueStoreException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the key value pair specified by the key.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteKeyRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteKeyRequest#builder()}
     * </p>
     *
     * @param deleteKeyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.DeleteKeyRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteKey operation returned by the service.
     * @throws ConflictException
     *         Resource is not in expected state.
     * @throws ValidationException
     *         Validation failed.
     * @throws InternalServerException
     *         Internal server error.
     * @throws ServiceQuotaExceededException
     *         Limit exceeded.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontKeyValueStoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontKeyValueStoreClient.DeleteKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-keyvaluestore-2022-07-26/DeleteKey"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteKeyResponse deleteKey(Consumer<DeleteKeyRequest.Builder> deleteKeyRequest) throws ConflictException,
            ValidationException, InternalServerException, ServiceQuotaExceededException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, CloudFrontKeyValueStoreException {
        return deleteKey(DeleteKeyRequest.builder().applyMutation(deleteKeyRequest).build());
    }

    /**
     * <p>
     * Returns metadata information about Key Value Store.
     * </p>
     *
     * @param describeKeyValueStoreRequest
     * @return Result of the DescribeKeyValueStore operation returned by the service.
     * @throws ConflictException
     *         Resource is not in expected state.
     * @throws InternalServerException
     *         Internal server error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontKeyValueStoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontKeyValueStoreClient.DescribeKeyValueStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-keyvaluestore-2022-07-26/DescribeKeyValueStore"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeKeyValueStoreResponse describeKeyValueStore(DescribeKeyValueStoreRequest describeKeyValueStoreRequest)
            throws ConflictException, InternalServerException, ResourceNotFoundException, AccessDeniedException,
            AwsServiceException, SdkClientException, CloudFrontKeyValueStoreException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns metadata information about Key Value Store.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeKeyValueStoreRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeKeyValueStoreRequest#builder()}
     * </p>
     *
     * @param describeKeyValueStoreRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.DescribeKeyValueStoreRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeKeyValueStore operation returned by the service.
     * @throws ConflictException
     *         Resource is not in expected state.
     * @throws InternalServerException
     *         Internal server error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontKeyValueStoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontKeyValueStoreClient.DescribeKeyValueStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-keyvaluestore-2022-07-26/DescribeKeyValueStore"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeKeyValueStoreResponse describeKeyValueStore(
            Consumer<DescribeKeyValueStoreRequest.Builder> describeKeyValueStoreRequest) throws ConflictException,
            InternalServerException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException,
            CloudFrontKeyValueStoreException {
        return describeKeyValueStore(DescribeKeyValueStoreRequest.builder().applyMutation(describeKeyValueStoreRequest).build());
    }

    /**
     * <p>
     * Returns a key value pair.
     * </p>
     *
     * @param getKeyRequest
     * @return Result of the GetKey operation returned by the service.
     * @throws ConflictException
     *         Resource is not in expected state.
     * @throws InternalServerException
     *         Internal server error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontKeyValueStoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontKeyValueStoreClient.GetKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-keyvaluestore-2022-07-26/GetKey"
     *      target="_top">AWS API Documentation</a>
     */
    default GetKeyResponse getKey(GetKeyRequest getKeyRequest) throws ConflictException, InternalServerException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException,
            CloudFrontKeyValueStoreException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a key value pair.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetKeyRequest.Builder} avoiding the need to create
     * one manually via {@link GetKeyRequest#builder()}
     * </p>
     *
     * @param getKeyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.GetKeyRequest.Builder} to create a
     *        request.
     * @return Result of the GetKey operation returned by the service.
     * @throws ConflictException
     *         Resource is not in expected state.
     * @throws InternalServerException
     *         Internal server error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontKeyValueStoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontKeyValueStoreClient.GetKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-keyvaluestore-2022-07-26/GetKey"
     *      target="_top">AWS API Documentation</a>
     */
    default GetKeyResponse getKey(Consumer<GetKeyRequest.Builder> getKeyRequest) throws ConflictException,
            InternalServerException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException,
            CloudFrontKeyValueStoreException {
        return getKey(GetKeyRequest.builder().applyMutation(getKeyRequest).build());
    }

    /**
     * <p>
     * Returns a list of key value pairs.
     * </p>
     *
     * @param listKeysRequest
     * @return Result of the ListKeys operation returned by the service.
     * @throws ConflictException
     *         Resource is not in expected state.
     * @throws ValidationException
     *         Validation failed.
     * @throws InternalServerException
     *         Internal server error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontKeyValueStoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontKeyValueStoreClient.ListKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-keyvaluestore-2022-07-26/ListKeys"
     *      target="_top">AWS API Documentation</a>
     */
    default ListKeysResponse listKeys(ListKeysRequest listKeysRequest) throws ConflictException, ValidationException,
            InternalServerException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException,
            CloudFrontKeyValueStoreException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of key value pairs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListKeysRequest.Builder} avoiding the need to
     * create one manually via {@link ListKeysRequest#builder()}
     * </p>
     *
     * @param listKeysRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.ListKeysRequest.Builder} to create a
     *        request.
     * @return Result of the ListKeys operation returned by the service.
     * @throws ConflictException
     *         Resource is not in expected state.
     * @throws ValidationException
     *         Validation failed.
     * @throws InternalServerException
     *         Internal server error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontKeyValueStoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontKeyValueStoreClient.ListKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-keyvaluestore-2022-07-26/ListKeys"
     *      target="_top">AWS API Documentation</a>
     */
    default ListKeysResponse listKeys(Consumer<ListKeysRequest.Builder> listKeysRequest) throws ConflictException,
            ValidationException, InternalServerException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, CloudFrontKeyValueStoreException {
        return listKeys(ListKeysRequest.builder().applyMutation(listKeysRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listKeys(software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.ListKeysRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudfrontkeyvaluestore.paginators.ListKeysIterable responses = client.listKeysPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cloudfrontkeyvaluestore.paginators.ListKeysIterable responses = client
     *             .listKeysPaginator(request);
     *     for (software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.ListKeysResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudfrontkeyvaluestore.paginators.ListKeysIterable responses = client.listKeysPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listKeys(software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.ListKeysRequest)} operation.</b>
     * </p>
     *
     * @param listKeysRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ConflictException
     *         Resource is not in expected state.
     * @throws ValidationException
     *         Validation failed.
     * @throws InternalServerException
     *         Internal server error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontKeyValueStoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontKeyValueStoreClient.ListKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-keyvaluestore-2022-07-26/ListKeys"
     *      target="_top">AWS API Documentation</a>
     */
    default ListKeysIterable listKeysPaginator(ListKeysRequest listKeysRequest) throws ConflictException, ValidationException,
            InternalServerException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException,
            CloudFrontKeyValueStoreException {
        return new ListKeysIterable(this, listKeysRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listKeys(software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.ListKeysRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudfrontkeyvaluestore.paginators.ListKeysIterable responses = client.listKeysPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cloudfrontkeyvaluestore.paginators.ListKeysIterable responses = client
     *             .listKeysPaginator(request);
     *     for (software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.ListKeysResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudfrontkeyvaluestore.paginators.ListKeysIterable responses = client.listKeysPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listKeys(software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.ListKeysRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListKeysRequest.Builder} avoiding the need to
     * create one manually via {@link ListKeysRequest#builder()}
     * </p>
     *
     * @param listKeysRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.ListKeysRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ConflictException
     *         Resource is not in expected state.
     * @throws ValidationException
     *         Validation failed.
     * @throws InternalServerException
     *         Internal server error.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontKeyValueStoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontKeyValueStoreClient.ListKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-keyvaluestore-2022-07-26/ListKeys"
     *      target="_top">AWS API Documentation</a>
     */
    default ListKeysIterable listKeysPaginator(Consumer<ListKeysRequest.Builder> listKeysRequest) throws ConflictException,
            ValidationException, InternalServerException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, CloudFrontKeyValueStoreException {
        return listKeysPaginator(ListKeysRequest.builder().applyMutation(listKeysRequest).build());
    }

    /**
     * <p>
     * Creates a new key value pair or replaces the value of an existing key.
     * </p>
     *
     * @param putKeyRequest
     *        A key value pair.
     * @return Result of the PutKey operation returned by the service.
     * @throws ConflictException
     *         Resource is not in expected state.
     * @throws ValidationException
     *         Validation failed.
     * @throws InternalServerException
     *         Internal server error.
     * @throws ServiceQuotaExceededException
     *         Limit exceeded.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontKeyValueStoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontKeyValueStoreClient.PutKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-keyvaluestore-2022-07-26/PutKey"
     *      target="_top">AWS API Documentation</a>
     */
    default PutKeyResponse putKey(PutKeyRequest putKeyRequest) throws ConflictException, ValidationException,
            InternalServerException, ServiceQuotaExceededException, ResourceNotFoundException, AccessDeniedException,
            AwsServiceException, SdkClientException, CloudFrontKeyValueStoreException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new key value pair or replaces the value of an existing key.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutKeyRequest.Builder} avoiding the need to create
     * one manually via {@link PutKeyRequest#builder()}
     * </p>
     *
     * @param putKeyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.PutKeyRequest.Builder} to create a
     *        request. A key value pair.
     * @return Result of the PutKey operation returned by the service.
     * @throws ConflictException
     *         Resource is not in expected state.
     * @throws ValidationException
     *         Validation failed.
     * @throws InternalServerException
     *         Internal server error.
     * @throws ServiceQuotaExceededException
     *         Limit exceeded.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontKeyValueStoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontKeyValueStoreClient.PutKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-keyvaluestore-2022-07-26/PutKey"
     *      target="_top">AWS API Documentation</a>
     */
    default PutKeyResponse putKey(Consumer<PutKeyRequest.Builder> putKeyRequest) throws ConflictException, ValidationException,
            InternalServerException, ServiceQuotaExceededException, ResourceNotFoundException, AccessDeniedException,
            AwsServiceException, SdkClientException, CloudFrontKeyValueStoreException {
        return putKey(PutKeyRequest.builder().applyMutation(putKeyRequest).build());
    }

    /**
     * <p>
     * Puts or Deletes multiple key value pairs in a single, all-or-nothing operation.
     * </p>
     *
     * @param updateKeysRequest
     * @return Result of the UpdateKeys operation returned by the service.
     * @throws ConflictException
     *         Resource is not in expected state.
     * @throws ValidationException
     *         Validation failed.
     * @throws InternalServerException
     *         Internal server error.
     * @throws ServiceQuotaExceededException
     *         Limit exceeded.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontKeyValueStoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontKeyValueStoreClient.UpdateKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-keyvaluestore-2022-07-26/UpdateKeys"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateKeysResponse updateKeys(UpdateKeysRequest updateKeysRequest) throws ConflictException, ValidationException,
            InternalServerException, ServiceQuotaExceededException, ResourceNotFoundException, AccessDeniedException,
            AwsServiceException, SdkClientException, CloudFrontKeyValueStoreException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Puts or Deletes multiple key value pairs in a single, all-or-nothing operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateKeysRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateKeysRequest#builder()}
     * </p>
     *
     * @param updateKeysRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.UpdateKeysRequest.Builder} to create
     *        a request.
     * @return Result of the UpdateKeys operation returned by the service.
     * @throws ConflictException
     *         Resource is not in expected state.
     * @throws ValidationException
     *         Validation failed.
     * @throws InternalServerException
     *         Internal server error.
     * @throws ServiceQuotaExceededException
     *         Limit exceeded.
     * @throws ResourceNotFoundException
     *         Resource was not found.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontKeyValueStoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontKeyValueStoreClient.UpdateKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-keyvaluestore-2022-07-26/UpdateKeys"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateKeysResponse updateKeys(Consumer<UpdateKeysRequest.Builder> updateKeysRequest) throws ConflictException,
            ValidationException, InternalServerException, ServiceQuotaExceededException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, CloudFrontKeyValueStoreException {
        return updateKeys(UpdateKeysRequest.builder().applyMutation(updateKeysRequest).build());
    }

    /**
     * Create a {@link CloudFrontKeyValueStoreClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static CloudFrontKeyValueStoreClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link CloudFrontKeyValueStoreClient}.
     */
    static CloudFrontKeyValueStoreClientBuilder builder() {
        return new DefaultCloudFrontKeyValueStoreClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default CloudFrontKeyValueStoreServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
