/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfrontkeyvaluestore.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Metadata information about a Key Value Store.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateKeysResponse extends CloudFrontKeyValueStoreResponse implements
        ToCopyableBuilder<UpdateKeysResponse.Builder, UpdateKeysResponse> {
    private static final SdkField<Integer> ITEM_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ItemCount").getter(getter(UpdateKeysResponse::itemCount)).setter(setter(Builder::itemCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ItemCount").build()).build();

    private static final SdkField<Long> TOTAL_SIZE_IN_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("TotalSizeInBytes").getter(getter(UpdateKeysResponse::totalSizeInBytes))
            .setter(setter(Builder::totalSizeInBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalSizeInBytes").build()).build();

    private static final SdkField<String> E_TAG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ETag")
            .getter(getter(UpdateKeysResponse::eTag)).setter(setter(Builder::eTag))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("ETag").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ITEM_COUNT_FIELD,
            TOTAL_SIZE_IN_BYTES_FIELD, E_TAG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Integer itemCount;

    private final Long totalSizeInBytes;

    private final String eTag;

    private UpdateKeysResponse(BuilderImpl builder) {
        super(builder);
        this.itemCount = builder.itemCount;
        this.totalSizeInBytes = builder.totalSizeInBytes;
        this.eTag = builder.eTag;
    }

    /**
     * <p>
     * Number of key value pairs in the Key Value Store after the successful update.
     * </p>
     * 
     * @return Number of key value pairs in the Key Value Store after the successful update.
     */
    public final Integer itemCount() {
        return itemCount;
    }

    /**
     * <p>
     * Total size of the Key Value Store after the successful update, in bytes.
     * </p>
     * 
     * @return Total size of the Key Value Store after the successful update, in bytes.
     */
    public final Long totalSizeInBytes() {
        return totalSizeInBytes;
    }

    /**
     * <p>
     * The current version identifier of the Key Value Store after the successful update.
     * </p>
     * 
     * @return The current version identifier of the Key Value Store after the successful update.
     */
    public final String eTag() {
        return eTag;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(itemCount());
        hashCode = 31 * hashCode + Objects.hashCode(totalSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(eTag());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateKeysResponse)) {
            return false;
        }
        UpdateKeysResponse other = (UpdateKeysResponse) obj;
        return Objects.equals(itemCount(), other.itemCount()) && Objects.equals(totalSizeInBytes(), other.totalSizeInBytes())
                && Objects.equals(eTag(), other.eTag());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateKeysResponse").add("ItemCount", itemCount()).add("TotalSizeInBytes", totalSizeInBytes())
                .add("ETag", eTag()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ItemCount":
            return Optional.ofNullable(clazz.cast(itemCount()));
        case "TotalSizeInBytes":
            return Optional.ofNullable(clazz.cast(totalSizeInBytes()));
        case "ETag":
            return Optional.ofNullable(clazz.cast(eTag()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ItemCount", ITEM_COUNT_FIELD);
        map.put("TotalSizeInBytes", TOTAL_SIZE_IN_BYTES_FIELD);
        map.put("ETag", E_TAG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateKeysResponse, T> g) {
        return obj -> g.apply((UpdateKeysResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudFrontKeyValueStoreResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateKeysResponse> {
        /**
         * <p>
         * Number of key value pairs in the Key Value Store after the successful update.
         * </p>
         * 
         * @param itemCount
         *        Number of key value pairs in the Key Value Store after the successful update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder itemCount(Integer itemCount);

        /**
         * <p>
         * Total size of the Key Value Store after the successful update, in bytes.
         * </p>
         * 
         * @param totalSizeInBytes
         *        Total size of the Key Value Store after the successful update, in bytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalSizeInBytes(Long totalSizeInBytes);

        /**
         * <p>
         * The current version identifier of the Key Value Store after the successful update.
         * </p>
         * 
         * @param eTag
         *        The current version identifier of the Key Value Store after the successful update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eTag(String eTag);
    }

    static final class BuilderImpl extends CloudFrontKeyValueStoreResponse.BuilderImpl implements Builder {
        private Integer itemCount;

        private Long totalSizeInBytes;

        private String eTag;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateKeysResponse model) {
            super(model);
            itemCount(model.itemCount);
            totalSizeInBytes(model.totalSizeInBytes);
            eTag(model.eTag);
        }

        public final Integer getItemCount() {
            return itemCount;
        }

        public final void setItemCount(Integer itemCount) {
            this.itemCount = itemCount;
        }

        @Override
        public final Builder itemCount(Integer itemCount) {
            this.itemCount = itemCount;
            return this;
        }

        public final Long getTotalSizeInBytes() {
            return totalSizeInBytes;
        }

        public final void setTotalSizeInBytes(Long totalSizeInBytes) {
            this.totalSizeInBytes = totalSizeInBytes;
        }

        @Override
        public final Builder totalSizeInBytes(Long totalSizeInBytes) {
            this.totalSizeInBytes = totalSizeInBytes;
            return this;
        }

        public final String getETag() {
            return eTag;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        @Override
        public UpdateKeysResponse build() {
            return new UpdateKeysResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
