/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudhsm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of the <a>DescribeHsm</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeHsmResponse extends CloudHsmResponse implements
        ToCopyableBuilder<DescribeHsmResponse.Builder, DescribeHsmResponse> {
    private static final SdkField<String> HSM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("HsmArn")
            .getter(getter(DescribeHsmResponse::hsmArn)).setter(setter(Builder::hsmArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HsmArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribeHsmResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_DETAILS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusDetails").getter(getter(DescribeHsmResponse::statusDetails))
            .setter(setter(Builder::statusDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusDetails").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone").getter(getter(DescribeHsmResponse::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()).build();

    private static final SdkField<String> ENI_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("EniId")
            .getter(getter(DescribeHsmResponse::eniId)).setter(setter(Builder::eniId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EniId").build()).build();

    private static final SdkField<String> ENI_IP_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("EniIp")
            .getter(getter(DescribeHsmResponse::eniIp)).setter(setter(Builder::eniIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EniIp").build()).build();

    private static final SdkField<String> SUBSCRIPTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubscriptionType").getter(getter(DescribeHsmResponse::subscriptionTypeAsString))
            .setter(setter(Builder::subscriptionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscriptionType").build()).build();

    private static final SdkField<String> SUBSCRIPTION_START_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubscriptionStartDate").getter(getter(DescribeHsmResponse::subscriptionStartDate))
            .setter(setter(Builder::subscriptionStartDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscriptionStartDate").build())
            .build();

    private static final SdkField<String> SUBSCRIPTION_END_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubscriptionEndDate").getter(getter(DescribeHsmResponse::subscriptionEndDate))
            .setter(setter(Builder::subscriptionEndDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscriptionEndDate").build())
            .build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("VpcId")
            .getter(getter(DescribeHsmResponse::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()).build();

    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubnetId").getter(getter(DescribeHsmResponse::subnetId)).setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").build()).build();

    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IamRoleArn").getter(getter(DescribeHsmResponse::iamRoleArn)).setter(setter(Builder::iamRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()).build();

    private static final SdkField<String> SERIAL_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SerialNumber").getter(getter(DescribeHsmResponse::serialNumber)).setter(setter(Builder::serialNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SerialNumber").build()).build();

    private static final SdkField<String> VENDOR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VendorName").getter(getter(DescribeHsmResponse::vendorName)).setter(setter(Builder::vendorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VendorName").build()).build();

    private static final SdkField<String> HSM_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HsmType").getter(getter(DescribeHsmResponse::hsmType)).setter(setter(Builder::hsmType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HsmType").build()).build();

    private static final SdkField<String> SOFTWARE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SoftwareVersion").getter(getter(DescribeHsmResponse::softwareVersion))
            .setter(setter(Builder::softwareVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SoftwareVersion").build()).build();

    private static final SdkField<String> SSH_PUBLIC_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SshPublicKey").getter(getter(DescribeHsmResponse::sshPublicKey)).setter(setter(Builder::sshPublicKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SshPublicKey").build()).build();

    private static final SdkField<String> SSH_KEY_LAST_UPDATED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SshKeyLastUpdated").getter(getter(DescribeHsmResponse::sshKeyLastUpdated))
            .setter(setter(Builder::sshKeyLastUpdated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SshKeyLastUpdated").build()).build();

    private static final SdkField<String> SERVER_CERT_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServerCertUri").getter(getter(DescribeHsmResponse::serverCertUri))
            .setter(setter(Builder::serverCertUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerCertUri").build()).build();

    private static final SdkField<String> SERVER_CERT_LAST_UPDATED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServerCertLastUpdated").getter(getter(DescribeHsmResponse::serverCertLastUpdated))
            .setter(setter(Builder::serverCertLastUpdated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerCertLastUpdated").build())
            .build();

    private static final SdkField<List<String>> PARTITIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Partitions")
            .getter(getter(DescribeHsmResponse::partitions))
            .setter(setter(Builder::partitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Partitions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HSM_ARN_FIELD, STATUS_FIELD,
            STATUS_DETAILS_FIELD, AVAILABILITY_ZONE_FIELD, ENI_ID_FIELD, ENI_IP_FIELD, SUBSCRIPTION_TYPE_FIELD,
            SUBSCRIPTION_START_DATE_FIELD, SUBSCRIPTION_END_DATE_FIELD, VPC_ID_FIELD, SUBNET_ID_FIELD, IAM_ROLE_ARN_FIELD,
            SERIAL_NUMBER_FIELD, VENDOR_NAME_FIELD, HSM_TYPE_FIELD, SOFTWARE_VERSION_FIELD, SSH_PUBLIC_KEY_FIELD,
            SSH_KEY_LAST_UPDATED_FIELD, SERVER_CERT_URI_FIELD, SERVER_CERT_LAST_UPDATED_FIELD, PARTITIONS_FIELD));

    private final String hsmArn;

    private final String status;

    private final String statusDetails;

    private final String availabilityZone;

    private final String eniId;

    private final String eniIp;

    private final String subscriptionType;

    private final String subscriptionStartDate;

    private final String subscriptionEndDate;

    private final String vpcId;

    private final String subnetId;

    private final String iamRoleArn;

    private final String serialNumber;

    private final String vendorName;

    private final String hsmType;

    private final String softwareVersion;

    private final String sshPublicKey;

    private final String sshKeyLastUpdated;

    private final String serverCertUri;

    private final String serverCertLastUpdated;

    private final List<String> partitions;

    private DescribeHsmResponse(BuilderImpl builder) {
        super(builder);
        this.hsmArn = builder.hsmArn;
        this.status = builder.status;
        this.statusDetails = builder.statusDetails;
        this.availabilityZone = builder.availabilityZone;
        this.eniId = builder.eniId;
        this.eniIp = builder.eniIp;
        this.subscriptionType = builder.subscriptionType;
        this.subscriptionStartDate = builder.subscriptionStartDate;
        this.subscriptionEndDate = builder.subscriptionEndDate;
        this.vpcId = builder.vpcId;
        this.subnetId = builder.subnetId;
        this.iamRoleArn = builder.iamRoleArn;
        this.serialNumber = builder.serialNumber;
        this.vendorName = builder.vendorName;
        this.hsmType = builder.hsmType;
        this.softwareVersion = builder.softwareVersion;
        this.sshPublicKey = builder.sshPublicKey;
        this.sshKeyLastUpdated = builder.sshKeyLastUpdated;
        this.serverCertUri = builder.serverCertUri;
        this.serverCertLastUpdated = builder.serverCertLastUpdated;
        this.partitions = builder.partitions;
    }

    /**
     * <p>
     * The ARN of the HSM.
     * </p>
     * 
     * @return The ARN of the HSM.
     */
    public final String hsmArn() {
        return hsmArn;
    }

    /**
     * <p>
     * The status of the HSM.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link HsmStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the HSM.
     * @see HsmStatus
     */
    public final HsmStatus status() {
        return HsmStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the HSM.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link HsmStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the HSM.
     * @see HsmStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Contains additional information about the status of the HSM.
     * </p>
     * 
     * @return Contains additional information about the status of the HSM.
     */
    public final String statusDetails() {
        return statusDetails;
    }

    /**
     * <p>
     * The Availability Zone that the HSM is in.
     * </p>
     * 
     * @return The Availability Zone that the HSM is in.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The identifier of the elastic network interface (ENI) attached to the HSM.
     * </p>
     * 
     * @return The identifier of the elastic network interface (ENI) attached to the HSM.
     */
    public final String eniId() {
        return eniId;
    }

    /**
     * <p>
     * The IP address assigned to the HSM's ENI.
     * </p>
     * 
     * @return The IP address assigned to the HSM's ENI.
     */
    public final String eniIp() {
        return eniIp;
    }

    /**
     * Returns the value of the SubscriptionType property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #subscriptionType}
     * will return {@link SubscriptionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #subscriptionTypeAsString}.
     * </p>
     * 
     * @return The value of the SubscriptionType property for this object.
     * @see SubscriptionType
     */
    public final SubscriptionType subscriptionType() {
        return SubscriptionType.fromValue(subscriptionType);
    }

    /**
     * Returns the value of the SubscriptionType property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #subscriptionType}
     * will return {@link SubscriptionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #subscriptionTypeAsString}.
     * </p>
     * 
     * @return The value of the SubscriptionType property for this object.
     * @see SubscriptionType
     */
    public final String subscriptionTypeAsString() {
        return subscriptionType;
    }

    /**
     * <p>
     * The subscription start date.
     * </p>
     * 
     * @return The subscription start date.
     */
    public final String subscriptionStartDate() {
        return subscriptionStartDate;
    }

    /**
     * <p>
     * The subscription end date.
     * </p>
     * 
     * @return The subscription end date.
     */
    public final String subscriptionEndDate() {
        return subscriptionEndDate;
    }

    /**
     * <p>
     * The identifier of the VPC that the HSM is in.
     * </p>
     * 
     * @return The identifier of the VPC that the HSM is in.
     */
    public final String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * The identifier of the subnet that the HSM is in.
     * </p>
     * 
     * @return The identifier of the subnet that the HSM is in.
     */
    public final String subnetId() {
        return subnetId;
    }

    /**
     * <p>
     * The ARN of the IAM role assigned to the HSM.
     * </p>
     * 
     * @return The ARN of the IAM role assigned to the HSM.
     */
    public final String iamRoleArn() {
        return iamRoleArn;
    }

    /**
     * <p>
     * The serial number of the HSM.
     * </p>
     * 
     * @return The serial number of the HSM.
     */
    public final String serialNumber() {
        return serialNumber;
    }

    /**
     * <p>
     * The name of the HSM vendor.
     * </p>
     * 
     * @return The name of the HSM vendor.
     */
    public final String vendorName() {
        return vendorName;
    }

    /**
     * <p>
     * The HSM model type.
     * </p>
     * 
     * @return The HSM model type.
     */
    public final String hsmType() {
        return hsmType;
    }

    /**
     * <p>
     * The HSM software version.
     * </p>
     * 
     * @return The HSM software version.
     */
    public final String softwareVersion() {
        return softwareVersion;
    }

    /**
     * <p>
     * The public SSH key.
     * </p>
     * 
     * @return The public SSH key.
     */
    public final String sshPublicKey() {
        return sshPublicKey;
    }

    /**
     * <p>
     * The date and time that the SSH key was last updated.
     * </p>
     * 
     * @return The date and time that the SSH key was last updated.
     */
    public final String sshKeyLastUpdated() {
        return sshKeyLastUpdated;
    }

    /**
     * <p>
     * The URI of the certificate server.
     * </p>
     * 
     * @return The URI of the certificate server.
     */
    public final String serverCertUri() {
        return serverCertUri;
    }

    /**
     * <p>
     * The date and time that the server certificate was last updated.
     * </p>
     * 
     * @return The date and time that the server certificate was last updated.
     */
    public final String serverCertLastUpdated() {
        return serverCertLastUpdated;
    }

    /**
     * Returns true if the Partitions property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasPartitions() {
        return partitions != null && !(partitions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of partitions on the HSM.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPartitions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of partitions on the HSM.
     */
    public final List<String> partitions() {
        return partitions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hsmArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(eniId());
        hashCode = 31 * hashCode + Objects.hashCode(eniIp());
        hashCode = 31 * hashCode + Objects.hashCode(subscriptionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(subscriptionStartDate());
        hashCode = 31 * hashCode + Objects.hashCode(subscriptionEndDate());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(serialNumber());
        hashCode = 31 * hashCode + Objects.hashCode(vendorName());
        hashCode = 31 * hashCode + Objects.hashCode(hsmType());
        hashCode = 31 * hashCode + Objects.hashCode(softwareVersion());
        hashCode = 31 * hashCode + Objects.hashCode(sshPublicKey());
        hashCode = 31 * hashCode + Objects.hashCode(sshKeyLastUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(serverCertUri());
        hashCode = 31 * hashCode + Objects.hashCode(serverCertLastUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(hasPartitions() ? partitions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeHsmResponse)) {
            return false;
        }
        DescribeHsmResponse other = (DescribeHsmResponse) obj;
        return Objects.equals(hsmArn(), other.hsmArn()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusDetails(), other.statusDetails())
                && Objects.equals(availabilityZone(), other.availabilityZone()) && Objects.equals(eniId(), other.eniId())
                && Objects.equals(eniIp(), other.eniIp())
                && Objects.equals(subscriptionTypeAsString(), other.subscriptionTypeAsString())
                && Objects.equals(subscriptionStartDate(), other.subscriptionStartDate())
                && Objects.equals(subscriptionEndDate(), other.subscriptionEndDate()) && Objects.equals(vpcId(), other.vpcId())
                && Objects.equals(subnetId(), other.subnetId()) && Objects.equals(iamRoleArn(), other.iamRoleArn())
                && Objects.equals(serialNumber(), other.serialNumber()) && Objects.equals(vendorName(), other.vendorName())
                && Objects.equals(hsmType(), other.hsmType()) && Objects.equals(softwareVersion(), other.softwareVersion())
                && Objects.equals(sshPublicKey(), other.sshPublicKey())
                && Objects.equals(sshKeyLastUpdated(), other.sshKeyLastUpdated())
                && Objects.equals(serverCertUri(), other.serverCertUri())
                && Objects.equals(serverCertLastUpdated(), other.serverCertLastUpdated())
                && hasPartitions() == other.hasPartitions() && Objects.equals(partitions(), other.partitions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeHsmResponse").add("HsmArn", hsmArn()).add("Status", statusAsString())
                .add("StatusDetails", statusDetails()).add("AvailabilityZone", availabilityZone()).add("EniId", eniId())
                .add("EniIp", eniIp()).add("SubscriptionType", subscriptionTypeAsString())
                .add("SubscriptionStartDate", subscriptionStartDate()).add("SubscriptionEndDate", subscriptionEndDate())
                .add("VpcId", vpcId()).add("SubnetId", subnetId()).add("IamRoleArn", iamRoleArn())
                .add("SerialNumber", serialNumber()).add("VendorName", vendorName()).add("HsmType", hsmType())
                .add("SoftwareVersion", softwareVersion()).add("SshPublicKey", sshPublicKey())
                .add("SshKeyLastUpdated", sshKeyLastUpdated()).add("ServerCertUri", serverCertUri())
                .add("ServerCertLastUpdated", serverCertLastUpdated()).add("Partitions", hasPartitions() ? partitions() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HsmArn":
            return Optional.ofNullable(clazz.cast(hsmArn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusDetails":
            return Optional.ofNullable(clazz.cast(statusDetails()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "EniId":
            return Optional.ofNullable(clazz.cast(eniId()));
        case "EniIp":
            return Optional.ofNullable(clazz.cast(eniIp()));
        case "SubscriptionType":
            return Optional.ofNullable(clazz.cast(subscriptionTypeAsString()));
        case "SubscriptionStartDate":
            return Optional.ofNullable(clazz.cast(subscriptionStartDate()));
        case "SubscriptionEndDate":
            return Optional.ofNullable(clazz.cast(subscriptionEndDate()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "SubnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        case "IamRoleArn":
            return Optional.ofNullable(clazz.cast(iamRoleArn()));
        case "SerialNumber":
            return Optional.ofNullable(clazz.cast(serialNumber()));
        case "VendorName":
            return Optional.ofNullable(clazz.cast(vendorName()));
        case "HsmType":
            return Optional.ofNullable(clazz.cast(hsmType()));
        case "SoftwareVersion":
            return Optional.ofNullable(clazz.cast(softwareVersion()));
        case "SshPublicKey":
            return Optional.ofNullable(clazz.cast(sshPublicKey()));
        case "SshKeyLastUpdated":
            return Optional.ofNullable(clazz.cast(sshKeyLastUpdated()));
        case "ServerCertUri":
            return Optional.ofNullable(clazz.cast(serverCertUri()));
        case "ServerCertLastUpdated":
            return Optional.ofNullable(clazz.cast(serverCertLastUpdated()));
        case "Partitions":
            return Optional.ofNullable(clazz.cast(partitions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeHsmResponse, T> g) {
        return obj -> g.apply((DescribeHsmResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudHsmResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeHsmResponse> {
        /**
         * <p>
         * The ARN of the HSM.
         * </p>
         * 
         * @param hsmArn
         *        The ARN of the HSM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hsmArn(String hsmArn);

        /**
         * <p>
         * The status of the HSM.
         * </p>
         * 
         * @param status
         *        The status of the HSM.
         * @see HsmStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HsmStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the HSM.
         * </p>
         * 
         * @param status
         *        The status of the HSM.
         * @see HsmStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HsmStatus
         */
        Builder status(HsmStatus status);

        /**
         * <p>
         * Contains additional information about the status of the HSM.
         * </p>
         * 
         * @param statusDetails
         *        Contains additional information about the status of the HSM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusDetails(String statusDetails);

        /**
         * <p>
         * The Availability Zone that the HSM is in.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone that the HSM is in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The identifier of the elastic network interface (ENI) attached to the HSM.
         * </p>
         * 
         * @param eniId
         *        The identifier of the elastic network interface (ENI) attached to the HSM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eniId(String eniId);

        /**
         * <p>
         * The IP address assigned to the HSM's ENI.
         * </p>
         * 
         * @param eniIp
         *        The IP address assigned to the HSM's ENI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eniIp(String eniIp);

        /**
         * Sets the value of the SubscriptionType property for this object.
         *
         * @param subscriptionType
         *        The new value for the SubscriptionType property for this object.
         * @see SubscriptionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SubscriptionType
         */
        Builder subscriptionType(String subscriptionType);

        /**
         * Sets the value of the SubscriptionType property for this object.
         *
         * @param subscriptionType
         *        The new value for the SubscriptionType property for this object.
         * @see SubscriptionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SubscriptionType
         */
        Builder subscriptionType(SubscriptionType subscriptionType);

        /**
         * <p>
         * The subscription start date.
         * </p>
         * 
         * @param subscriptionStartDate
         *        The subscription start date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptionStartDate(String subscriptionStartDate);

        /**
         * <p>
         * The subscription end date.
         * </p>
         * 
         * @param subscriptionEndDate
         *        The subscription end date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptionEndDate(String subscriptionEndDate);

        /**
         * <p>
         * The identifier of the VPC that the HSM is in.
         * </p>
         * 
         * @param vpcId
         *        The identifier of the VPC that the HSM is in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * The identifier of the subnet that the HSM is in.
         * </p>
         * 
         * @param subnetId
         *        The identifier of the subnet that the HSM is in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * The ARN of the IAM role assigned to the HSM.
         * </p>
         * 
         * @param iamRoleArn
         *        The ARN of the IAM role assigned to the HSM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRoleArn(String iamRoleArn);

        /**
         * <p>
         * The serial number of the HSM.
         * </p>
         * 
         * @param serialNumber
         *        The serial number of the HSM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serialNumber(String serialNumber);

        /**
         * <p>
         * The name of the HSM vendor.
         * </p>
         * 
         * @param vendorName
         *        The name of the HSM vendor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vendorName(String vendorName);

        /**
         * <p>
         * The HSM model type.
         * </p>
         * 
         * @param hsmType
         *        The HSM model type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hsmType(String hsmType);

        /**
         * <p>
         * The HSM software version.
         * </p>
         * 
         * @param softwareVersion
         *        The HSM software version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder softwareVersion(String softwareVersion);

        /**
         * <p>
         * The public SSH key.
         * </p>
         * 
         * @param sshPublicKey
         *        The public SSH key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sshPublicKey(String sshPublicKey);

        /**
         * <p>
         * The date and time that the SSH key was last updated.
         * </p>
         * 
         * @param sshKeyLastUpdated
         *        The date and time that the SSH key was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sshKeyLastUpdated(String sshKeyLastUpdated);

        /**
         * <p>
         * The URI of the certificate server.
         * </p>
         * 
         * @param serverCertUri
         *        The URI of the certificate server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverCertUri(String serverCertUri);

        /**
         * <p>
         * The date and time that the server certificate was last updated.
         * </p>
         * 
         * @param serverCertLastUpdated
         *        The date and time that the server certificate was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverCertLastUpdated(String serverCertLastUpdated);

        /**
         * <p>
         * The list of partitions on the HSM.
         * </p>
         * 
         * @param partitions
         *        The list of partitions on the HSM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitions(Collection<String> partitions);

        /**
         * <p>
         * The list of partitions on the HSM.
         * </p>
         * 
         * @param partitions
         *        The list of partitions on the HSM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitions(String... partitions);
    }

    static final class BuilderImpl extends CloudHsmResponse.BuilderImpl implements Builder {
        private String hsmArn;

        private String status;

        private String statusDetails;

        private String availabilityZone;

        private String eniId;

        private String eniIp;

        private String subscriptionType;

        private String subscriptionStartDate;

        private String subscriptionEndDate;

        private String vpcId;

        private String subnetId;

        private String iamRoleArn;

        private String serialNumber;

        private String vendorName;

        private String hsmType;

        private String softwareVersion;

        private String sshPublicKey;

        private String sshKeyLastUpdated;

        private String serverCertUri;

        private String serverCertLastUpdated;

        private List<String> partitions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeHsmResponse model) {
            super(model);
            hsmArn(model.hsmArn);
            status(model.status);
            statusDetails(model.statusDetails);
            availabilityZone(model.availabilityZone);
            eniId(model.eniId);
            eniIp(model.eniIp);
            subscriptionType(model.subscriptionType);
            subscriptionStartDate(model.subscriptionStartDate);
            subscriptionEndDate(model.subscriptionEndDate);
            vpcId(model.vpcId);
            subnetId(model.subnetId);
            iamRoleArn(model.iamRoleArn);
            serialNumber(model.serialNumber);
            vendorName(model.vendorName);
            hsmType(model.hsmType);
            softwareVersion(model.softwareVersion);
            sshPublicKey(model.sshPublicKey);
            sshKeyLastUpdated(model.sshKeyLastUpdated);
            serverCertUri(model.serverCertUri);
            serverCertLastUpdated(model.serverCertLastUpdated);
            partitions(model.partitions);
        }

        public final String getHsmArn() {
            return hsmArn;
        }

        @Override
        public final Builder hsmArn(String hsmArn) {
            this.hsmArn = hsmArn;
            return this;
        }

        public final void setHsmArn(String hsmArn) {
            this.hsmArn = hsmArn;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(HsmStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusDetails() {
            return statusDetails;
        }

        @Override
        public final Builder statusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
            return this;
        }

        public final void setStatusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getEniId() {
            return eniId;
        }

        @Override
        public final Builder eniId(String eniId) {
            this.eniId = eniId;
            return this;
        }

        public final void setEniId(String eniId) {
            this.eniId = eniId;
        }

        public final String getEniIp() {
            return eniIp;
        }

        @Override
        public final Builder eniIp(String eniIp) {
            this.eniIp = eniIp;
            return this;
        }

        public final void setEniIp(String eniIp) {
            this.eniIp = eniIp;
        }

        public final String getSubscriptionType() {
            return subscriptionType;
        }

        @Override
        public final Builder subscriptionType(String subscriptionType) {
            this.subscriptionType = subscriptionType;
            return this;
        }

        @Override
        public final Builder subscriptionType(SubscriptionType subscriptionType) {
            this.subscriptionType(subscriptionType == null ? null : subscriptionType.toString());
            return this;
        }

        public final void setSubscriptionType(String subscriptionType) {
            this.subscriptionType = subscriptionType;
        }

        public final String getSubscriptionStartDate() {
            return subscriptionStartDate;
        }

        @Override
        public final Builder subscriptionStartDate(String subscriptionStartDate) {
            this.subscriptionStartDate = subscriptionStartDate;
            return this;
        }

        public final void setSubscriptionStartDate(String subscriptionStartDate) {
            this.subscriptionStartDate = subscriptionStartDate;
        }

        public final String getSubscriptionEndDate() {
            return subscriptionEndDate;
        }

        @Override
        public final Builder subscriptionEndDate(String subscriptionEndDate) {
            this.subscriptionEndDate = subscriptionEndDate;
            return this;
        }

        public final void setSubscriptionEndDate(String subscriptionEndDate) {
            this.subscriptionEndDate = subscriptionEndDate;
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final String getIamRoleArn() {
            return iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        public final String getSerialNumber() {
            return serialNumber;
        }

        @Override
        public final Builder serialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            return this;
        }

        public final void setSerialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
        }

        public final String getVendorName() {
            return vendorName;
        }

        @Override
        public final Builder vendorName(String vendorName) {
            this.vendorName = vendorName;
            return this;
        }

        public final void setVendorName(String vendorName) {
            this.vendorName = vendorName;
        }

        public final String getHsmType() {
            return hsmType;
        }

        @Override
        public final Builder hsmType(String hsmType) {
            this.hsmType = hsmType;
            return this;
        }

        public final void setHsmType(String hsmType) {
            this.hsmType = hsmType;
        }

        public final String getSoftwareVersion() {
            return softwareVersion;
        }

        @Override
        public final Builder softwareVersion(String softwareVersion) {
            this.softwareVersion = softwareVersion;
            return this;
        }

        public final void setSoftwareVersion(String softwareVersion) {
            this.softwareVersion = softwareVersion;
        }

        public final String getSshPublicKey() {
            return sshPublicKey;
        }

        @Override
        public final Builder sshPublicKey(String sshPublicKey) {
            this.sshPublicKey = sshPublicKey;
            return this;
        }

        public final void setSshPublicKey(String sshPublicKey) {
            this.sshPublicKey = sshPublicKey;
        }

        public final String getSshKeyLastUpdated() {
            return sshKeyLastUpdated;
        }

        @Override
        public final Builder sshKeyLastUpdated(String sshKeyLastUpdated) {
            this.sshKeyLastUpdated = sshKeyLastUpdated;
            return this;
        }

        public final void setSshKeyLastUpdated(String sshKeyLastUpdated) {
            this.sshKeyLastUpdated = sshKeyLastUpdated;
        }

        public final String getServerCertUri() {
            return serverCertUri;
        }

        @Override
        public final Builder serverCertUri(String serverCertUri) {
            this.serverCertUri = serverCertUri;
            return this;
        }

        public final void setServerCertUri(String serverCertUri) {
            this.serverCertUri = serverCertUri;
        }

        public final String getServerCertLastUpdated() {
            return serverCertLastUpdated;
        }

        @Override
        public final Builder serverCertLastUpdated(String serverCertLastUpdated) {
            this.serverCertLastUpdated = serverCertLastUpdated;
            return this;
        }

        public final void setServerCertLastUpdated(String serverCertLastUpdated) {
            this.serverCertLastUpdated = serverCertLastUpdated;
        }

        public final Collection<String> getPartitions() {
            if (partitions instanceof SdkAutoConstructList) {
                return null;
            }
            return partitions;
        }

        @Override
        public final Builder partitions(Collection<String> partitions) {
            this.partitions = PartitionListCopier.copy(partitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitions(String... partitions) {
            partitions(Arrays.asList(partitions));
            return this;
        }

        public final void setPartitions(Collection<String> partitions) {
            this.partitions = PartitionListCopier.copy(partitions);
        }

        @Override
        public DescribeHsmResponse build() {
            return new DescribeHsmResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
