/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudhsm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetConfigResponse extends CloudHsmResponse implements
        ToCopyableBuilder<GetConfigResponse.Builder, GetConfigResponse> {
    private static final SdkField<String> CONFIG_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigType").getter(getter(GetConfigResponse::configType)).setter(setter(Builder::configType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigType").build()).build();

    private static final SdkField<String> CONFIG_FILE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigFile").getter(getter(GetConfigResponse::configFile)).setter(setter(Builder::configFile))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigFile").build()).build();

    private static final SdkField<String> CONFIG_CRED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigCred").getter(getter(GetConfigResponse::configCred)).setter(setter(Builder::configCred))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigCred").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIG_TYPE_FIELD,
            CONFIG_FILE_FIELD, CONFIG_CRED_FIELD));

    private final String configType;

    private final String configFile;

    private final String configCred;

    private GetConfigResponse(BuilderImpl builder) {
        super(builder);
        this.configType = builder.configType;
        this.configFile = builder.configFile;
        this.configCred = builder.configCred;
    }

    /**
     * <p>
     * The type of credentials.
     * </p>
     * 
     * @return The type of credentials.
     */
    public final String configType() {
        return configType;
    }

    /**
     * <p>
     * The chrystoki.conf configuration file.
     * </p>
     * 
     * @return The chrystoki.conf configuration file.
     */
    public final String configFile() {
        return configFile;
    }

    /**
     * <p>
     * The certificate file containing the server.pem files of the HSMs.
     * </p>
     * 
     * @return The certificate file containing the server.pem files of the HSMs.
     */
    public final String configCred() {
        return configCred;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configType());
        hashCode = 31 * hashCode + Objects.hashCode(configFile());
        hashCode = 31 * hashCode + Objects.hashCode(configCred());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConfigResponse)) {
            return false;
        }
        GetConfigResponse other = (GetConfigResponse) obj;
        return Objects.equals(configType(), other.configType()) && Objects.equals(configFile(), other.configFile())
                && Objects.equals(configCred(), other.configCred());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetConfigResponse").add("ConfigType", configType()).add("ConfigFile", configFile())
                .add("ConfigCred", configCred()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigType":
            return Optional.ofNullable(clazz.cast(configType()));
        case "ConfigFile":
            return Optional.ofNullable(clazz.cast(configFile()));
        case "ConfigCred":
            return Optional.ofNullable(clazz.cast(configCred()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetConfigResponse, T> g) {
        return obj -> g.apply((GetConfigResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudHsmResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetConfigResponse> {
        /**
         * <p>
         * The type of credentials.
         * </p>
         * 
         * @param configType
         *        The type of credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configType(String configType);

        /**
         * <p>
         * The chrystoki.conf configuration file.
         * </p>
         * 
         * @param configFile
         *        The chrystoki.conf configuration file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configFile(String configFile);

        /**
         * <p>
         * The certificate file containing the server.pem files of the HSMs.
         * </p>
         * 
         * @param configCred
         *        The certificate file containing the server.pem files of the HSMs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configCred(String configCred);
    }

    static final class BuilderImpl extends CloudHsmResponse.BuilderImpl implements Builder {
        private String configType;

        private String configFile;

        private String configCred;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConfigResponse model) {
            super(model);
            configType(model.configType);
            configFile(model.configFile);
            configCred(model.configCred);
        }

        public final String getConfigType() {
            return configType;
        }

        @Override
        public final Builder configType(String configType) {
            this.configType = configType;
            return this;
        }

        public final void setConfigType(String configType) {
            this.configType = configType;
        }

        public final String getConfigFile() {
            return configFile;
        }

        @Override
        public final Builder configFile(String configFile) {
            this.configFile = configFile;
            return this;
        }

        public final void setConfigFile(String configFile) {
            this.configFile = configFile;
        }

        public final String getConfigCred() {
            return configCred;
        }

        @Override
        public final Builder configCred(String configCred) {
            this.configCred = configCred;
            return this;
        }

        public final void setConfigCred(String configCred) {
            this.configCred = configCred;
        }

        @Override
        public GetConfigResponse build() {
            return new GetConfigResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
