/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudhsm.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the inputs for the <a>CreateLunaClient</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateLunaClientRequest extends CloudHsmRequest implements
        ToCopyableBuilder<CreateLunaClientRequest.Builder, CreateLunaClientRequest> {
    private static final SdkField<String> LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Label")
            .getter(getter(CreateLunaClientRequest::label)).setter(setter(Builder::label))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Label").build()).build();

    private static final SdkField<String> CERTIFICATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Certificate").getter(getter(CreateLunaClientRequest::certificate)).setter(setter(Builder::certificate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Certificate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(LABEL_FIELD, CERTIFICATE_FIELD));

    private final String label;

    private final String certificate;

    private CreateLunaClientRequest(BuilderImpl builder) {
        super(builder);
        this.label = builder.label;
        this.certificate = builder.certificate;
    }

    /**
     * <p>
     * The label for the client.
     * </p>
     * 
     * @return The label for the client.
     */
    public final String label() {
        return label;
    }

    /**
     * <p>
     * The contents of a Base64-Encoded X.509 v3 certificate to be installed on the HSMs used by this client.
     * </p>
     * 
     * @return The contents of a Base64-Encoded X.509 v3 certificate to be installed on the HSMs used by this client.
     */
    public final String certificate() {
        return certificate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(label());
        hashCode = 31 * hashCode + Objects.hashCode(certificate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLunaClientRequest)) {
            return false;
        }
        CreateLunaClientRequest other = (CreateLunaClientRequest) obj;
        return Objects.equals(label(), other.label()) && Objects.equals(certificate(), other.certificate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateLunaClientRequest").add("Label", label()).add("Certificate", certificate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Label":
            return Optional.ofNullable(clazz.cast(label()));
        case "Certificate":
            return Optional.ofNullable(clazz.cast(certificate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateLunaClientRequest, T> g) {
        return obj -> g.apply((CreateLunaClientRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudHsmRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateLunaClientRequest> {
        /**
         * <p>
         * The label for the client.
         * </p>
         * 
         * @param label
         *        The label for the client.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder label(String label);

        /**
         * <p>
         * The contents of a Base64-Encoded X.509 v3 certificate to be installed on the HSMs used by this client.
         * </p>
         * 
         * @param certificate
         *        The contents of a Base64-Encoded X.509 v3 certificate to be installed on the HSMs used by this client.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificate(String certificate);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudHsmRequest.BuilderImpl implements Builder {
        private String label;

        private String certificate;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLunaClientRequest model) {
            super(model);
            label(model.label);
            certificate(model.certificate);
        }

        public final String getLabel() {
            return label;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        @Override
        @Transient
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        public final String getCertificate() {
            return certificate;
        }

        public final void setCertificate(String certificate) {
            this.certificate = certificate;
        }

        @Override
        @Transient
        public final Builder certificate(String certificate) {
            this.certificate = certificate;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLunaClientRequest build() {
            return new CreateLunaClientRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
