/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudhsm.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the inputs for the <a>DeleteHsm</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteHsmRequest extends CloudHsmRequest implements
        ToCopyableBuilder<DeleteHsmRequest.Builder, DeleteHsmRequest> {
    private static final SdkField<String> HSM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("HsmArn")
            .getter(getter(DeleteHsmRequest::hsmArn)).setter(setter(Builder::hsmArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HsmArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HSM_ARN_FIELD));

    private final String hsmArn;

    private DeleteHsmRequest(BuilderImpl builder) {
        super(builder);
        this.hsmArn = builder.hsmArn;
    }

    /**
     * <p>
     * The ARN of the HSM to delete.
     * </p>
     * 
     * @return The ARN of the HSM to delete.
     */
    public final String hsmArn() {
        return hsmArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hsmArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteHsmRequest)) {
            return false;
        }
        DeleteHsmRequest other = (DeleteHsmRequest) obj;
        return Objects.equals(hsmArn(), other.hsmArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteHsmRequest").add("HsmArn", hsmArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HsmArn":
            return Optional.ofNullable(clazz.cast(hsmArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteHsmRequest, T> g) {
        return obj -> g.apply((DeleteHsmRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudHsmRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteHsmRequest> {
        /**
         * <p>
         * The ARN of the HSM to delete.
         * </p>
         * 
         * @param hsmArn
         *        The ARN of the HSM to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hsmArn(String hsmArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudHsmRequest.BuilderImpl implements Builder {
        private String hsmArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteHsmRequest model) {
            super(model);
            hsmArn(model.hsmArn);
        }

        public final String getHsmArn() {
            return hsmArn;
        }

        public final void setHsmArn(String hsmArn) {
            this.hsmArn = hsmArn;
        }

        @Override
        @Transient
        public final Builder hsmArn(String hsmArn) {
            this.hsmArn = hsmArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteHsmRequest build() {
            return new DeleteHsmRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
