/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudhsm.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeLunaClientResponse extends CloudHsmResponse implements
        ToCopyableBuilder<DescribeLunaClientResponse.Builder, DescribeLunaClientResponse> {
    private static final SdkField<String> CLIENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientArn").getter(getter(DescribeLunaClientResponse::clientArn)).setter(setter(Builder::clientArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientArn").build()).build();

    private static final SdkField<String> CERTIFICATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Certificate").getter(getter(DescribeLunaClientResponse::certificate))
            .setter(setter(Builder::certificate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Certificate").build()).build();

    private static final SdkField<String> CERTIFICATE_FINGERPRINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CertificateFingerprint").getter(getter(DescribeLunaClientResponse::certificateFingerprint))
            .setter(setter(Builder::certificateFingerprint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateFingerprint").build())
            .build();

    private static final SdkField<String> LAST_MODIFIED_TIMESTAMP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastModifiedTimestamp").getter(getter(DescribeLunaClientResponse::lastModifiedTimestamp))
            .setter(setter(Builder::lastModifiedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTimestamp").build())
            .build();

    private static final SdkField<String> LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Label")
            .getter(getter(DescribeLunaClientResponse::label)).setter(setter(Builder::label))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Label").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_ARN_FIELD,
            CERTIFICATE_FIELD, CERTIFICATE_FINGERPRINT_FIELD, LAST_MODIFIED_TIMESTAMP_FIELD, LABEL_FIELD));

    private final String clientArn;

    private final String certificate;

    private final String certificateFingerprint;

    private final String lastModifiedTimestamp;

    private final String label;

    private DescribeLunaClientResponse(BuilderImpl builder) {
        super(builder);
        this.clientArn = builder.clientArn;
        this.certificate = builder.certificate;
        this.certificateFingerprint = builder.certificateFingerprint;
        this.lastModifiedTimestamp = builder.lastModifiedTimestamp;
        this.label = builder.label;
    }

    /**
     * <p>
     * The ARN of the client.
     * </p>
     * 
     * @return The ARN of the client.
     */
    public final String clientArn() {
        return clientArn;
    }

    /**
     * <p>
     * The certificate installed on the HSMs used by this client.
     * </p>
     * 
     * @return The certificate installed on the HSMs used by this client.
     */
    public final String certificate() {
        return certificate;
    }

    /**
     * <p>
     * The certificate fingerprint.
     * </p>
     * 
     * @return The certificate fingerprint.
     */
    public final String certificateFingerprint() {
        return certificateFingerprint;
    }

    /**
     * <p>
     * The date and time the client was last modified.
     * </p>
     * 
     * @return The date and time the client was last modified.
     */
    public final String lastModifiedTimestamp() {
        return lastModifiedTimestamp;
    }

    /**
     * <p>
     * The label of the client.
     * </p>
     * 
     * @return The label of the client.
     */
    public final String label() {
        return label;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientArn());
        hashCode = 31 * hashCode + Objects.hashCode(certificate());
        hashCode = 31 * hashCode + Objects.hashCode(certificateFingerprint());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(label());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLunaClientResponse)) {
            return false;
        }
        DescribeLunaClientResponse other = (DescribeLunaClientResponse) obj;
        return Objects.equals(clientArn(), other.clientArn()) && Objects.equals(certificate(), other.certificate())
                && Objects.equals(certificateFingerprint(), other.certificateFingerprint())
                && Objects.equals(lastModifiedTimestamp(), other.lastModifiedTimestamp())
                && Objects.equals(label(), other.label());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeLunaClientResponse").add("ClientArn", clientArn()).add("Certificate", certificate())
                .add("CertificateFingerprint", certificateFingerprint()).add("LastModifiedTimestamp", lastModifiedTimestamp())
                .add("Label", label()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientArn":
            return Optional.ofNullable(clazz.cast(clientArn()));
        case "Certificate":
            return Optional.ofNullable(clazz.cast(certificate()));
        case "CertificateFingerprint":
            return Optional.ofNullable(clazz.cast(certificateFingerprint()));
        case "LastModifiedTimestamp":
            return Optional.ofNullable(clazz.cast(lastModifiedTimestamp()));
        case "Label":
            return Optional.ofNullable(clazz.cast(label()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLunaClientResponse, T> g) {
        return obj -> g.apply((DescribeLunaClientResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudHsmResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeLunaClientResponse> {
        /**
         * <p>
         * The ARN of the client.
         * </p>
         * 
         * @param clientArn
         *        The ARN of the client.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientArn(String clientArn);

        /**
         * <p>
         * The certificate installed on the HSMs used by this client.
         * </p>
         * 
         * @param certificate
         *        The certificate installed on the HSMs used by this client.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificate(String certificate);

        /**
         * <p>
         * The certificate fingerprint.
         * </p>
         * 
         * @param certificateFingerprint
         *        The certificate fingerprint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateFingerprint(String certificateFingerprint);

        /**
         * <p>
         * The date and time the client was last modified.
         * </p>
         * 
         * @param lastModifiedTimestamp
         *        The date and time the client was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTimestamp(String lastModifiedTimestamp);

        /**
         * <p>
         * The label of the client.
         * </p>
         * 
         * @param label
         *        The label of the client.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder label(String label);
    }

    static final class BuilderImpl extends CloudHsmResponse.BuilderImpl implements Builder {
        private String clientArn;

        private String certificate;

        private String certificateFingerprint;

        private String lastModifiedTimestamp;

        private String label;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLunaClientResponse model) {
            super(model);
            clientArn(model.clientArn);
            certificate(model.certificate);
            certificateFingerprint(model.certificateFingerprint);
            lastModifiedTimestamp(model.lastModifiedTimestamp);
            label(model.label);
        }

        public final String getClientArn() {
            return clientArn;
        }

        public final void setClientArn(String clientArn) {
            this.clientArn = clientArn;
        }

        @Override
        @Transient
        public final Builder clientArn(String clientArn) {
            this.clientArn = clientArn;
            return this;
        }

        public final String getCertificate() {
            return certificate;
        }

        public final void setCertificate(String certificate) {
            this.certificate = certificate;
        }

        @Override
        @Transient
        public final Builder certificate(String certificate) {
            this.certificate = certificate;
            return this;
        }

        public final String getCertificateFingerprint() {
            return certificateFingerprint;
        }

        public final void setCertificateFingerprint(String certificateFingerprint) {
            this.certificateFingerprint = certificateFingerprint;
        }

        @Override
        @Transient
        public final Builder certificateFingerprint(String certificateFingerprint) {
            this.certificateFingerprint = certificateFingerprint;
            return this;
        }

        public final String getLastModifiedTimestamp() {
            return lastModifiedTimestamp;
        }

        public final void setLastModifiedTimestamp(String lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
        }

        @Override
        @Transient
        public final Builder lastModifiedTimestamp(String lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
            return this;
        }

        public final String getLabel() {
            return label;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        @Override
        @Transient
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        @Override
        public DescribeLunaClientResponse build() {
            return new DescribeLunaClientResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
