/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudhsm.model.CloudHsmRequest;
import software.amazon.awssdk.services.cloudhsm.model.SubscriptionType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateHsmRequest
extends CloudHsmRequest
implements ToCopyableBuilder<Builder, CreateHsmRequest> {
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetId").getter(CreateHsmRequest.getter(CreateHsmRequest::subnetId)).setter(CreateHsmRequest.setter(Builder::subnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").build()}).build();
    private static final SdkField<String> SSH_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SshKey").getter(CreateHsmRequest.getter(CreateHsmRequest::sshKey)).setter(CreateHsmRequest.setter(Builder::sshKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SshKey").build()}).build();
    private static final SdkField<String> ENI_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EniIp").getter(CreateHsmRequest.getter(CreateHsmRequest::eniIp)).setter(CreateHsmRequest.setter(Builder::eniIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EniIp").build()}).build();
    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IamRoleArn").getter(CreateHsmRequest.getter(CreateHsmRequest::iamRoleArn)).setter(CreateHsmRequest.setter(Builder::iamRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()}).build();
    private static final SdkField<String> EXTERNAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExternalId").getter(CreateHsmRequest.getter(CreateHsmRequest::externalId)).setter(CreateHsmRequest.setter(Builder::externalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalId").build()}).build();
    private static final SdkField<String> SUBSCRIPTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubscriptionType").getter(CreateHsmRequest.getter(CreateHsmRequest::subscriptionTypeAsString)).setter(CreateHsmRequest.setter(Builder::subscriptionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscriptionType").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateHsmRequest.getter(CreateHsmRequest::clientToken)).setter(CreateHsmRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()}).build();
    private static final SdkField<String> SYSLOG_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SyslogIp").getter(CreateHsmRequest.getter(CreateHsmRequest::syslogIp)).setter(CreateHsmRequest.setter(Builder::syslogIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SyslogIp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBNET_ID_FIELD, SSH_KEY_FIELD, ENI_IP_FIELD, IAM_ROLE_ARN_FIELD, EXTERNAL_ID_FIELD, SUBSCRIPTION_TYPE_FIELD, CLIENT_TOKEN_FIELD, SYSLOG_IP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("SubnetId", SUBNET_ID_FIELD);
            this.put("SshKey", SSH_KEY_FIELD);
            this.put("EniIp", ENI_IP_FIELD);
            this.put("IamRoleArn", IAM_ROLE_ARN_FIELD);
            this.put("ExternalId", EXTERNAL_ID_FIELD);
            this.put("SubscriptionType", SUBSCRIPTION_TYPE_FIELD);
            this.put("ClientToken", CLIENT_TOKEN_FIELD);
            this.put("SyslogIp", SYSLOG_IP_FIELD);
        }
    });
    private final String subnetId;
    private final String sshKey;
    private final String eniIp;
    private final String iamRoleArn;
    private final String externalId;
    private final String subscriptionType;
    private final String clientToken;
    private final String syslogIp;

    private CreateHsmRequest(BuilderImpl builder) {
        super(builder);
        this.subnetId = builder.subnetId;
        this.sshKey = builder.sshKey;
        this.eniIp = builder.eniIp;
        this.iamRoleArn = builder.iamRoleArn;
        this.externalId = builder.externalId;
        this.subscriptionType = builder.subscriptionType;
        this.clientToken = builder.clientToken;
        this.syslogIp = builder.syslogIp;
    }

    public final String subnetId() {
        return this.subnetId;
    }

    public final String sshKey() {
        return this.sshKey;
    }

    public final String eniIp() {
        return this.eniIp;
    }

    public final String iamRoleArn() {
        return this.iamRoleArn;
    }

    public final String externalId() {
        return this.externalId;
    }

    public final SubscriptionType subscriptionType() {
        return SubscriptionType.fromValue(this.subscriptionType);
    }

    public final String subscriptionTypeAsString() {
        return this.subscriptionType;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String syslogIp() {
        return this.syslogIp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sshKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.eniIp());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriptionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.syslogIp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateHsmRequest)) {
            return false;
        }
        CreateHsmRequest other = (CreateHsmRequest)((Object)obj);
        return Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.sshKey(), other.sshKey()) && Objects.equals(this.eniIp(), other.eniIp()) && Objects.equals(this.iamRoleArn(), other.iamRoleArn()) && Objects.equals(this.externalId(), other.externalId()) && Objects.equals(this.subscriptionTypeAsString(), other.subscriptionTypeAsString()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.syslogIp(), other.syslogIp());
    }

    public final String toString() {
        return ToString.builder((String)"CreateHsmRequest").add("SubnetId", (Object)this.subnetId()).add("SshKey", (Object)this.sshKey()).add("EniIp", (Object)this.eniIp()).add("IamRoleArn", (Object)this.iamRoleArn()).add("ExternalId", (Object)this.externalId()).add("SubscriptionType", (Object)this.subscriptionTypeAsString()).add("ClientToken", (Object)this.clientToken()).add("SyslogIp", (Object)this.syslogIp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SubnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
            case "SshKey": {
                return Optional.ofNullable(clazz.cast(this.sshKey()));
            }
            case "EniIp": {
                return Optional.ofNullable(clazz.cast(this.eniIp()));
            }
            case "IamRoleArn": {
                return Optional.ofNullable(clazz.cast(this.iamRoleArn()));
            }
            case "ExternalId": {
                return Optional.ofNullable(clazz.cast(this.externalId()));
            }
            case "SubscriptionType": {
                return Optional.ofNullable(clazz.cast(this.subscriptionTypeAsString()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "SyslogIp": {
                return Optional.ofNullable(clazz.cast(this.syslogIp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateHsmRequest, T> g) {
        return obj -> g.apply((CreateHsmRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudHsmRequest.BuilderImpl
    implements Builder {
        private String subnetId;
        private String sshKey;
        private String eniIp;
        private String iamRoleArn;
        private String externalId;
        private String subscriptionType;
        private String clientToken;
        private String syslogIp;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateHsmRequest model) {
            super(model);
            this.subnetId(model.subnetId);
            this.sshKey(model.sshKey);
            this.eniIp(model.eniIp);
            this.iamRoleArn(model.iamRoleArn);
            this.externalId(model.externalId);
            this.subscriptionType(model.subscriptionType);
            this.clientToken(model.clientToken);
            this.syslogIp(model.syslogIp);
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final String getSshKey() {
            return this.sshKey;
        }

        public final void setSshKey(String sshKey) {
            this.sshKey = sshKey;
        }

        @Override
        public final Builder sshKey(String sshKey) {
            this.sshKey = sshKey;
            return this;
        }

        public final String getEniIp() {
            return this.eniIp;
        }

        public final void setEniIp(String eniIp) {
            this.eniIp = eniIp;
        }

        @Override
        public final Builder eniIp(String eniIp) {
            this.eniIp = eniIp;
            return this;
        }

        public final String getIamRoleArn() {
            return this.iamRoleArn;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final String getExternalId() {
            return this.externalId;
        }

        public final void setExternalId(String externalId) {
            this.externalId = externalId;
        }

        @Override
        public final Builder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public final String getSubscriptionType() {
            return this.subscriptionType;
        }

        public final void setSubscriptionType(String subscriptionType) {
            this.subscriptionType = subscriptionType;
        }

        @Override
        public final Builder subscriptionType(String subscriptionType) {
            this.subscriptionType = subscriptionType;
            return this;
        }

        @Override
        public final Builder subscriptionType(SubscriptionType subscriptionType) {
            this.subscriptionType(subscriptionType == null ? null : subscriptionType.toString());
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getSyslogIp() {
            return this.syslogIp;
        }

        public final void setSyslogIp(String syslogIp) {
            this.syslogIp = syslogIp;
        }

        @Override
        public final Builder syslogIp(String syslogIp) {
            this.syslogIp = syslogIp;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateHsmRequest build() {
            return new CreateHsmRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudHsmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateHsmRequest> {
        public Builder subnetId(String var1);

        public Builder sshKey(String var1);

        public Builder eniIp(String var1);

        public Builder iamRoleArn(String var1);

        public Builder externalId(String var1);

        public Builder subscriptionType(String var1);

        public Builder subscriptionType(SubscriptionType var1);

        public Builder clientToken(String var1);

        public Builder syslogIp(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

