/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudhsm.model.CloudHsmResponse;
import software.amazon.awssdk.services.cloudhsm.model.HsmStatus;
import software.amazon.awssdk.services.cloudhsm.model.PartitionListCopier;
import software.amazon.awssdk.services.cloudhsm.model.SubscriptionType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeHsmResponse
extends CloudHsmResponse
implements ToCopyableBuilder<Builder, DescribeHsmResponse> {
    private static final SdkField<String> HSM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HsmArn").getter(DescribeHsmResponse.getter(DescribeHsmResponse::hsmArn)).setter(DescribeHsmResponse.setter(Builder::hsmArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HsmArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DescribeHsmResponse.getter(DescribeHsmResponse::statusAsString)).setter(DescribeHsmResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusDetails").getter(DescribeHsmResponse.getter(DescribeHsmResponse::statusDetails)).setter(DescribeHsmResponse.setter(Builder::statusDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusDetails").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(DescribeHsmResponse.getter(DescribeHsmResponse::availabilityZone)).setter(DescribeHsmResponse.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()}).build();
    private static final SdkField<String> ENI_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EniId").getter(DescribeHsmResponse.getter(DescribeHsmResponse::eniId)).setter(DescribeHsmResponse.setter(Builder::eniId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EniId").build()}).build();
    private static final SdkField<String> ENI_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EniIp").getter(DescribeHsmResponse.getter(DescribeHsmResponse::eniIp)).setter(DescribeHsmResponse.setter(Builder::eniIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EniIp").build()}).build();
    private static final SdkField<String> SUBSCRIPTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubscriptionType").getter(DescribeHsmResponse.getter(DescribeHsmResponse::subscriptionTypeAsString)).setter(DescribeHsmResponse.setter(Builder::subscriptionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscriptionType").build()}).build();
    private static final SdkField<String> SUBSCRIPTION_START_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubscriptionStartDate").getter(DescribeHsmResponse.getter(DescribeHsmResponse::subscriptionStartDate)).setter(DescribeHsmResponse.setter(Builder::subscriptionStartDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscriptionStartDate").build()}).build();
    private static final SdkField<String> SUBSCRIPTION_END_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubscriptionEndDate").getter(DescribeHsmResponse.getter(DescribeHsmResponse::subscriptionEndDate)).setter(DescribeHsmResponse.setter(Builder::subscriptionEndDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscriptionEndDate").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(DescribeHsmResponse.getter(DescribeHsmResponse::vpcId)).setter(DescribeHsmResponse.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()}).build();
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetId").getter(DescribeHsmResponse.getter(DescribeHsmResponse::subnetId)).setter(DescribeHsmResponse.setter(Builder::subnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").build()}).build();
    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IamRoleArn").getter(DescribeHsmResponse.getter(DescribeHsmResponse::iamRoleArn)).setter(DescribeHsmResponse.setter(Builder::iamRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()}).build();
    private static final SdkField<String> SERIAL_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SerialNumber").getter(DescribeHsmResponse.getter(DescribeHsmResponse::serialNumber)).setter(DescribeHsmResponse.setter(Builder::serialNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SerialNumber").build()}).build();
    private static final SdkField<String> VENDOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VendorName").getter(DescribeHsmResponse.getter(DescribeHsmResponse::vendorName)).setter(DescribeHsmResponse.setter(Builder::vendorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VendorName").build()}).build();
    private static final SdkField<String> HSM_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HsmType").getter(DescribeHsmResponse.getter(DescribeHsmResponse::hsmType)).setter(DescribeHsmResponse.setter(Builder::hsmType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HsmType").build()}).build();
    private static final SdkField<String> SOFTWARE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SoftwareVersion").getter(DescribeHsmResponse.getter(DescribeHsmResponse::softwareVersion)).setter(DescribeHsmResponse.setter(Builder::softwareVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SoftwareVersion").build()}).build();
    private static final SdkField<String> SSH_PUBLIC_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SshPublicKey").getter(DescribeHsmResponse.getter(DescribeHsmResponse::sshPublicKey)).setter(DescribeHsmResponse.setter(Builder::sshPublicKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SshPublicKey").build()}).build();
    private static final SdkField<String> SSH_KEY_LAST_UPDATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SshKeyLastUpdated").getter(DescribeHsmResponse.getter(DescribeHsmResponse::sshKeyLastUpdated)).setter(DescribeHsmResponse.setter(Builder::sshKeyLastUpdated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SshKeyLastUpdated").build()}).build();
    private static final SdkField<String> SERVER_CERT_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerCertUri").getter(DescribeHsmResponse.getter(DescribeHsmResponse::serverCertUri)).setter(DescribeHsmResponse.setter(Builder::serverCertUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerCertUri").build()}).build();
    private static final SdkField<String> SERVER_CERT_LAST_UPDATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerCertLastUpdated").getter(DescribeHsmResponse.getter(DescribeHsmResponse::serverCertLastUpdated)).setter(DescribeHsmResponse.setter(Builder::serverCertLastUpdated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerCertLastUpdated").build()}).build();
    private static final SdkField<List<String>> PARTITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Partitions").getter(DescribeHsmResponse.getter(DescribeHsmResponse::partitions)).setter(DescribeHsmResponse.setter(Builder::partitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Partitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HSM_ARN_FIELD, STATUS_FIELD, STATUS_DETAILS_FIELD, AVAILABILITY_ZONE_FIELD, ENI_ID_FIELD, ENI_IP_FIELD, SUBSCRIPTION_TYPE_FIELD, SUBSCRIPTION_START_DATE_FIELD, SUBSCRIPTION_END_DATE_FIELD, VPC_ID_FIELD, SUBNET_ID_FIELD, IAM_ROLE_ARN_FIELD, SERIAL_NUMBER_FIELD, VENDOR_NAME_FIELD, HSM_TYPE_FIELD, SOFTWARE_VERSION_FIELD, SSH_PUBLIC_KEY_FIELD, SSH_KEY_LAST_UPDATED_FIELD, SERVER_CERT_URI_FIELD, SERVER_CERT_LAST_UPDATED_FIELD, PARTITIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("HsmArn", HSM_ARN_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("StatusDetails", STATUS_DETAILS_FIELD);
            this.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
            this.put("EniId", ENI_ID_FIELD);
            this.put("EniIp", ENI_IP_FIELD);
            this.put("SubscriptionType", SUBSCRIPTION_TYPE_FIELD);
            this.put("SubscriptionStartDate", SUBSCRIPTION_START_DATE_FIELD);
            this.put("SubscriptionEndDate", SUBSCRIPTION_END_DATE_FIELD);
            this.put("VpcId", VPC_ID_FIELD);
            this.put("SubnetId", SUBNET_ID_FIELD);
            this.put("IamRoleArn", IAM_ROLE_ARN_FIELD);
            this.put("SerialNumber", SERIAL_NUMBER_FIELD);
            this.put("VendorName", VENDOR_NAME_FIELD);
            this.put("HsmType", HSM_TYPE_FIELD);
            this.put("SoftwareVersion", SOFTWARE_VERSION_FIELD);
            this.put("SshPublicKey", SSH_PUBLIC_KEY_FIELD);
            this.put("SshKeyLastUpdated", SSH_KEY_LAST_UPDATED_FIELD);
            this.put("ServerCertUri", SERVER_CERT_URI_FIELD);
            this.put("ServerCertLastUpdated", SERVER_CERT_LAST_UPDATED_FIELD);
            this.put("Partitions", PARTITIONS_FIELD);
        }
    });
    private final String hsmArn;
    private final String status;
    private final String statusDetails;
    private final String availabilityZone;
    private final String eniId;
    private final String eniIp;
    private final String subscriptionType;
    private final String subscriptionStartDate;
    private final String subscriptionEndDate;
    private final String vpcId;
    private final String subnetId;
    private final String iamRoleArn;
    private final String serialNumber;
    private final String vendorName;
    private final String hsmType;
    private final String softwareVersion;
    private final String sshPublicKey;
    private final String sshKeyLastUpdated;
    private final String serverCertUri;
    private final String serverCertLastUpdated;
    private final List<String> partitions;

    private DescribeHsmResponse(BuilderImpl builder) {
        super(builder);
        this.hsmArn = builder.hsmArn;
        this.status = builder.status;
        this.statusDetails = builder.statusDetails;
        this.availabilityZone = builder.availabilityZone;
        this.eniId = builder.eniId;
        this.eniIp = builder.eniIp;
        this.subscriptionType = builder.subscriptionType;
        this.subscriptionStartDate = builder.subscriptionStartDate;
        this.subscriptionEndDate = builder.subscriptionEndDate;
        this.vpcId = builder.vpcId;
        this.subnetId = builder.subnetId;
        this.iamRoleArn = builder.iamRoleArn;
        this.serialNumber = builder.serialNumber;
        this.vendorName = builder.vendorName;
        this.hsmType = builder.hsmType;
        this.softwareVersion = builder.softwareVersion;
        this.sshPublicKey = builder.sshPublicKey;
        this.sshKeyLastUpdated = builder.sshKeyLastUpdated;
        this.serverCertUri = builder.serverCertUri;
        this.serverCertLastUpdated = builder.serverCertLastUpdated;
        this.partitions = builder.partitions;
    }

    public final String hsmArn() {
        return this.hsmArn;
    }

    public final HsmStatus status() {
        return HsmStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusDetails() {
        return this.statusDetails;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final String eniId() {
        return this.eniId;
    }

    public final String eniIp() {
        return this.eniIp;
    }

    public final SubscriptionType subscriptionType() {
        return SubscriptionType.fromValue(this.subscriptionType);
    }

    public final String subscriptionTypeAsString() {
        return this.subscriptionType;
    }

    public final String subscriptionStartDate() {
        return this.subscriptionStartDate;
    }

    public final String subscriptionEndDate() {
        return this.subscriptionEndDate;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final String subnetId() {
        return this.subnetId;
    }

    public final String iamRoleArn() {
        return this.iamRoleArn;
    }

    public final String serialNumber() {
        return this.serialNumber;
    }

    public final String vendorName() {
        return this.vendorName;
    }

    public final String hsmType() {
        return this.hsmType;
    }

    public final String softwareVersion() {
        return this.softwareVersion;
    }

    public final String sshPublicKey() {
        return this.sshPublicKey;
    }

    public final String sshKeyLastUpdated() {
        return this.sshKeyLastUpdated;
    }

    public final String serverCertUri() {
        return this.serverCertUri;
    }

    public final String serverCertLastUpdated() {
        return this.serverCertLastUpdated;
    }

    public final boolean hasPartitions() {
        return this.partitions != null && !(this.partitions instanceof SdkAutoConstructList);
    }

    public final List<String> partitions() {
        return this.partitions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hsmArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.eniId());
        hashCode = 31 * hashCode + Objects.hashCode(this.eniIp());
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriptionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriptionStartDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriptionEndDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.serialNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.vendorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hsmType());
        hashCode = 31 * hashCode + Objects.hashCode(this.softwareVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.sshPublicKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.sshKeyLastUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverCertUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverCertLastUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPartitions() ? this.partitions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeHsmResponse)) {
            return false;
        }
        DescribeHsmResponse other = (DescribeHsmResponse)((Object)obj);
        return Objects.equals(this.hsmArn(), other.hsmArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusDetails(), other.statusDetails()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.eniId(), other.eniId()) && Objects.equals(this.eniIp(), other.eniIp()) && Objects.equals(this.subscriptionTypeAsString(), other.subscriptionTypeAsString()) && Objects.equals(this.subscriptionStartDate(), other.subscriptionStartDate()) && Objects.equals(this.subscriptionEndDate(), other.subscriptionEndDate()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.iamRoleArn(), other.iamRoleArn()) && Objects.equals(this.serialNumber(), other.serialNumber()) && Objects.equals(this.vendorName(), other.vendorName()) && Objects.equals(this.hsmType(), other.hsmType()) && Objects.equals(this.softwareVersion(), other.softwareVersion()) && Objects.equals(this.sshPublicKey(), other.sshPublicKey()) && Objects.equals(this.sshKeyLastUpdated(), other.sshKeyLastUpdated()) && Objects.equals(this.serverCertUri(), other.serverCertUri()) && Objects.equals(this.serverCertLastUpdated(), other.serverCertLastUpdated()) && this.hasPartitions() == other.hasPartitions() && Objects.equals(this.partitions(), other.partitions());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeHsmResponse").add("HsmArn", (Object)this.hsmArn()).add("Status", (Object)this.statusAsString()).add("StatusDetails", (Object)this.statusDetails()).add("AvailabilityZone", (Object)this.availabilityZone()).add("EniId", (Object)this.eniId()).add("EniIp", (Object)this.eniIp()).add("SubscriptionType", (Object)this.subscriptionTypeAsString()).add("SubscriptionStartDate", (Object)this.subscriptionStartDate()).add("SubscriptionEndDate", (Object)this.subscriptionEndDate()).add("VpcId", (Object)this.vpcId()).add("SubnetId", (Object)this.subnetId()).add("IamRoleArn", (Object)this.iamRoleArn()).add("SerialNumber", (Object)this.serialNumber()).add("VendorName", (Object)this.vendorName()).add("HsmType", (Object)this.hsmType()).add("SoftwareVersion", (Object)this.softwareVersion()).add("SshPublicKey", (Object)this.sshPublicKey()).add("SshKeyLastUpdated", (Object)this.sshKeyLastUpdated()).add("ServerCertUri", (Object)this.serverCertUri()).add("ServerCertLastUpdated", (Object)this.serverCertLastUpdated()).add("Partitions", this.hasPartitions() ? this.partitions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HsmArn": {
                return Optional.ofNullable(clazz.cast(this.hsmArn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusDetails": {
                return Optional.ofNullable(clazz.cast(this.statusDetails()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "EniId": {
                return Optional.ofNullable(clazz.cast(this.eniId()));
            }
            case "EniIp": {
                return Optional.ofNullable(clazz.cast(this.eniIp()));
            }
            case "SubscriptionType": {
                return Optional.ofNullable(clazz.cast(this.subscriptionTypeAsString()));
            }
            case "SubscriptionStartDate": {
                return Optional.ofNullable(clazz.cast(this.subscriptionStartDate()));
            }
            case "SubscriptionEndDate": {
                return Optional.ofNullable(clazz.cast(this.subscriptionEndDate()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "SubnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
            case "IamRoleArn": {
                return Optional.ofNullable(clazz.cast(this.iamRoleArn()));
            }
            case "SerialNumber": {
                return Optional.ofNullable(clazz.cast(this.serialNumber()));
            }
            case "VendorName": {
                return Optional.ofNullable(clazz.cast(this.vendorName()));
            }
            case "HsmType": {
                return Optional.ofNullable(clazz.cast(this.hsmType()));
            }
            case "SoftwareVersion": {
                return Optional.ofNullable(clazz.cast(this.softwareVersion()));
            }
            case "SshPublicKey": {
                return Optional.ofNullable(clazz.cast(this.sshPublicKey()));
            }
            case "SshKeyLastUpdated": {
                return Optional.ofNullable(clazz.cast(this.sshKeyLastUpdated()));
            }
            case "ServerCertUri": {
                return Optional.ofNullable(clazz.cast(this.serverCertUri()));
            }
            case "ServerCertLastUpdated": {
                return Optional.ofNullable(clazz.cast(this.serverCertLastUpdated()));
            }
            case "Partitions": {
                return Optional.ofNullable(clazz.cast(this.partitions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeHsmResponse, T> g) {
        return obj -> g.apply((DescribeHsmResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudHsmResponse.BuilderImpl
    implements Builder {
        private String hsmArn;
        private String status;
        private String statusDetails;
        private String availabilityZone;
        private String eniId;
        private String eniIp;
        private String subscriptionType;
        private String subscriptionStartDate;
        private String subscriptionEndDate;
        private String vpcId;
        private String subnetId;
        private String iamRoleArn;
        private String serialNumber;
        private String vendorName;
        private String hsmType;
        private String softwareVersion;
        private String sshPublicKey;
        private String sshKeyLastUpdated;
        private String serverCertUri;
        private String serverCertLastUpdated;
        private List<String> partitions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeHsmResponse model) {
            super(model);
            this.hsmArn(model.hsmArn);
            this.status(model.status);
            this.statusDetails(model.statusDetails);
            this.availabilityZone(model.availabilityZone);
            this.eniId(model.eniId);
            this.eniIp(model.eniIp);
            this.subscriptionType(model.subscriptionType);
            this.subscriptionStartDate(model.subscriptionStartDate);
            this.subscriptionEndDate(model.subscriptionEndDate);
            this.vpcId(model.vpcId);
            this.subnetId(model.subnetId);
            this.iamRoleArn(model.iamRoleArn);
            this.serialNumber(model.serialNumber);
            this.vendorName(model.vendorName);
            this.hsmType(model.hsmType);
            this.softwareVersion(model.softwareVersion);
            this.sshPublicKey(model.sshPublicKey);
            this.sshKeyLastUpdated(model.sshKeyLastUpdated);
            this.serverCertUri(model.serverCertUri);
            this.serverCertLastUpdated(model.serverCertLastUpdated);
            this.partitions(model.partitions);
        }

        public final String getHsmArn() {
            return this.hsmArn;
        }

        public final void setHsmArn(String hsmArn) {
            this.hsmArn = hsmArn;
        }

        @Override
        public final Builder hsmArn(String hsmArn) {
            this.hsmArn = hsmArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(HsmStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusDetails() {
            return this.statusDetails;
        }

        public final void setStatusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
        }

        @Override
        public final Builder statusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
            return this;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getEniId() {
            return this.eniId;
        }

        public final void setEniId(String eniId) {
            this.eniId = eniId;
        }

        @Override
        public final Builder eniId(String eniId) {
            this.eniId = eniId;
            return this;
        }

        public final String getEniIp() {
            return this.eniIp;
        }

        public final void setEniIp(String eniIp) {
            this.eniIp = eniIp;
        }

        @Override
        public final Builder eniIp(String eniIp) {
            this.eniIp = eniIp;
            return this;
        }

        public final String getSubscriptionType() {
            return this.subscriptionType;
        }

        public final void setSubscriptionType(String subscriptionType) {
            this.subscriptionType = subscriptionType;
        }

        @Override
        public final Builder subscriptionType(String subscriptionType) {
            this.subscriptionType = subscriptionType;
            return this;
        }

        @Override
        public final Builder subscriptionType(SubscriptionType subscriptionType) {
            this.subscriptionType(subscriptionType == null ? null : subscriptionType.toString());
            return this;
        }

        public final String getSubscriptionStartDate() {
            return this.subscriptionStartDate;
        }

        public final void setSubscriptionStartDate(String subscriptionStartDate) {
            this.subscriptionStartDate = subscriptionStartDate;
        }

        @Override
        public final Builder subscriptionStartDate(String subscriptionStartDate) {
            this.subscriptionStartDate = subscriptionStartDate;
            return this;
        }

        public final String getSubscriptionEndDate() {
            return this.subscriptionEndDate;
        }

        public final void setSubscriptionEndDate(String subscriptionEndDate) {
            this.subscriptionEndDate = subscriptionEndDate;
        }

        @Override
        public final Builder subscriptionEndDate(String subscriptionEndDate) {
            this.subscriptionEndDate = subscriptionEndDate;
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final String getIamRoleArn() {
            return this.iamRoleArn;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final String getSerialNumber() {
            return this.serialNumber;
        }

        public final void setSerialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
        }

        @Override
        public final Builder serialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            return this;
        }

        public final String getVendorName() {
            return this.vendorName;
        }

        public final void setVendorName(String vendorName) {
            this.vendorName = vendorName;
        }

        @Override
        public final Builder vendorName(String vendorName) {
            this.vendorName = vendorName;
            return this;
        }

        public final String getHsmType() {
            return this.hsmType;
        }

        public final void setHsmType(String hsmType) {
            this.hsmType = hsmType;
        }

        @Override
        public final Builder hsmType(String hsmType) {
            this.hsmType = hsmType;
            return this;
        }

        public final String getSoftwareVersion() {
            return this.softwareVersion;
        }

        public final void setSoftwareVersion(String softwareVersion) {
            this.softwareVersion = softwareVersion;
        }

        @Override
        public final Builder softwareVersion(String softwareVersion) {
            this.softwareVersion = softwareVersion;
            return this;
        }

        public final String getSshPublicKey() {
            return this.sshPublicKey;
        }

        public final void setSshPublicKey(String sshPublicKey) {
            this.sshPublicKey = sshPublicKey;
        }

        @Override
        public final Builder sshPublicKey(String sshPublicKey) {
            this.sshPublicKey = sshPublicKey;
            return this;
        }

        public final String getSshKeyLastUpdated() {
            return this.sshKeyLastUpdated;
        }

        public final void setSshKeyLastUpdated(String sshKeyLastUpdated) {
            this.sshKeyLastUpdated = sshKeyLastUpdated;
        }

        @Override
        public final Builder sshKeyLastUpdated(String sshKeyLastUpdated) {
            this.sshKeyLastUpdated = sshKeyLastUpdated;
            return this;
        }

        public final String getServerCertUri() {
            return this.serverCertUri;
        }

        public final void setServerCertUri(String serverCertUri) {
            this.serverCertUri = serverCertUri;
        }

        @Override
        public final Builder serverCertUri(String serverCertUri) {
            this.serverCertUri = serverCertUri;
            return this;
        }

        public final String getServerCertLastUpdated() {
            return this.serverCertLastUpdated;
        }

        public final void setServerCertLastUpdated(String serverCertLastUpdated) {
            this.serverCertLastUpdated = serverCertLastUpdated;
        }

        @Override
        public final Builder serverCertLastUpdated(String serverCertLastUpdated) {
            this.serverCertLastUpdated = serverCertLastUpdated;
            return this;
        }

        public final Collection<String> getPartitions() {
            if (this.partitions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.partitions;
        }

        public final void setPartitions(Collection<String> partitions) {
            this.partitions = PartitionListCopier.copy(partitions);
        }

        @Override
        public final Builder partitions(Collection<String> partitions) {
            this.partitions = PartitionListCopier.copy(partitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitions(String ... partitions) {
            this.partitions(Arrays.asList(partitions));
            return this;
        }

        @Override
        public DescribeHsmResponse build() {
            return new DescribeHsmResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudHsmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeHsmResponse> {
        public Builder hsmArn(String var1);

        public Builder status(String var1);

        public Builder status(HsmStatus var1);

        public Builder statusDetails(String var1);

        public Builder availabilityZone(String var1);

        public Builder eniId(String var1);

        public Builder eniIp(String var1);

        public Builder subscriptionType(String var1);

        public Builder subscriptionType(SubscriptionType var1);

        public Builder subscriptionStartDate(String var1);

        public Builder subscriptionEndDate(String var1);

        public Builder vpcId(String var1);

        public Builder subnetId(String var1);

        public Builder iamRoleArn(String var1);

        public Builder serialNumber(String var1);

        public Builder vendorName(String var1);

        public Builder hsmType(String var1);

        public Builder softwareVersion(String var1);

        public Builder sshPublicKey(String var1);

        public Builder sshKeyLastUpdated(String var1);

        public Builder serverCertUri(String var1);

        public Builder serverCertLastUpdated(String var1);

        public Builder partitions(Collection<String> var1);

        public Builder partitions(String ... var1);
    }
}

