/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudhsm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the inputs for the <a>ModifyHsm</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyHsmRequest extends CloudHsmRequest implements
        ToCopyableBuilder<ModifyHsmRequest.Builder, ModifyHsmRequest> {
    private static final SdkField<String> HSM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("HsmArn")
            .getter(getter(ModifyHsmRequest::hsmArn)).setter(setter(Builder::hsmArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HsmArn").build()).build();

    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubnetId").getter(getter(ModifyHsmRequest::subnetId)).setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").build()).build();

    private static final SdkField<String> ENI_IP_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("EniIp")
            .getter(getter(ModifyHsmRequest::eniIp)).setter(setter(Builder::eniIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EniIp").build()).build();

    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IamRoleArn").getter(getter(ModifyHsmRequest::iamRoleArn)).setter(setter(Builder::iamRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()).build();

    private static final SdkField<String> EXTERNAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExternalId").getter(getter(ModifyHsmRequest::externalId)).setter(setter(Builder::externalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalId").build()).build();

    private static final SdkField<String> SYSLOG_IP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SyslogIp").getter(getter(ModifyHsmRequest::syslogIp)).setter(setter(Builder::syslogIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SyslogIp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HSM_ARN_FIELD,
            SUBNET_ID_FIELD, ENI_IP_FIELD, IAM_ROLE_ARN_FIELD, EXTERNAL_ID_FIELD, SYSLOG_IP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String hsmArn;

    private final String subnetId;

    private final String eniIp;

    private final String iamRoleArn;

    private final String externalId;

    private final String syslogIp;

    private ModifyHsmRequest(BuilderImpl builder) {
        super(builder);
        this.hsmArn = builder.hsmArn;
        this.subnetId = builder.subnetId;
        this.eniIp = builder.eniIp;
        this.iamRoleArn = builder.iamRoleArn;
        this.externalId = builder.externalId;
        this.syslogIp = builder.syslogIp;
    }

    /**
     * <p>
     * The ARN of the HSM to modify.
     * </p>
     * 
     * @return The ARN of the HSM to modify.
     */
    public final String hsmArn() {
        return hsmArn;
    }

    /**
     * <p>
     * The new identifier of the subnet that the HSM is in. The new subnet must be in the same Availability Zone as the
     * current subnet.
     * </p>
     * 
     * @return The new identifier of the subnet that the HSM is in. The new subnet must be in the same Availability Zone
     *         as the current subnet.
     */
    public final String subnetId() {
        return subnetId;
    }

    /**
     * <p>
     * The new IP address for the elastic network interface (ENI) attached to the HSM.
     * </p>
     * <p>
     * If the HSM is moved to a different subnet, and an IP address is not specified, an IP address will be randomly
     * chosen from the CIDR range of the new subnet.
     * </p>
     * 
     * @return The new IP address for the elastic network interface (ENI) attached to the HSM.</p>
     *         <p>
     *         If the HSM is moved to a different subnet, and an IP address is not specified, an IP address will be
     *         randomly chosen from the CIDR range of the new subnet.
     */
    public final String eniIp() {
        return eniIp;
    }

    /**
     * <p>
     * The new IAM role ARN.
     * </p>
     * 
     * @return The new IAM role ARN.
     */
    public final String iamRoleArn() {
        return iamRoleArn;
    }

    /**
     * <p>
     * The new external ID.
     * </p>
     * 
     * @return The new external ID.
     */
    public final String externalId() {
        return externalId;
    }

    /**
     * <p>
     * The new IP address for the syslog monitoring server. The AWS CloudHSM service only supports one syslog monitoring
     * server.
     * </p>
     * 
     * @return The new IP address for the syslog monitoring server. The AWS CloudHSM service only supports one syslog
     *         monitoring server.
     */
    public final String syslogIp() {
        return syslogIp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hsmArn());
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(eniIp());
        hashCode = 31 * hashCode + Objects.hashCode(iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(externalId());
        hashCode = 31 * hashCode + Objects.hashCode(syslogIp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyHsmRequest)) {
            return false;
        }
        ModifyHsmRequest other = (ModifyHsmRequest) obj;
        return Objects.equals(hsmArn(), other.hsmArn()) && Objects.equals(subnetId(), other.subnetId())
                && Objects.equals(eniIp(), other.eniIp()) && Objects.equals(iamRoleArn(), other.iamRoleArn())
                && Objects.equals(externalId(), other.externalId()) && Objects.equals(syslogIp(), other.syslogIp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyHsmRequest").add("HsmArn", hsmArn()).add("SubnetId", subnetId()).add("EniIp", eniIp())
                .add("IamRoleArn", iamRoleArn()).add("ExternalId", externalId()).add("SyslogIp", syslogIp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HsmArn":
            return Optional.ofNullable(clazz.cast(hsmArn()));
        case "SubnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        case "EniIp":
            return Optional.ofNullable(clazz.cast(eniIp()));
        case "IamRoleArn":
            return Optional.ofNullable(clazz.cast(iamRoleArn()));
        case "ExternalId":
            return Optional.ofNullable(clazz.cast(externalId()));
        case "SyslogIp":
            return Optional.ofNullable(clazz.cast(syslogIp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("HsmArn", HSM_ARN_FIELD);
        map.put("SubnetId", SUBNET_ID_FIELD);
        map.put("EniIp", ENI_IP_FIELD);
        map.put("IamRoleArn", IAM_ROLE_ARN_FIELD);
        map.put("ExternalId", EXTERNAL_ID_FIELD);
        map.put("SyslogIp", SYSLOG_IP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyHsmRequest, T> g) {
        return obj -> g.apply((ModifyHsmRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudHsmRequest.Builder, SdkPojo, CopyableBuilder<Builder, ModifyHsmRequest> {
        /**
         * <p>
         * The ARN of the HSM to modify.
         * </p>
         * 
         * @param hsmArn
         *        The ARN of the HSM to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hsmArn(String hsmArn);

        /**
         * <p>
         * The new identifier of the subnet that the HSM is in. The new subnet must be in the same Availability Zone as
         * the current subnet.
         * </p>
         * 
         * @param subnetId
         *        The new identifier of the subnet that the HSM is in. The new subnet must be in the same Availability
         *        Zone as the current subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * The new IP address for the elastic network interface (ENI) attached to the HSM.
         * </p>
         * <p>
         * If the HSM is moved to a different subnet, and an IP address is not specified, an IP address will be randomly
         * chosen from the CIDR range of the new subnet.
         * </p>
         * 
         * @param eniIp
         *        The new IP address for the elastic network interface (ENI) attached to the HSM.</p>
         *        <p>
         *        If the HSM is moved to a different subnet, and an IP address is not specified, an IP address will be
         *        randomly chosen from the CIDR range of the new subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eniIp(String eniIp);

        /**
         * <p>
         * The new IAM role ARN.
         * </p>
         * 
         * @param iamRoleArn
         *        The new IAM role ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRoleArn(String iamRoleArn);

        /**
         * <p>
         * The new external ID.
         * </p>
         * 
         * @param externalId
         *        The new external ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalId(String externalId);

        /**
         * <p>
         * The new IP address for the syslog monitoring server. The AWS CloudHSM service only supports one syslog
         * monitoring server.
         * </p>
         * 
         * @param syslogIp
         *        The new IP address for the syslog monitoring server. The AWS CloudHSM service only supports one syslog
         *        monitoring server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder syslogIp(String syslogIp);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudHsmRequest.BuilderImpl implements Builder {
        private String hsmArn;

        private String subnetId;

        private String eniIp;

        private String iamRoleArn;

        private String externalId;

        private String syslogIp;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyHsmRequest model) {
            super(model);
            hsmArn(model.hsmArn);
            subnetId(model.subnetId);
            eniIp(model.eniIp);
            iamRoleArn(model.iamRoleArn);
            externalId(model.externalId);
            syslogIp(model.syslogIp);
        }

        public final String getHsmArn() {
            return hsmArn;
        }

        public final void setHsmArn(String hsmArn) {
            this.hsmArn = hsmArn;
        }

        @Override
        public final Builder hsmArn(String hsmArn) {
            this.hsmArn = hsmArn;
            return this;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final String getEniIp() {
            return eniIp;
        }

        public final void setEniIp(String eniIp) {
            this.eniIp = eniIp;
        }

        @Override
        public final Builder eniIp(String eniIp) {
            this.eniIp = eniIp;
            return this;
        }

        public final String getIamRoleArn() {
            return iamRoleArn;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final String getExternalId() {
            return externalId;
        }

        public final void setExternalId(String externalId) {
            this.externalId = externalId;
        }

        @Override
        public final Builder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public final String getSyslogIp() {
            return syslogIp;
        }

        public final void setSyslogIp(String syslogIp) {
            this.syslogIp = syslogIp;
        }

        @Override
        public final Builder syslogIp(String syslogIp) {
            this.syslogIp = syslogIp;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyHsmRequest build() {
            return new ModifyHsmRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
