/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudhsm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the inputs for the <a>DescribeHsm</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeHsmRequest extends CloudHsmRequest implements
        ToCopyableBuilder<DescribeHsmRequest.Builder, DescribeHsmRequest> {
    private static final SdkField<String> HSM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("HsmArn")
            .getter(getter(DescribeHsmRequest::hsmArn)).setter(setter(Builder::hsmArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HsmArn").build()).build();

    private static final SdkField<String> HSM_SERIAL_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HsmSerialNumber").getter(getter(DescribeHsmRequest::hsmSerialNumber))
            .setter(setter(Builder::hsmSerialNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HsmSerialNumber").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HSM_ARN_FIELD,
            HSM_SERIAL_NUMBER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String hsmArn;

    private final String hsmSerialNumber;

    private DescribeHsmRequest(BuilderImpl builder) {
        super(builder);
        this.hsmArn = builder.hsmArn;
        this.hsmSerialNumber = builder.hsmSerialNumber;
    }

    /**
     * <p>
     * The ARN of the HSM. Either the <code>HsmArn</code> or the <code>SerialNumber</code> parameter must be specified.
     * </p>
     * 
     * @return The ARN of the HSM. Either the <code>HsmArn</code> or the <code>SerialNumber</code> parameter must be
     *         specified.
     */
    public final String hsmArn() {
        return hsmArn;
    }

    /**
     * <p>
     * The serial number of the HSM. Either the <code>HsmArn</code> or the <code>HsmSerialNumber</code> parameter must
     * be specified.
     * </p>
     * 
     * @return The serial number of the HSM. Either the <code>HsmArn</code> or the <code>HsmSerialNumber</code>
     *         parameter must be specified.
     */
    public final String hsmSerialNumber() {
        return hsmSerialNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hsmArn());
        hashCode = 31 * hashCode + Objects.hashCode(hsmSerialNumber());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeHsmRequest)) {
            return false;
        }
        DescribeHsmRequest other = (DescribeHsmRequest) obj;
        return Objects.equals(hsmArn(), other.hsmArn()) && Objects.equals(hsmSerialNumber(), other.hsmSerialNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeHsmRequest").add("HsmArn", hsmArn()).add("HsmSerialNumber", hsmSerialNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HsmArn":
            return Optional.ofNullable(clazz.cast(hsmArn()));
        case "HsmSerialNumber":
            return Optional.ofNullable(clazz.cast(hsmSerialNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("HsmArn", HSM_ARN_FIELD);
        map.put("HsmSerialNumber", HSM_SERIAL_NUMBER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeHsmRequest, T> g) {
        return obj -> g.apply((DescribeHsmRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudHsmRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeHsmRequest> {
        /**
         * <p>
         * The ARN of the HSM. Either the <code>HsmArn</code> or the <code>SerialNumber</code> parameter must be
         * specified.
         * </p>
         * 
         * @param hsmArn
         *        The ARN of the HSM. Either the <code>HsmArn</code> or the <code>SerialNumber</code> parameter must be
         *        specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hsmArn(String hsmArn);

        /**
         * <p>
         * The serial number of the HSM. Either the <code>HsmArn</code> or the <code>HsmSerialNumber</code> parameter
         * must be specified.
         * </p>
         * 
         * @param hsmSerialNumber
         *        The serial number of the HSM. Either the <code>HsmArn</code> or the <code>HsmSerialNumber</code>
         *        parameter must be specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hsmSerialNumber(String hsmSerialNumber);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudHsmRequest.BuilderImpl implements Builder {
        private String hsmArn;

        private String hsmSerialNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeHsmRequest model) {
            super(model);
            hsmArn(model.hsmArn);
            hsmSerialNumber(model.hsmSerialNumber);
        }

        public final String getHsmArn() {
            return hsmArn;
        }

        public final void setHsmArn(String hsmArn) {
            this.hsmArn = hsmArn;
        }

        @Override
        public final Builder hsmArn(String hsmArn) {
            this.hsmArn = hsmArn;
            return this;
        }

        public final String getHsmSerialNumber() {
            return hsmSerialNumber;
        }

        public final void setHsmSerialNumber(String hsmSerialNumber) {
            this.hsmSerialNumber = hsmSerialNumber;
        }

        @Override
        public final Builder hsmSerialNumber(String hsmSerialNumber) {
            this.hsmSerialNumber = hsmSerialNumber;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeHsmRequest build() {
            return new DescribeHsmRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
