/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudhsm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyHapgRequest extends CloudHsmRequest implements
        ToCopyableBuilder<ModifyHapgRequest.Builder, ModifyHapgRequest> {
    private static final SdkField<String> HAPG_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HapgArn").getter(getter(ModifyHapgRequest::hapgArn)).setter(setter(Builder::hapgArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HapgArn").build()).build();

    private static final SdkField<String> LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Label")
            .getter(getter(ModifyHapgRequest::label)).setter(setter(Builder::label))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Label").build()).build();

    private static final SdkField<List<String>> PARTITION_SERIAL_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("PartitionSerialList")
            .getter(getter(ModifyHapgRequest::partitionSerialList))
            .setter(setter(Builder::partitionSerialList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionSerialList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HAPG_ARN_FIELD, LABEL_FIELD,
            PARTITION_SERIAL_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String hapgArn;

    private final String label;

    private final List<String> partitionSerialList;

    private ModifyHapgRequest(BuilderImpl builder) {
        super(builder);
        this.hapgArn = builder.hapgArn;
        this.label = builder.label;
        this.partitionSerialList = builder.partitionSerialList;
    }

    /**
     * <p>
     * The ARN of the high-availability partition group to modify.
     * </p>
     * 
     * @return The ARN of the high-availability partition group to modify.
     */
    public final String hapgArn() {
        return hapgArn;
    }

    /**
     * <p>
     * The new label for the high-availability partition group.
     * </p>
     * 
     * @return The new label for the high-availability partition group.
     */
    public final String label() {
        return label;
    }

    /**
     * For responses, this returns true if the service returned a value for the PartitionSerialList property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPartitionSerialList() {
        return partitionSerialList != null && !(partitionSerialList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of partition serial numbers to make members of the high-availability partition group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPartitionSerialList} method.
     * </p>
     * 
     * @return The list of partition serial numbers to make members of the high-availability partition group.
     */
    public final List<String> partitionSerialList() {
        return partitionSerialList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hapgArn());
        hashCode = 31 * hashCode + Objects.hashCode(label());
        hashCode = 31 * hashCode + Objects.hashCode(hasPartitionSerialList() ? partitionSerialList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyHapgRequest)) {
            return false;
        }
        ModifyHapgRequest other = (ModifyHapgRequest) obj;
        return Objects.equals(hapgArn(), other.hapgArn()) && Objects.equals(label(), other.label())
                && hasPartitionSerialList() == other.hasPartitionSerialList()
                && Objects.equals(partitionSerialList(), other.partitionSerialList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyHapgRequest").add("HapgArn", hapgArn()).add("Label", label())
                .add("PartitionSerialList", hasPartitionSerialList() ? partitionSerialList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HapgArn":
            return Optional.ofNullable(clazz.cast(hapgArn()));
        case "Label":
            return Optional.ofNullable(clazz.cast(label()));
        case "PartitionSerialList":
            return Optional.ofNullable(clazz.cast(partitionSerialList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("HapgArn", HAPG_ARN_FIELD);
        map.put("Label", LABEL_FIELD);
        map.put("PartitionSerialList", PARTITION_SERIAL_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyHapgRequest, T> g) {
        return obj -> g.apply((ModifyHapgRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudHsmRequest.Builder, SdkPojo, CopyableBuilder<Builder, ModifyHapgRequest> {
        /**
         * <p>
         * The ARN of the high-availability partition group to modify.
         * </p>
         * 
         * @param hapgArn
         *        The ARN of the high-availability partition group to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hapgArn(String hapgArn);

        /**
         * <p>
         * The new label for the high-availability partition group.
         * </p>
         * 
         * @param label
         *        The new label for the high-availability partition group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder label(String label);

        /**
         * <p>
         * The list of partition serial numbers to make members of the high-availability partition group.
         * </p>
         * 
         * @param partitionSerialList
         *        The list of partition serial numbers to make members of the high-availability partition group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitionSerialList(Collection<String> partitionSerialList);

        /**
         * <p>
         * The list of partition serial numbers to make members of the high-availability partition group.
         * </p>
         * 
         * @param partitionSerialList
         *        The list of partition serial numbers to make members of the high-availability partition group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitionSerialList(String... partitionSerialList);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudHsmRequest.BuilderImpl implements Builder {
        private String hapgArn;

        private String label;

        private List<String> partitionSerialList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyHapgRequest model) {
            super(model);
            hapgArn(model.hapgArn);
            label(model.label);
            partitionSerialList(model.partitionSerialList);
        }

        public final String getHapgArn() {
            return hapgArn;
        }

        public final void setHapgArn(String hapgArn) {
            this.hapgArn = hapgArn;
        }

        @Override
        public final Builder hapgArn(String hapgArn) {
            this.hapgArn = hapgArn;
            return this;
        }

        public final String getLabel() {
            return label;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        @Override
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        public final Collection<String> getPartitionSerialList() {
            if (partitionSerialList instanceof SdkAutoConstructList) {
                return null;
            }
            return partitionSerialList;
        }

        public final void setPartitionSerialList(Collection<String> partitionSerialList) {
            this.partitionSerialList = PartitionSerialListCopier.copy(partitionSerialList);
        }

        @Override
        public final Builder partitionSerialList(Collection<String> partitionSerialList) {
            this.partitionSerialList = PartitionSerialListCopier.copy(partitionSerialList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitionSerialList(String... partitionSerialList) {
            partitionSerialList(Arrays.asList(partitionSerialList));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyHapgRequest build() {
            return new ModifyHapgRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
