/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudhsmv2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CopyBackupToRegionResponse extends CloudHsmV2Response implements
        ToCopyableBuilder<CopyBackupToRegionResponse.Builder, CopyBackupToRegionResponse> {
    private static final SdkField<DestinationBackup> DESTINATION_BACKUP_FIELD = SdkField
            .<DestinationBackup> builder(MarshallingType.SDK_POJO).memberName("DestinationBackup")
            .getter(getter(CopyBackupToRegionResponse::destinationBackup)).setter(setter(Builder::destinationBackup))
            .constructor(DestinationBackup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationBackup").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_BACKUP_FIELD));

    private final DestinationBackup destinationBackup;

    private CopyBackupToRegionResponse(BuilderImpl builder) {
        super(builder);
        this.destinationBackup = builder.destinationBackup;
    }

    /**
     * <p>
     * Information on the backup that will be copied to the destination region, including CreateTimestamp, SourceBackup,
     * SourceCluster, and Source Region. CreateTimestamp of the destination backup will be the same as that of the
     * source backup.
     * </p>
     * <p>
     * You will need to use the <code>sourceBackupID</code> returned in this operation to use the <a>DescribeBackups</a>
     * operation on the backup that will be copied to the destination region.
     * </p>
     * 
     * @return Information on the backup that will be copied to the destination region, including CreateTimestamp,
     *         SourceBackup, SourceCluster, and Source Region. CreateTimestamp of the destination backup will be the
     *         same as that of the source backup.</p>
     *         <p>
     *         You will need to use the <code>sourceBackupID</code> returned in this operation to use the
     *         <a>DescribeBackups</a> operation on the backup that will be copied to the destination region.
     */
    public final DestinationBackup destinationBackup() {
        return destinationBackup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(destinationBackup());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyBackupToRegionResponse)) {
            return false;
        }
        CopyBackupToRegionResponse other = (CopyBackupToRegionResponse) obj;
        return Objects.equals(destinationBackup(), other.destinationBackup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CopyBackupToRegionResponse").add("DestinationBackup", destinationBackup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DestinationBackup":
            return Optional.ofNullable(clazz.cast(destinationBackup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CopyBackupToRegionResponse, T> g) {
        return obj -> g.apply((CopyBackupToRegionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudHsmV2Response.Builder, SdkPojo, CopyableBuilder<Builder, CopyBackupToRegionResponse> {
        /**
         * <p>
         * Information on the backup that will be copied to the destination region, including CreateTimestamp,
         * SourceBackup, SourceCluster, and Source Region. CreateTimestamp of the destination backup will be the same as
         * that of the source backup.
         * </p>
         * <p>
         * You will need to use the <code>sourceBackupID</code> returned in this operation to use the
         * <a>DescribeBackups</a> operation on the backup that will be copied to the destination region.
         * </p>
         * 
         * @param destinationBackup
         *        Information on the backup that will be copied to the destination region, including CreateTimestamp,
         *        SourceBackup, SourceCluster, and Source Region. CreateTimestamp of the destination backup will be the
         *        same as that of the source backup.</p>
         *        <p>
         *        You will need to use the <code>sourceBackupID</code> returned in this operation to use the
         *        <a>DescribeBackups</a> operation on the backup that will be copied to the destination region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationBackup(DestinationBackup destinationBackup);

        /**
         * <p>
         * Information on the backup that will be copied to the destination region, including CreateTimestamp,
         * SourceBackup, SourceCluster, and Source Region. CreateTimestamp of the destination backup will be the same as
         * that of the source backup.
         * </p>
         * <p>
         * You will need to use the <code>sourceBackupID</code> returned in this operation to use the
         * <a>DescribeBackups</a> operation on the backup that will be copied to the destination region.
         * </p>
         * This is a convenience that creates an instance of the {@link DestinationBackup.Builder} avoiding the need to
         * create one manually via {@link DestinationBackup#builder()}.
         *
         * When the {@link Consumer} completes, {@link DestinationBackup.Builder#build()} is called immediately and its
         * result is passed to {@link #destinationBackup(DestinationBackup)}.
         * 
         * @param destinationBackup
         *        a consumer that will call methods on {@link DestinationBackup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationBackup(DestinationBackup)
         */
        default Builder destinationBackup(Consumer<DestinationBackup.Builder> destinationBackup) {
            return destinationBackup(DestinationBackup.builder().applyMutation(destinationBackup).build());
        }
    }

    static final class BuilderImpl extends CloudHsmV2Response.BuilderImpl implements Builder {
        private DestinationBackup destinationBackup;

        private BuilderImpl() {
        }

        private BuilderImpl(CopyBackupToRegionResponse model) {
            super(model);
            destinationBackup(model.destinationBackup);
        }

        public final DestinationBackup.Builder getDestinationBackup() {
            return destinationBackup != null ? destinationBackup.toBuilder() : null;
        }

        public final void setDestinationBackup(DestinationBackup.BuilderImpl destinationBackup) {
            this.destinationBackup = destinationBackup != null ? destinationBackup.build() : null;
        }

        @Override
        @Transient
        public final Builder destinationBackup(DestinationBackup destinationBackup) {
            this.destinationBackup = destinationBackup;
            return this;
        }

        @Override
        public CopyBackupToRegionResponse build() {
            return new CopyBackupToRegionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
