/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudhsmv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeBackupsRequest extends CloudHsmV2Request implements
        ToCopyableBuilder<DescribeBackupsRequest.Builder, DescribeBackupsRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeBackupsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(DescribeBackupsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<Map<String, List<String>>> FILTERS_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .memberName("Filters")
            .getter(getter(DescribeBackupsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<Boolean> SORT_ASCENDING_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SortAscending").getter(getter(DescribeBackupsRequest::sortAscending))
            .setter(setter(Builder::sortAscending))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortAscending").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            MAX_RESULTS_FIELD, FILTERS_FIELD, SORT_ASCENDING_FIELD));

    private final String nextToken;

    private final Integer maxResults;

    private final Map<String, List<String>> filters;

    private final Boolean sortAscending;

    private DescribeBackupsRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.filters = builder.filters;
        this.sortAscending = builder.sortAscending;
    }

    /**
     * <p>
     * The <code>NextToken</code> value that you received in the previous response. Use this value to get more backups.
     * </p>
     * 
     * @return The <code>NextToken</code> value that you received in the previous response. Use this value to get more
     *         backups.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of backups to return in the response. When there are more backups than the number you specify,
     * the response contains a <code>NextToken</code> value.
     * </p>
     * 
     * @return The maximum number of backups to return in the response. When there are more backups than the number you
     *         specify, the response contains a <code>NextToken</code> value.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * One or more filters to limit the items returned in the response.
     * </p>
     * <p>
     * Use the <code>backupIds</code> filter to return only the specified backups. Specify backups by their backup
     * identifier (ID).
     * </p>
     * <p>
     * Use the <code>sourceBackupIds</code> filter to return only the backups created from a source backup. The
     * <code>sourceBackupID</code> of a source backup is returned by the <a>CopyBackupToRegion</a> operation.
     * </p>
     * <p>
     * Use the <code>clusterIds</code> filter to return only the backups for the specified clusters. Specify clusters by
     * their cluster identifier (ID).
     * </p>
     * <p>
     * Use the <code>states</code> filter to return only backups that match the specified state.
     * </p>
     * <p>
     * Use the <code>neverExpires</code> filter to return backups filtered by the value in the <code>neverExpires</code>
     * parameter. <code>True</code> returns all backups exempt from the backup retention policy. <code>False</code>
     * returns all backups with a backup retention policy defined at the cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return One or more filters to limit the items returned in the response.</p>
     *         <p>
     *         Use the <code>backupIds</code> filter to return only the specified backups. Specify backups by their
     *         backup identifier (ID).
     *         </p>
     *         <p>
     *         Use the <code>sourceBackupIds</code> filter to return only the backups created from a source backup. The
     *         <code>sourceBackupID</code> of a source backup is returned by the <a>CopyBackupToRegion</a> operation.
     *         </p>
     *         <p>
     *         Use the <code>clusterIds</code> filter to return only the backups for the specified clusters. Specify
     *         clusters by their cluster identifier (ID).
     *         </p>
     *         <p>
     *         Use the <code>states</code> filter to return only backups that match the specified state.
     *         </p>
     *         <p>
     *         Use the <code>neverExpires</code> filter to return backups filtered by the value in the
     *         <code>neverExpires</code> parameter. <code>True</code> returns all backups exempt from the backup
     *         retention policy. <code>False</code> returns all backups with a backup retention policy defined at the
     *         cluster.
     */
    public final Map<String, List<String>> filters() {
        return filters;
    }

    /**
     * <p>
     * Designates whether or not to sort the return backups by ascending chronological order of generation.
     * </p>
     * 
     * @return Designates whether or not to sort the return backups by ascending chronological order of generation.
     */
    public final Boolean sortAscending() {
        return sortAscending;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sortAscending());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeBackupsRequest)) {
            return false;
        }
        DescribeBackupsRequest other = (DescribeBackupsRequest) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters())
                && Objects.equals(sortAscending(), other.sortAscending());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeBackupsRequest").add("NextToken", nextToken()).add("MaxResults", maxResults())
                .add("Filters", hasFilters() ? filters() : null).add("SortAscending", sortAscending()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "SortAscending":
            return Optional.ofNullable(clazz.cast(sortAscending()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeBackupsRequest, T> g) {
        return obj -> g.apply((DescribeBackupsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudHsmV2Request.Builder, SdkPojo, CopyableBuilder<Builder, DescribeBackupsRequest> {
        /**
         * <p>
         * The <code>NextToken</code> value that you received in the previous response. Use this value to get more
         * backups.
         * </p>
         * 
         * @param nextToken
         *        The <code>NextToken</code> value that you received in the previous response. Use this value to get
         *        more backups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of backups to return in the response. When there are more backups than the number you
         * specify, the response contains a <code>NextToken</code> value.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of backups to return in the response. When there are more backups than the number
         *        you specify, the response contains a <code>NextToken</code> value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * One or more filters to limit the items returned in the response.
         * </p>
         * <p>
         * Use the <code>backupIds</code> filter to return only the specified backups. Specify backups by their backup
         * identifier (ID).
         * </p>
         * <p>
         * Use the <code>sourceBackupIds</code> filter to return only the backups created from a source backup. The
         * <code>sourceBackupID</code> of a source backup is returned by the <a>CopyBackupToRegion</a> operation.
         * </p>
         * <p>
         * Use the <code>clusterIds</code> filter to return only the backups for the specified clusters. Specify
         * clusters by their cluster identifier (ID).
         * </p>
         * <p>
         * Use the <code>states</code> filter to return only backups that match the specified state.
         * </p>
         * <p>
         * Use the <code>neverExpires</code> filter to return backups filtered by the value in the
         * <code>neverExpires</code> parameter. <code>True</code> returns all backups exempt from the backup retention
         * policy. <code>False</code> returns all backups with a backup retention policy defined at the cluster.
         * </p>
         * 
         * @param filters
         *        One or more filters to limit the items returned in the response.</p>
         *        <p>
         *        Use the <code>backupIds</code> filter to return only the specified backups. Specify backups by their
         *        backup identifier (ID).
         *        </p>
         *        <p>
         *        Use the <code>sourceBackupIds</code> filter to return only the backups created from a source backup.
         *        The <code>sourceBackupID</code> of a source backup is returned by the <a>CopyBackupToRegion</a>
         *        operation.
         *        </p>
         *        <p>
         *        Use the <code>clusterIds</code> filter to return only the backups for the specified clusters. Specify
         *        clusters by their cluster identifier (ID).
         *        </p>
         *        <p>
         *        Use the <code>states</code> filter to return only backups that match the specified state.
         *        </p>
         *        <p>
         *        Use the <code>neverExpires</code> filter to return backups filtered by the value in the
         *        <code>neverExpires</code> parameter. <code>True</code> returns all backups exempt from the backup
         *        retention policy. <code>False</code> returns all backups with a backup retention policy defined at the
         *        cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Map<String, ? extends Collection<String>> filters);

        /**
         * <p>
         * Designates whether or not to sort the return backups by ascending chronological order of generation.
         * </p>
         * 
         * @param sortAscending
         *        Designates whether or not to sort the return backups by ascending chronological order of generation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortAscending(Boolean sortAscending);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudHsmV2Request.BuilderImpl implements Builder {
        private String nextToken;

        private Integer maxResults;

        private Map<String, List<String>> filters = DefaultSdkAutoConstructMap.getInstance();

        private Boolean sortAscending;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeBackupsRequest model) {
            super(model);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            filters(model.filters);
            sortAscending(model.sortAscending);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Map<String, ? extends Collection<String>> getFilters() {
            if (filters instanceof SdkAutoConstructMap) {
                return null;
            }
            return filters;
        }

        public final void setFilters(Map<String, ? extends Collection<String>> filters) {
            this.filters = FiltersCopier.copy(filters);
        }

        @Override
        public final Builder filters(Map<String, ? extends Collection<String>> filters) {
            this.filters = FiltersCopier.copy(filters);
            return this;
        }

        public final Boolean getSortAscending() {
            return sortAscending;
        }

        public final void setSortAscending(Boolean sortAscending) {
            this.sortAscending = sortAscending;
        }

        @Override
        public final Builder sortAscending(Boolean sortAscending) {
            this.sortAscending = sortAscending;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeBackupsRequest build() {
            return new DescribeBackupsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
