/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudhsmv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateHsmResponse extends CloudHsmV2Response implements
        ToCopyableBuilder<CreateHsmResponse.Builder, CreateHsmResponse> {
    private static final SdkField<Hsm> HSM_FIELD = SdkField.<Hsm> builder(MarshallingType.SDK_POJO).memberName("Hsm")
            .getter(getter(CreateHsmResponse::hsm)).setter(setter(Builder::hsm)).constructor(Hsm::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Hsm").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HSM_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Hsm hsm;

    private CreateHsmResponse(BuilderImpl builder) {
        super(builder);
        this.hsm = builder.hsm;
    }

    /**
     * <p>
     * Information about the HSM that was created.
     * </p>
     * 
     * @return Information about the HSM that was created.
     */
    public final Hsm hsm() {
        return hsm;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hsm());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateHsmResponse)) {
            return false;
        }
        CreateHsmResponse other = (CreateHsmResponse) obj;
        return Objects.equals(hsm(), other.hsm());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateHsmResponse").add("Hsm", hsm()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Hsm":
            return Optional.ofNullable(clazz.cast(hsm()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Hsm", HSM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateHsmResponse, T> g) {
        return obj -> g.apply((CreateHsmResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudHsmV2Response.Builder, SdkPojo, CopyableBuilder<Builder, CreateHsmResponse> {
        /**
         * <p>
         * Information about the HSM that was created.
         * </p>
         * 
         * @param hsm
         *        Information about the HSM that was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hsm(Hsm hsm);

        /**
         * <p>
         * Information about the HSM that was created.
         * </p>
         * This is a convenience method that creates an instance of the {@link Hsm.Builder} avoiding the need to create
         * one manually via {@link Hsm#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Hsm.Builder#build()} is called immediately and its result is
         * passed to {@link #hsm(Hsm)}.
         * 
         * @param hsm
         *        a consumer that will call methods on {@link Hsm.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hsm(Hsm)
         */
        default Builder hsm(Consumer<Hsm.Builder> hsm) {
            return hsm(Hsm.builder().applyMutation(hsm).build());
        }
    }

    static final class BuilderImpl extends CloudHsmV2Response.BuilderImpl implements Builder {
        private Hsm hsm;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateHsmResponse model) {
            super(model);
            hsm(model.hsm);
        }

        public final Hsm.Builder getHsm() {
            return hsm != null ? hsm.toBuilder() : null;
        }

        public final void setHsm(Hsm.BuilderImpl hsm) {
            this.hsm = hsm != null ? hsm.build() : null;
        }

        @Override
        public final Builder hsm(Hsm hsm) {
            this.hsm = hsm;
            return this;
        }

        @Override
        public CreateHsmResponse build() {
            return new CreateHsmResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
