/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudhsmv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the backup that will be copied and created by the <a>CopyBackupToRegion</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DestinationBackup implements SdkPojo, Serializable,
        ToCopyableBuilder<DestinationBackup.Builder, DestinationBackup> {
    private static final SdkField<Instant> CREATE_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreateTimestamp").getter(getter(DestinationBackup::createTimestamp))
            .setter(setter(Builder::createTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTimestamp").build()).build();

    private static final SdkField<String> SOURCE_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceRegion").getter(getter(DestinationBackup::sourceRegion)).setter(setter(Builder::sourceRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceRegion").build()).build();

    private static final SdkField<String> SOURCE_BACKUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceBackup").getter(getter(DestinationBackup::sourceBackup)).setter(setter(Builder::sourceBackup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceBackup").build()).build();

    private static final SdkField<String> SOURCE_CLUSTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceCluster").getter(getter(DestinationBackup::sourceCluster)).setter(setter(Builder::sourceCluster))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceCluster").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATE_TIMESTAMP_FIELD,
            SOURCE_REGION_FIELD, SOURCE_BACKUP_FIELD, SOURCE_CLUSTER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant createTimestamp;

    private final String sourceRegion;

    private final String sourceBackup;

    private final String sourceCluster;

    private DestinationBackup(BuilderImpl builder) {
        this.createTimestamp = builder.createTimestamp;
        this.sourceRegion = builder.sourceRegion;
        this.sourceBackup = builder.sourceBackup;
        this.sourceCluster = builder.sourceCluster;
    }

    /**
     * <p>
     * The date and time when both the source backup was created.
     * </p>
     * 
     * @return The date and time when both the source backup was created.
     */
    public final Instant createTimestamp() {
        return createTimestamp;
    }

    /**
     * <p>
     * The AWS region that contains the source backup from which the new backup was copied.
     * </p>
     * 
     * @return The AWS region that contains the source backup from which the new backup was copied.
     */
    public final String sourceRegion() {
        return sourceRegion;
    }

    /**
     * <p>
     * The identifier (ID) of the source backup from which the new backup was copied.
     * </p>
     * 
     * @return The identifier (ID) of the source backup from which the new backup was copied.
     */
    public final String sourceBackup() {
        return sourceBackup;
    }

    /**
     * <p>
     * The identifier (ID) of the cluster containing the source backup from which the new backup was copied.
     * </p>
     * 
     * @return The identifier (ID) of the cluster containing the source backup from which the new backup was copied.
     */
    public final String sourceCluster() {
        return sourceCluster;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(sourceRegion());
        hashCode = 31 * hashCode + Objects.hashCode(sourceBackup());
        hashCode = 31 * hashCode + Objects.hashCode(sourceCluster());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DestinationBackup)) {
            return false;
        }
        DestinationBackup other = (DestinationBackup) obj;
        return Objects.equals(createTimestamp(), other.createTimestamp()) && Objects.equals(sourceRegion(), other.sourceRegion())
                && Objects.equals(sourceBackup(), other.sourceBackup()) && Objects.equals(sourceCluster(), other.sourceCluster());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DestinationBackup").add("CreateTimestamp", createTimestamp())
                .add("SourceRegion", sourceRegion()).add("SourceBackup", sourceBackup()).add("SourceCluster", sourceCluster())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreateTimestamp":
            return Optional.ofNullable(clazz.cast(createTimestamp()));
        case "SourceRegion":
            return Optional.ofNullable(clazz.cast(sourceRegion()));
        case "SourceBackup":
            return Optional.ofNullable(clazz.cast(sourceBackup()));
        case "SourceCluster":
            return Optional.ofNullable(clazz.cast(sourceCluster()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CreateTimestamp", CREATE_TIMESTAMP_FIELD);
        map.put("SourceRegion", SOURCE_REGION_FIELD);
        map.put("SourceBackup", SOURCE_BACKUP_FIELD);
        map.put("SourceCluster", SOURCE_CLUSTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DestinationBackup, T> g) {
        return obj -> g.apply((DestinationBackup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DestinationBackup> {
        /**
         * <p>
         * The date and time when both the source backup was created.
         * </p>
         * 
         * @param createTimestamp
         *        The date and time when both the source backup was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTimestamp(Instant createTimestamp);

        /**
         * <p>
         * The AWS region that contains the source backup from which the new backup was copied.
         * </p>
         * 
         * @param sourceRegion
         *        The AWS region that contains the source backup from which the new backup was copied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceRegion(String sourceRegion);

        /**
         * <p>
         * The identifier (ID) of the source backup from which the new backup was copied.
         * </p>
         * 
         * @param sourceBackup
         *        The identifier (ID) of the source backup from which the new backup was copied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceBackup(String sourceBackup);

        /**
         * <p>
         * The identifier (ID) of the cluster containing the source backup from which the new backup was copied.
         * </p>
         * 
         * @param sourceCluster
         *        The identifier (ID) of the cluster containing the source backup from which the new backup was copied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceCluster(String sourceCluster);
    }

    static final class BuilderImpl implements Builder {
        private Instant createTimestamp;

        private String sourceRegion;

        private String sourceBackup;

        private String sourceCluster;

        private BuilderImpl() {
        }

        private BuilderImpl(DestinationBackup model) {
            createTimestamp(model.createTimestamp);
            sourceRegion(model.sourceRegion);
            sourceBackup(model.sourceBackup);
            sourceCluster(model.sourceCluster);
        }

        public final Instant getCreateTimestamp() {
            return createTimestamp;
        }

        public final void setCreateTimestamp(Instant createTimestamp) {
            this.createTimestamp = createTimestamp;
        }

        @Override
        public final Builder createTimestamp(Instant createTimestamp) {
            this.createTimestamp = createTimestamp;
            return this;
        }

        public final String getSourceRegion() {
            return sourceRegion;
        }

        public final void setSourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
        }

        @Override
        public final Builder sourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
            return this;
        }

        public final String getSourceBackup() {
            return sourceBackup;
        }

        public final void setSourceBackup(String sourceBackup) {
            this.sourceBackup = sourceBackup;
        }

        @Override
        public final Builder sourceBackup(String sourceBackup) {
            this.sourceBackup = sourceBackup;
            return this;
        }

        public final String getSourceCluster() {
            return sourceCluster;
        }

        public final void setSourceCluster(String sourceCluster) {
            this.sourceCluster = sourceCluster;
        }

        @Override
        public final Builder sourceCluster(String sourceCluster) {
            this.sourceCluster = sourceCluster;
            return this;
        }

        @Override
        public DestinationBackup build() {
            return new DestinationBackup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
