/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudhsmv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyBackupAttributesRequest extends CloudHsmV2Request implements
        ToCopyableBuilder<ModifyBackupAttributesRequest.Builder, ModifyBackupAttributesRequest> {
    private static final SdkField<String> BACKUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackupId").getter(getter(ModifyBackupAttributesRequest::backupId)).setter(setter(Builder::backupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupId").build()).build();

    private static final SdkField<Boolean> NEVER_EXPIRES_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("NeverExpires").getter(getter(ModifyBackupAttributesRequest::neverExpires))
            .setter(setter(Builder::neverExpires))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NeverExpires").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_ID_FIELD,
            NEVER_EXPIRES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String backupId;

    private final Boolean neverExpires;

    private ModifyBackupAttributesRequest(BuilderImpl builder) {
        super(builder);
        this.backupId = builder.backupId;
        this.neverExpires = builder.neverExpires;
    }

    /**
     * <p>
     * The identifier (ID) of the backup to modify. To find the ID of a backup, use the <a>DescribeBackups</a>
     * operation.
     * </p>
     * 
     * @return The identifier (ID) of the backup to modify. To find the ID of a backup, use the <a>DescribeBackups</a>
     *         operation.
     */
    public final String backupId() {
        return backupId;
    }

    /**
     * <p>
     * Specifies whether the service should exempt a backup from the retention policy for the cluster. <code>True</code>
     * exempts a backup from the retention policy. <code>False</code> means the service applies the backup retention
     * policy defined at the cluster.
     * </p>
     * 
     * @return Specifies whether the service should exempt a backup from the retention policy for the cluster.
     *         <code>True</code> exempts a backup from the retention policy. <code>False</code> means the service
     *         applies the backup retention policy defined at the cluster.
     */
    public final Boolean neverExpires() {
        return neverExpires;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(backupId());
        hashCode = 31 * hashCode + Objects.hashCode(neverExpires());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyBackupAttributesRequest)) {
            return false;
        }
        ModifyBackupAttributesRequest other = (ModifyBackupAttributesRequest) obj;
        return Objects.equals(backupId(), other.backupId()) && Objects.equals(neverExpires(), other.neverExpires());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyBackupAttributesRequest").add("BackupId", backupId()).add("NeverExpires", neverExpires())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BackupId":
            return Optional.ofNullable(clazz.cast(backupId()));
        case "NeverExpires":
            return Optional.ofNullable(clazz.cast(neverExpires()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BackupId", BACKUP_ID_FIELD);
        map.put("NeverExpires", NEVER_EXPIRES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyBackupAttributesRequest, T> g) {
        return obj -> g.apply((ModifyBackupAttributesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudHsmV2Request.Builder, SdkPojo, CopyableBuilder<Builder, ModifyBackupAttributesRequest> {
        /**
         * <p>
         * The identifier (ID) of the backup to modify. To find the ID of a backup, use the <a>DescribeBackups</a>
         * operation.
         * </p>
         * 
         * @param backupId
         *        The identifier (ID) of the backup to modify. To find the ID of a backup, use the
         *        <a>DescribeBackups</a> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupId(String backupId);

        /**
         * <p>
         * Specifies whether the service should exempt a backup from the retention policy for the cluster.
         * <code>True</code> exempts a backup from the retention policy. <code>False</code> means the service applies
         * the backup retention policy defined at the cluster.
         * </p>
         * 
         * @param neverExpires
         *        Specifies whether the service should exempt a backup from the retention policy for the cluster.
         *        <code>True</code> exempts a backup from the retention policy. <code>False</code> means the service
         *        applies the backup retention policy defined at the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder neverExpires(Boolean neverExpires);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudHsmV2Request.BuilderImpl implements Builder {
        private String backupId;

        private Boolean neverExpires;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyBackupAttributesRequest model) {
            super(model);
            backupId(model.backupId);
            neverExpires(model.neverExpires);
        }

        public final String getBackupId() {
            return backupId;
        }

        public final void setBackupId(String backupId) {
            this.backupId = backupId;
        }

        @Override
        public final Builder backupId(String backupId) {
            this.backupId = backupId;
            return this;
        }

        public final Boolean getNeverExpires() {
            return neverExpires;
        }

        public final void setNeverExpires(Boolean neverExpires) {
            this.neverExpires = neverExpires;
        }

        @Override
        public final Builder neverExpires(Boolean neverExpires) {
            this.neverExpires = neverExpires;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyBackupAttributesRequest build() {
            return new ModifyBackupAttributesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
