/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudhsmv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CopyBackupToRegionRequest extends CloudHsmV2Request implements
        ToCopyableBuilder<CopyBackupToRegionRequest.Builder, CopyBackupToRegionRequest> {
    private static final SdkField<String> DESTINATION_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationRegion").getter(getter(CopyBackupToRegionRequest::destinationRegion))
            .setter(setter(Builder::destinationRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationRegion").build()).build();

    private static final SdkField<String> BACKUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackupId").getter(getter(CopyBackupToRegionRequest::backupId)).setter(setter(Builder::backupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupId").build()).build();

    private static final SdkField<List<Tag>> TAG_LIST_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("TagList")
            .getter(getter(CopyBackupToRegionRequest::tagList))
            .setter(setter(Builder::tagList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_REGION_FIELD,
            BACKUP_ID_FIELD, TAG_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String destinationRegion;

    private final String backupId;

    private final List<Tag> tagList;

    private CopyBackupToRegionRequest(BuilderImpl builder) {
        super(builder);
        this.destinationRegion = builder.destinationRegion;
        this.backupId = builder.backupId;
        this.tagList = builder.tagList;
    }

    /**
     * <p>
     * The AWS region that will contain your copied CloudHSM cluster backup.
     * </p>
     * 
     * @return The AWS region that will contain your copied CloudHSM cluster backup.
     */
    public final String destinationRegion() {
        return destinationRegion;
    }

    /**
     * <p>
     * The ID of the backup that will be copied to the destination region.
     * </p>
     * 
     * @return The ID of the backup that will be copied to the destination region.
     */
    public final String backupId() {
        return backupId;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagList property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTagList() {
        return tagList != null && !(tagList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Tags to apply to the destination backup during creation. If you specify tags, only these tags will be applied to
     * the destination backup. If you do not specify tags, the service copies tags from the source backup to the
     * destination backup.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagList} method.
     * </p>
     * 
     * @return Tags to apply to the destination backup during creation. If you specify tags, only these tags will be
     *         applied to the destination backup. If you do not specify tags, the service copies tags from the source
     *         backup to the destination backup.
     */
    public final List<Tag> tagList() {
        return tagList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(destinationRegion());
        hashCode = 31 * hashCode + Objects.hashCode(backupId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTagList() ? tagList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyBackupToRegionRequest)) {
            return false;
        }
        CopyBackupToRegionRequest other = (CopyBackupToRegionRequest) obj;
        return Objects.equals(destinationRegion(), other.destinationRegion()) && Objects.equals(backupId(), other.backupId())
                && hasTagList() == other.hasTagList() && Objects.equals(tagList(), other.tagList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CopyBackupToRegionRequest").add("DestinationRegion", destinationRegion())
                .add("BackupId", backupId()).add("TagList", hasTagList() ? tagList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DestinationRegion":
            return Optional.ofNullable(clazz.cast(destinationRegion()));
        case "BackupId":
            return Optional.ofNullable(clazz.cast(backupId()));
        case "TagList":
            return Optional.ofNullable(clazz.cast(tagList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DestinationRegion", DESTINATION_REGION_FIELD);
        map.put("BackupId", BACKUP_ID_FIELD);
        map.put("TagList", TAG_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CopyBackupToRegionRequest, T> g) {
        return obj -> g.apply((CopyBackupToRegionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudHsmV2Request.Builder, SdkPojo, CopyableBuilder<Builder, CopyBackupToRegionRequest> {
        /**
         * <p>
         * The AWS region that will contain your copied CloudHSM cluster backup.
         * </p>
         * 
         * @param destinationRegion
         *        The AWS region that will contain your copied CloudHSM cluster backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationRegion(String destinationRegion);

        /**
         * <p>
         * The ID of the backup that will be copied to the destination region.
         * </p>
         * 
         * @param backupId
         *        The ID of the backup that will be copied to the destination region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupId(String backupId);

        /**
         * <p>
         * Tags to apply to the destination backup during creation. If you specify tags, only these tags will be applied
         * to the destination backup. If you do not specify tags, the service copies tags from the source backup to the
         * destination backup.
         * </p>
         * 
         * @param tagList
         *        Tags to apply to the destination backup during creation. If you specify tags, only these tags will be
         *        applied to the destination backup. If you do not specify tags, the service copies tags from the source
         *        backup to the destination backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagList(Collection<Tag> tagList);

        /**
         * <p>
         * Tags to apply to the destination backup during creation. If you specify tags, only these tags will be applied
         * to the destination backup. If you do not specify tags, the service copies tags from the source backup to the
         * destination backup.
         * </p>
         * 
         * @param tagList
         *        Tags to apply to the destination backup during creation. If you specify tags, only these tags will be
         *        applied to the destination backup. If you do not specify tags, the service copies tags from the source
         *        backup to the destination backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagList(Tag... tagList);

        /**
         * <p>
         * Tags to apply to the destination backup during creation. If you specify tags, only these tags will be applied
         * to the destination backup. If you do not specify tags, the service copies tags from the source backup to the
         * destination backup.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudhsmv2.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.cloudhsmv2.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudhsmv2.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tagList(List<Tag>)}.
         * 
         * @param tagList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudhsmv2.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagList(java.util.Collection<Tag>)
         */
        Builder tagList(Consumer<Tag.Builder>... tagList);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudHsmV2Request.BuilderImpl implements Builder {
        private String destinationRegion;

        private String backupId;

        private List<Tag> tagList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CopyBackupToRegionRequest model) {
            super(model);
            destinationRegion(model.destinationRegion);
            backupId(model.backupId);
            tagList(model.tagList);
        }

        public final String getDestinationRegion() {
            return destinationRegion;
        }

        public final void setDestinationRegion(String destinationRegion) {
            this.destinationRegion = destinationRegion;
        }

        @Override
        public final Builder destinationRegion(String destinationRegion) {
            this.destinationRegion = destinationRegion;
            return this;
        }

        public final String getBackupId() {
            return backupId;
        }

        public final void setBackupId(String backupId) {
            this.backupId = backupId;
        }

        @Override
        public final Builder backupId(String backupId) {
            this.backupId = backupId;
            return this;
        }

        public final List<Tag.Builder> getTagList() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tagList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagList(Collection<Tag.BuilderImpl> tagList) {
            this.tagList = TagListCopier.copyFromBuilder(tagList);
        }

        @Override
        public final Builder tagList(Collection<Tag> tagList) {
            this.tagList = TagListCopier.copy(tagList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagList(Tag... tagList) {
            tagList(Arrays.asList(tagList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagList(Consumer<Tag.Builder>... tagList) {
            tagList(Stream.of(tagList).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CopyBackupToRegionRequest build() {
            return new CopyBackupToRegionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
