/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudhsmv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class InitializeClusterRequest extends CloudHsmV2Request implements
        ToCopyableBuilder<InitializeClusterRequest.Builder, InitializeClusterRequest> {
    private static final SdkField<String> CLUSTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterId").getter(getter(InitializeClusterRequest::clusterId)).setter(setter(Builder::clusterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterId").build()).build();

    private static final SdkField<String> SIGNED_CERT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SignedCert").getter(getter(InitializeClusterRequest::signedCert)).setter(setter(Builder::signedCert))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SignedCert").build()).build();

    private static final SdkField<String> TRUST_ANCHOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrustAnchor").getter(getter(InitializeClusterRequest::trustAnchor)).setter(setter(Builder::trustAnchor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustAnchor").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ID_FIELD,
            SIGNED_CERT_FIELD, TRUST_ANCHOR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clusterId;

    private final String signedCert;

    private final String trustAnchor;

    private InitializeClusterRequest(BuilderImpl builder) {
        super(builder);
        this.clusterId = builder.clusterId;
        this.signedCert = builder.signedCert;
        this.trustAnchor = builder.trustAnchor;
    }

    /**
     * <p>
     * The identifier (ID) of the cluster that you are claiming. To find the cluster ID, use <a>DescribeClusters</a>.
     * </p>
     * 
     * @return The identifier (ID) of the cluster that you are claiming. To find the cluster ID, use
     *         <a>DescribeClusters</a>.
     */
    public final String clusterId() {
        return clusterId;
    }

    /**
     * <p>
     * The cluster certificate issued (signed) by your issuing certificate authority (CA). The certificate must be in
     * PEM format and can contain a maximum of 5000 characters.
     * </p>
     * 
     * @return The cluster certificate issued (signed) by your issuing certificate authority (CA). The certificate must
     *         be in PEM format and can contain a maximum of 5000 characters.
     */
    public final String signedCert() {
        return signedCert;
    }

    /**
     * <p>
     * The issuing certificate of the issuing certificate authority (CA) that issued (signed) the cluster certificate.
     * You must use a self-signed certificate. The certificate used to sign the HSM CSR must be directly available, and
     * thus must be the root certificate. The certificate must be in PEM format and can contain a maximum of 5000
     * characters.
     * </p>
     * 
     * @return The issuing certificate of the issuing certificate authority (CA) that issued (signed) the cluster
     *         certificate. You must use a self-signed certificate. The certificate used to sign the HSM CSR must be
     *         directly available, and thus must be the root certificate. The certificate must be in PEM format and can
     *         contain a maximum of 5000 characters.
     */
    public final String trustAnchor() {
        return trustAnchor;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(signedCert());
        hashCode = 31 * hashCode + Objects.hashCode(trustAnchor());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InitializeClusterRequest)) {
            return false;
        }
        InitializeClusterRequest other = (InitializeClusterRequest) obj;
        return Objects.equals(clusterId(), other.clusterId()) && Objects.equals(signedCert(), other.signedCert())
                && Objects.equals(trustAnchor(), other.trustAnchor());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InitializeClusterRequest").add("ClusterId", clusterId()).add("SignedCert", signedCert())
                .add("TrustAnchor", trustAnchor()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterId":
            return Optional.ofNullable(clazz.cast(clusterId()));
        case "SignedCert":
            return Optional.ofNullable(clazz.cast(signedCert()));
        case "TrustAnchor":
            return Optional.ofNullable(clazz.cast(trustAnchor()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClusterId", CLUSTER_ID_FIELD);
        map.put("SignedCert", SIGNED_CERT_FIELD);
        map.put("TrustAnchor", TRUST_ANCHOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InitializeClusterRequest, T> g) {
        return obj -> g.apply((InitializeClusterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudHsmV2Request.Builder, SdkPojo, CopyableBuilder<Builder, InitializeClusterRequest> {
        /**
         * <p>
         * The identifier (ID) of the cluster that you are claiming. To find the cluster ID, use
         * <a>DescribeClusters</a>.
         * </p>
         * 
         * @param clusterId
         *        The identifier (ID) of the cluster that you are claiming. To find the cluster ID, use
         *        <a>DescribeClusters</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterId(String clusterId);

        /**
         * <p>
         * The cluster certificate issued (signed) by your issuing certificate authority (CA). The certificate must be
         * in PEM format and can contain a maximum of 5000 characters.
         * </p>
         * 
         * @param signedCert
         *        The cluster certificate issued (signed) by your issuing certificate authority (CA). The certificate
         *        must be in PEM format and can contain a maximum of 5000 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signedCert(String signedCert);

        /**
         * <p>
         * The issuing certificate of the issuing certificate authority (CA) that issued (signed) the cluster
         * certificate. You must use a self-signed certificate. The certificate used to sign the HSM CSR must be
         * directly available, and thus must be the root certificate. The certificate must be in PEM format and can
         * contain a maximum of 5000 characters.
         * </p>
         * 
         * @param trustAnchor
         *        The issuing certificate of the issuing certificate authority (CA) that issued (signed) the cluster
         *        certificate. You must use a self-signed certificate. The certificate used to sign the HSM CSR must be
         *        directly available, and thus must be the root certificate. The certificate must be in PEM format and
         *        can contain a maximum of 5000 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trustAnchor(String trustAnchor);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudHsmV2Request.BuilderImpl implements Builder {
        private String clusterId;

        private String signedCert;

        private String trustAnchor;

        private BuilderImpl() {
        }

        private BuilderImpl(InitializeClusterRequest model) {
            super(model);
            clusterId(model.clusterId);
            signedCert(model.signedCert);
            trustAnchor(model.trustAnchor);
        }

        public final String getClusterId() {
            return clusterId;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final String getSignedCert() {
            return signedCert;
        }

        public final void setSignedCert(String signedCert) {
            this.signedCert = signedCert;
        }

        @Override
        public final Builder signedCert(String signedCert) {
            this.signedCert = signedCert;
            return this;
        }

        public final String getTrustAnchor() {
            return trustAnchor;
        }

        public final void setTrustAnchor(String trustAnchor) {
            this.trustAnchor = trustAnchor;
        }

        @Override
        public final Builder trustAnchor(String trustAnchor) {
            this.trustAnchor = trustAnchor;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public InitializeClusterRequest build() {
            return new InitializeClusterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
