/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsmv2;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.cloudhsmv2.CloudHsmV2Client;
import software.amazon.awssdk.services.cloudhsmv2.CloudHsmV2ServiceClientConfiguration;
import software.amazon.awssdk.services.cloudhsmv2.internal.CloudHsmV2ServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.cloudhsmv2.model.CloudHsmAccessDeniedException;
import software.amazon.awssdk.services.cloudhsmv2.model.CloudHsmInternalFailureException;
import software.amazon.awssdk.services.cloudhsmv2.model.CloudHsmInvalidRequestException;
import software.amazon.awssdk.services.cloudhsmv2.model.CloudHsmResourceLimitExceededException;
import software.amazon.awssdk.services.cloudhsmv2.model.CloudHsmResourceNotFoundException;
import software.amazon.awssdk.services.cloudhsmv2.model.CloudHsmServiceException;
import software.amazon.awssdk.services.cloudhsmv2.model.CloudHsmTagException;
import software.amazon.awssdk.services.cloudhsmv2.model.CloudHsmV2Exception;
import software.amazon.awssdk.services.cloudhsmv2.model.CopyBackupToRegionRequest;
import software.amazon.awssdk.services.cloudhsmv2.model.CopyBackupToRegionResponse;
import software.amazon.awssdk.services.cloudhsmv2.model.CreateClusterRequest;
import software.amazon.awssdk.services.cloudhsmv2.model.CreateClusterResponse;
import software.amazon.awssdk.services.cloudhsmv2.model.CreateHsmRequest;
import software.amazon.awssdk.services.cloudhsmv2.model.CreateHsmResponse;
import software.amazon.awssdk.services.cloudhsmv2.model.DeleteBackupRequest;
import software.amazon.awssdk.services.cloudhsmv2.model.DeleteBackupResponse;
import software.amazon.awssdk.services.cloudhsmv2.model.DeleteClusterRequest;
import software.amazon.awssdk.services.cloudhsmv2.model.DeleteClusterResponse;
import software.amazon.awssdk.services.cloudhsmv2.model.DeleteHsmRequest;
import software.amazon.awssdk.services.cloudhsmv2.model.DeleteHsmResponse;
import software.amazon.awssdk.services.cloudhsmv2.model.DeleteResourcePolicyRequest;
import software.amazon.awssdk.services.cloudhsmv2.model.DeleteResourcePolicyResponse;
import software.amazon.awssdk.services.cloudhsmv2.model.DescribeBackupsRequest;
import software.amazon.awssdk.services.cloudhsmv2.model.DescribeBackupsResponse;
import software.amazon.awssdk.services.cloudhsmv2.model.DescribeClustersRequest;
import software.amazon.awssdk.services.cloudhsmv2.model.DescribeClustersResponse;
import software.amazon.awssdk.services.cloudhsmv2.model.GetResourcePolicyRequest;
import software.amazon.awssdk.services.cloudhsmv2.model.GetResourcePolicyResponse;
import software.amazon.awssdk.services.cloudhsmv2.model.InitializeClusterRequest;
import software.amazon.awssdk.services.cloudhsmv2.model.InitializeClusterResponse;
import software.amazon.awssdk.services.cloudhsmv2.model.ListTagsRequest;
import software.amazon.awssdk.services.cloudhsmv2.model.ListTagsResponse;
import software.amazon.awssdk.services.cloudhsmv2.model.ModifyBackupAttributesRequest;
import software.amazon.awssdk.services.cloudhsmv2.model.ModifyBackupAttributesResponse;
import software.amazon.awssdk.services.cloudhsmv2.model.ModifyClusterRequest;
import software.amazon.awssdk.services.cloudhsmv2.model.ModifyClusterResponse;
import software.amazon.awssdk.services.cloudhsmv2.model.PutResourcePolicyRequest;
import software.amazon.awssdk.services.cloudhsmv2.model.PutResourcePolicyResponse;
import software.amazon.awssdk.services.cloudhsmv2.model.RestoreBackupRequest;
import software.amazon.awssdk.services.cloudhsmv2.model.RestoreBackupResponse;
import software.amazon.awssdk.services.cloudhsmv2.model.TagResourceRequest;
import software.amazon.awssdk.services.cloudhsmv2.model.TagResourceResponse;
import software.amazon.awssdk.services.cloudhsmv2.model.UntagResourceRequest;
import software.amazon.awssdk.services.cloudhsmv2.model.UntagResourceResponse;
import software.amazon.awssdk.services.cloudhsmv2.transform.CopyBackupToRegionRequestMarshaller;
import software.amazon.awssdk.services.cloudhsmv2.transform.CreateClusterRequestMarshaller;
import software.amazon.awssdk.services.cloudhsmv2.transform.CreateHsmRequestMarshaller;
import software.amazon.awssdk.services.cloudhsmv2.transform.DeleteBackupRequestMarshaller;
import software.amazon.awssdk.services.cloudhsmv2.transform.DeleteClusterRequestMarshaller;
import software.amazon.awssdk.services.cloudhsmv2.transform.DeleteHsmRequestMarshaller;
import software.amazon.awssdk.services.cloudhsmv2.transform.DeleteResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudhsmv2.transform.DescribeBackupsRequestMarshaller;
import software.amazon.awssdk.services.cloudhsmv2.transform.DescribeClustersRequestMarshaller;
import software.amazon.awssdk.services.cloudhsmv2.transform.GetResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudhsmv2.transform.InitializeClusterRequestMarshaller;
import software.amazon.awssdk.services.cloudhsmv2.transform.ListTagsRequestMarshaller;
import software.amazon.awssdk.services.cloudhsmv2.transform.ModifyBackupAttributesRequestMarshaller;
import software.amazon.awssdk.services.cloudhsmv2.transform.ModifyClusterRequestMarshaller;
import software.amazon.awssdk.services.cloudhsmv2.transform.PutResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudhsmv2.transform.RestoreBackupRequestMarshaller;
import software.amazon.awssdk.services.cloudhsmv2.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.cloudhsmv2.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultCloudHsmV2Client
implements CloudHsmV2Client {
    private static final Logger log = Logger.loggerFor(DefaultCloudHsmV2Client.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultCloudHsmV2Client(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"CloudHSM_V2#2.32.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CopyBackupToRegionResponse copyBackupToRegion(CopyBackupToRegionRequest copyBackupToRegionRequest) throws CloudHsmAccessDeniedException, CloudHsmInternalFailureException, CloudHsmInvalidRequestException, CloudHsmResourceNotFoundException, CloudHsmServiceException, CloudHsmTagException, AwsServiceException, SdkClientException, CloudHsmV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CopyBackupToRegionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "CloudHsmInternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmInternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(CloudHsmInternalFailureException::builder).build());
                }
                case "CloudHsmTagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmTagException::builder).build());
                }
                case "CloudHsmServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmServiceException::builder).build());
                }
                case "CloudHsmAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmAccessDeniedException::builder).build());
                }
                case "CloudHsmResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmResourceNotFoundException::builder).build());
                }
                case "CloudHsmInvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmInvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmInvalidRequestException::builder).build());
                }
                case "CloudHsmResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmResourceLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)copyBackupToRegionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudHsmV2Client.resolveMetricPublishers(clientConfiguration, copyBackupToRegionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudHSM V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CopyBackupToRegion");
            CopyBackupToRegionResponse copyBackupToRegionResponse = (CopyBackupToRegionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CopyBackupToRegion").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)copyBackupToRegionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CopyBackupToRegionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return copyBackupToRegionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudHsmV2Client.lambda$copyBackupToRegion$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateClusterResponse createCluster(CreateClusterRequest createClusterRequest) throws CloudHsmAccessDeniedException, CloudHsmInternalFailureException, CloudHsmInvalidRequestException, CloudHsmResourceNotFoundException, CloudHsmServiceException, CloudHsmTagException, AwsServiceException, SdkClientException, CloudHsmV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateClusterResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "CloudHsmInternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmInternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(CloudHsmInternalFailureException::builder).build());
                }
                case "CloudHsmTagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmTagException::builder).build());
                }
                case "CloudHsmServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmServiceException::builder).build());
                }
                case "CloudHsmAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmAccessDeniedException::builder).build());
                }
                case "CloudHsmResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmResourceNotFoundException::builder).build());
                }
                case "CloudHsmInvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmInvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmInvalidRequestException::builder).build());
                }
                case "CloudHsmResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmResourceLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createClusterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudHsmV2Client.resolveMetricPublishers(clientConfiguration, createClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudHSM V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateCluster");
            CreateClusterResponse createClusterResponse = (CreateClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCluster").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createClusterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateClusterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createClusterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudHsmV2Client.lambda$createCluster$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateHsmResponse createHsm(CreateHsmRequest createHsmRequest) throws CloudHsmInternalFailureException, CloudHsmServiceException, CloudHsmInvalidRequestException, CloudHsmResourceNotFoundException, CloudHsmAccessDeniedException, AwsServiceException, SdkClientException, CloudHsmV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateHsmResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "CloudHsmInternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmInternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(CloudHsmInternalFailureException::builder).build());
                }
                case "CloudHsmTagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmTagException::builder).build());
                }
                case "CloudHsmServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmServiceException::builder).build());
                }
                case "CloudHsmAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmAccessDeniedException::builder).build());
                }
                case "CloudHsmResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmResourceNotFoundException::builder).build());
                }
                case "CloudHsmInvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmInvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmInvalidRequestException::builder).build());
                }
                case "CloudHsmResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmResourceLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createHsmRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudHsmV2Client.resolveMetricPublishers(clientConfiguration, createHsmRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudHSM V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateHsm");
            CreateHsmResponse createHsmResponse = (CreateHsmResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateHsm").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createHsmRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateHsmRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createHsmResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudHsmV2Client.lambda$createHsm$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteBackupResponse deleteBackup(DeleteBackupRequest deleteBackupRequest) throws CloudHsmAccessDeniedException, CloudHsmInternalFailureException, CloudHsmInvalidRequestException, CloudHsmResourceNotFoundException, CloudHsmServiceException, AwsServiceException, SdkClientException, CloudHsmV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteBackupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "CloudHsmInternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmInternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(CloudHsmInternalFailureException::builder).build());
                }
                case "CloudHsmTagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmTagException::builder).build());
                }
                case "CloudHsmServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmServiceException::builder).build());
                }
                case "CloudHsmAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmAccessDeniedException::builder).build());
                }
                case "CloudHsmResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmResourceNotFoundException::builder).build());
                }
                case "CloudHsmInvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmInvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmInvalidRequestException::builder).build());
                }
                case "CloudHsmResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmResourceLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteBackupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudHsmV2Client.resolveMetricPublishers(clientConfiguration, deleteBackupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudHSM V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteBackup");
            DeleteBackupResponse deleteBackupResponse = (DeleteBackupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBackup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteBackupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteBackupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteBackupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudHsmV2Client.lambda$deleteBackup$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteClusterResponse deleteCluster(DeleteClusterRequest deleteClusterRequest) throws CloudHsmAccessDeniedException, CloudHsmInternalFailureException, CloudHsmInvalidRequestException, CloudHsmResourceNotFoundException, CloudHsmServiceException, CloudHsmTagException, AwsServiceException, SdkClientException, CloudHsmV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteClusterResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "CloudHsmInternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmInternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(CloudHsmInternalFailureException::builder).build());
                }
                case "CloudHsmTagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmTagException::builder).build());
                }
                case "CloudHsmServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmServiceException::builder).build());
                }
                case "CloudHsmAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmAccessDeniedException::builder).build());
                }
                case "CloudHsmResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmResourceNotFoundException::builder).build());
                }
                case "CloudHsmInvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmInvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmInvalidRequestException::builder).build());
                }
                case "CloudHsmResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmResourceLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteClusterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudHsmV2Client.resolveMetricPublishers(clientConfiguration, deleteClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudHSM V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteCluster");
            DeleteClusterResponse deleteClusterResponse = (DeleteClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCluster").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteClusterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteClusterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteClusterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudHsmV2Client.lambda$deleteCluster$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteHsmResponse deleteHsm(DeleteHsmRequest deleteHsmRequest) throws CloudHsmInternalFailureException, CloudHsmServiceException, CloudHsmResourceNotFoundException, CloudHsmInvalidRequestException, CloudHsmAccessDeniedException, AwsServiceException, SdkClientException, CloudHsmV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteHsmResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "CloudHsmInternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmInternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(CloudHsmInternalFailureException::builder).build());
                }
                case "CloudHsmTagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmTagException::builder).build());
                }
                case "CloudHsmServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmServiceException::builder).build());
                }
                case "CloudHsmAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmAccessDeniedException::builder).build());
                }
                case "CloudHsmResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmResourceNotFoundException::builder).build());
                }
                case "CloudHsmInvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmInvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmInvalidRequestException::builder).build());
                }
                case "CloudHsmResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmResourceLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteHsmRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudHsmV2Client.resolveMetricPublishers(clientConfiguration, deleteHsmRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudHSM V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteHsm");
            DeleteHsmResponse deleteHsmResponse = (DeleteHsmResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteHsm").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteHsmRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteHsmRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteHsmResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudHsmV2Client.lambda$deleteHsm$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteResourcePolicyResponse deleteResourcePolicy(DeleteResourcePolicyRequest deleteResourcePolicyRequest) throws CloudHsmInternalFailureException, CloudHsmServiceException, CloudHsmInvalidRequestException, CloudHsmResourceNotFoundException, CloudHsmAccessDeniedException, AwsServiceException, SdkClientException, CloudHsmV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteResourcePolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "CloudHsmInternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmInternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(CloudHsmInternalFailureException::builder).build());
                }
                case "CloudHsmTagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmTagException::builder).build());
                }
                case "CloudHsmServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmServiceException::builder).build());
                }
                case "CloudHsmAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmAccessDeniedException::builder).build());
                }
                case "CloudHsmResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmResourceNotFoundException::builder).build());
                }
                case "CloudHsmInvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmInvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmInvalidRequestException::builder).build());
                }
                case "CloudHsmResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmResourceLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteResourcePolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudHsmV2Client.resolveMetricPublishers(clientConfiguration, deleteResourcePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudHSM V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteResourcePolicy");
            DeleteResourcePolicyResponse deleteResourcePolicyResponse = (DeleteResourcePolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteResourcePolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteResourcePolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteResourcePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteResourcePolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudHsmV2Client.lambda$deleteResourcePolicy$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeBackupsResponse describeBackups(DescribeBackupsRequest describeBackupsRequest) throws CloudHsmAccessDeniedException, CloudHsmInternalFailureException, CloudHsmInvalidRequestException, CloudHsmResourceNotFoundException, CloudHsmServiceException, CloudHsmTagException, AwsServiceException, SdkClientException, CloudHsmV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeBackupsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "CloudHsmInternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmInternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(CloudHsmInternalFailureException::builder).build());
                }
                case "CloudHsmTagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmTagException::builder).build());
                }
                case "CloudHsmServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmServiceException::builder).build());
                }
                case "CloudHsmAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmAccessDeniedException::builder).build());
                }
                case "CloudHsmResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmResourceNotFoundException::builder).build());
                }
                case "CloudHsmInvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmInvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmInvalidRequestException::builder).build());
                }
                case "CloudHsmResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmResourceLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeBackupsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudHsmV2Client.resolveMetricPublishers(clientConfiguration, describeBackupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudHSM V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeBackups");
            DescribeBackupsResponse describeBackupsResponse = (DescribeBackupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeBackups").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeBackupsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeBackupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeBackupsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudHsmV2Client.lambda$describeBackups$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeClustersResponse describeClusters(DescribeClustersRequest describeClustersRequest) throws CloudHsmAccessDeniedException, CloudHsmInternalFailureException, CloudHsmInvalidRequestException, CloudHsmServiceException, CloudHsmTagException, AwsServiceException, SdkClientException, CloudHsmV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeClustersResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "CloudHsmInternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmInternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(CloudHsmInternalFailureException::builder).build());
                }
                case "CloudHsmTagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmTagException::builder).build());
                }
                case "CloudHsmServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmServiceException::builder).build());
                }
                case "CloudHsmAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmAccessDeniedException::builder).build());
                }
                case "CloudHsmResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmResourceNotFoundException::builder).build());
                }
                case "CloudHsmInvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmInvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmInvalidRequestException::builder).build());
                }
                case "CloudHsmResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmResourceLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeClustersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudHsmV2Client.resolveMetricPublishers(clientConfiguration, describeClustersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudHSM V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeClusters");
            DescribeClustersResponse describeClustersResponse = (DescribeClustersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeClusters").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeClustersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeClustersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeClustersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudHsmV2Client.lambda$describeClusters$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetResourcePolicyResponse getResourcePolicy(GetResourcePolicyRequest getResourcePolicyRequest) throws CloudHsmInternalFailureException, CloudHsmServiceException, CloudHsmInvalidRequestException, CloudHsmResourceNotFoundException, CloudHsmAccessDeniedException, AwsServiceException, SdkClientException, CloudHsmV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetResourcePolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "CloudHsmInternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmInternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(CloudHsmInternalFailureException::builder).build());
                }
                case "CloudHsmTagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmTagException::builder).build());
                }
                case "CloudHsmServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmServiceException::builder).build());
                }
                case "CloudHsmAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmAccessDeniedException::builder).build());
                }
                case "CloudHsmResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmResourceNotFoundException::builder).build());
                }
                case "CloudHsmInvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmInvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmInvalidRequestException::builder).build());
                }
                case "CloudHsmResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmResourceLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getResourcePolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudHsmV2Client.resolveMetricPublishers(clientConfiguration, getResourcePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudHSM V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetResourcePolicy");
            GetResourcePolicyResponse getResourcePolicyResponse = (GetResourcePolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetResourcePolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getResourcePolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetResourcePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getResourcePolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudHsmV2Client.lambda$getResourcePolicy$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InitializeClusterResponse initializeCluster(InitializeClusterRequest initializeClusterRequest) throws CloudHsmAccessDeniedException, CloudHsmInternalFailureException, CloudHsmInvalidRequestException, CloudHsmResourceNotFoundException, CloudHsmServiceException, AwsServiceException, SdkClientException, CloudHsmV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, InitializeClusterResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "CloudHsmInternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmInternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(CloudHsmInternalFailureException::builder).build());
                }
                case "CloudHsmTagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmTagException::builder).build());
                }
                case "CloudHsmServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmServiceException::builder).build());
                }
                case "CloudHsmAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmAccessDeniedException::builder).build());
                }
                case "CloudHsmResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmResourceNotFoundException::builder).build());
                }
                case "CloudHsmInvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmInvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmInvalidRequestException::builder).build());
                }
                case "CloudHsmResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmResourceLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)initializeClusterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudHsmV2Client.resolveMetricPublishers(clientConfiguration, initializeClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudHSM V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"InitializeCluster");
            InitializeClusterResponse initializeClusterResponse = (InitializeClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("InitializeCluster").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)initializeClusterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new InitializeClusterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return initializeClusterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudHsmV2Client.lambda$initializeCluster$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsResponse listTags(ListTagsRequest listTagsRequest) throws CloudHsmAccessDeniedException, CloudHsmInternalFailureException, CloudHsmInvalidRequestException, CloudHsmResourceNotFoundException, CloudHsmServiceException, CloudHsmTagException, AwsServiceException, SdkClientException, CloudHsmV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "CloudHsmInternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmInternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(CloudHsmInternalFailureException::builder).build());
                }
                case "CloudHsmTagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmTagException::builder).build());
                }
                case "CloudHsmServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmServiceException::builder).build());
                }
                case "CloudHsmAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmAccessDeniedException::builder).build());
                }
                case "CloudHsmResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmResourceNotFoundException::builder).build());
                }
                case "CloudHsmInvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmInvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmInvalidRequestException::builder).build());
                }
                case "CloudHsmResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmResourceLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudHsmV2Client.resolveMetricPublishers(clientConfiguration, listTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudHSM V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTags");
            ListTagsResponse listTagsResponse = (ListTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTags").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTagsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudHsmV2Client.lambda$listTags$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModifyBackupAttributesResponse modifyBackupAttributes(ModifyBackupAttributesRequest modifyBackupAttributesRequest) throws CloudHsmAccessDeniedException, CloudHsmInternalFailureException, CloudHsmInvalidRequestException, CloudHsmResourceNotFoundException, CloudHsmServiceException, AwsServiceException, SdkClientException, CloudHsmV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ModifyBackupAttributesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "CloudHsmInternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmInternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(CloudHsmInternalFailureException::builder).build());
                }
                case "CloudHsmTagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmTagException::builder).build());
                }
                case "CloudHsmServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmServiceException::builder).build());
                }
                case "CloudHsmAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmAccessDeniedException::builder).build());
                }
                case "CloudHsmResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmResourceNotFoundException::builder).build());
                }
                case "CloudHsmInvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmInvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmInvalidRequestException::builder).build());
                }
                case "CloudHsmResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmResourceLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)modifyBackupAttributesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudHsmV2Client.resolveMetricPublishers(clientConfiguration, modifyBackupAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudHSM V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyBackupAttributes");
            ModifyBackupAttributesResponse modifyBackupAttributesResponse = (ModifyBackupAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyBackupAttributes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)modifyBackupAttributesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ModifyBackupAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return modifyBackupAttributesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudHsmV2Client.lambda$modifyBackupAttributes$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModifyClusterResponse modifyCluster(ModifyClusterRequest modifyClusterRequest) throws CloudHsmAccessDeniedException, CloudHsmInternalFailureException, CloudHsmInvalidRequestException, CloudHsmResourceNotFoundException, CloudHsmServiceException, AwsServiceException, SdkClientException, CloudHsmV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ModifyClusterResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "CloudHsmInternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmInternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(CloudHsmInternalFailureException::builder).build());
                }
                case "CloudHsmTagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmTagException::builder).build());
                }
                case "CloudHsmServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmServiceException::builder).build());
                }
                case "CloudHsmAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmAccessDeniedException::builder).build());
                }
                case "CloudHsmResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmResourceNotFoundException::builder).build());
                }
                case "CloudHsmInvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmInvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmInvalidRequestException::builder).build());
                }
                case "CloudHsmResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmResourceLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)modifyClusterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudHsmV2Client.resolveMetricPublishers(clientConfiguration, modifyClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudHSM V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyCluster");
            ModifyClusterResponse modifyClusterResponse = (ModifyClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyCluster").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)modifyClusterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ModifyClusterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return modifyClusterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudHsmV2Client.lambda$modifyCluster$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutResourcePolicyResponse putResourcePolicy(PutResourcePolicyRequest putResourcePolicyRequest) throws CloudHsmInternalFailureException, CloudHsmServiceException, CloudHsmInvalidRequestException, CloudHsmResourceNotFoundException, CloudHsmAccessDeniedException, AwsServiceException, SdkClientException, CloudHsmV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutResourcePolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "CloudHsmInternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmInternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(CloudHsmInternalFailureException::builder).build());
                }
                case "CloudHsmTagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmTagException::builder).build());
                }
                case "CloudHsmServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmServiceException::builder).build());
                }
                case "CloudHsmAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmAccessDeniedException::builder).build());
                }
                case "CloudHsmResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmResourceNotFoundException::builder).build());
                }
                case "CloudHsmInvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmInvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmInvalidRequestException::builder).build());
                }
                case "CloudHsmResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmResourceLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putResourcePolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudHsmV2Client.resolveMetricPublishers(clientConfiguration, putResourcePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudHSM V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutResourcePolicy");
            PutResourcePolicyResponse putResourcePolicyResponse = (PutResourcePolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutResourcePolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putResourcePolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutResourcePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putResourcePolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudHsmV2Client.lambda$putResourcePolicy$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RestoreBackupResponse restoreBackup(RestoreBackupRequest restoreBackupRequest) throws CloudHsmAccessDeniedException, CloudHsmInternalFailureException, CloudHsmInvalidRequestException, CloudHsmResourceNotFoundException, CloudHsmServiceException, AwsServiceException, SdkClientException, CloudHsmV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RestoreBackupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "CloudHsmInternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmInternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(CloudHsmInternalFailureException::builder).build());
                }
                case "CloudHsmTagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmTagException::builder).build());
                }
                case "CloudHsmServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmServiceException::builder).build());
                }
                case "CloudHsmAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmAccessDeniedException::builder).build());
                }
                case "CloudHsmResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmResourceNotFoundException::builder).build());
                }
                case "CloudHsmInvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmInvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmInvalidRequestException::builder).build());
                }
                case "CloudHsmResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmResourceLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)restoreBackupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudHsmV2Client.resolveMetricPublishers(clientConfiguration, restoreBackupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudHSM V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RestoreBackup");
            RestoreBackupResponse restoreBackupResponse = (RestoreBackupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RestoreBackup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)restoreBackupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RestoreBackupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return restoreBackupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudHsmV2Client.lambda$restoreBackup$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws CloudHsmAccessDeniedException, CloudHsmInternalFailureException, CloudHsmInvalidRequestException, CloudHsmResourceLimitExceededException, CloudHsmResourceNotFoundException, CloudHsmServiceException, CloudHsmTagException, AwsServiceException, SdkClientException, CloudHsmV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "CloudHsmInternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmInternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(CloudHsmInternalFailureException::builder).build());
                }
                case "CloudHsmTagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmTagException::builder).build());
                }
                case "CloudHsmServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmServiceException::builder).build());
                }
                case "CloudHsmAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmAccessDeniedException::builder).build());
                }
                case "CloudHsmResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmResourceNotFoundException::builder).build());
                }
                case "CloudHsmInvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmInvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmInvalidRequestException::builder).build());
                }
                case "CloudHsmResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmResourceLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudHsmV2Client.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudHSM V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudHsmV2Client.lambda$tagResource$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws CloudHsmAccessDeniedException, CloudHsmInternalFailureException, CloudHsmInvalidRequestException, CloudHsmResourceNotFoundException, CloudHsmServiceException, CloudHsmTagException, AwsServiceException, SdkClientException, CloudHsmV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "CloudHsmInternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmInternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(CloudHsmInternalFailureException::builder).build());
                }
                case "CloudHsmTagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmTagException::builder).build());
                }
                case "CloudHsmServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmServiceException::builder).build());
                }
                case "CloudHsmAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmAccessDeniedException::builder).build());
                }
                case "CloudHsmResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmResourceNotFoundException::builder).build());
                }
                case "CloudHsmInvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmInvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmInvalidRequestException::builder).build());
                }
                case "CloudHsmResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmResourceLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudHsmV2Client.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudHSM V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudHsmV2Client.lambda$untagResource$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "cloudhsm";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        CloudHsmV2ServiceClientConfigurationBuilder serviceConfigBuilder = new CloudHsmV2ServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(CloudHsmV2Exception::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1");
    }

    @Override
    public final CloudHsmV2ServiceClientConfiguration serviceClientConfiguration() {
        return new CloudHsmV2ServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$untagResource$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$restoreBackup$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putResourcePolicy$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$modifyCluster$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$modifyBackupAttributes$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTags$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$initializeCluster$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getResourcePolicy$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeClusters$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeBackups$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteResourcePolicy$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteHsm$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteCluster$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteBackup$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createHsm$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createCluster$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$copyBackupToRegion$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

