/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudhsmv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a hardware security module (HSM) in an CloudHSM cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Hsm implements SdkPojo, Serializable, ToCopyableBuilder<Hsm.Builder, Hsm> {
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone").getter(getter(Hsm::availabilityZone)).setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()).build();

    private static final SdkField<String> CLUSTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterId").getter(getter(Hsm::clusterId)).setter(setter(Builder::clusterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterId").build()).build();

    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubnetId").getter(getter(Hsm::subnetId)).setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").build()).build();

    private static final SdkField<String> ENI_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("EniId")
            .getter(getter(Hsm::eniId)).setter(setter(Builder::eniId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EniId").build()).build();

    private static final SdkField<String> ENI_IP_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("EniIp")
            .getter(getter(Hsm::eniIp)).setter(setter(Builder::eniIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EniIp").build()).build();

    private static final SdkField<String> ENI_IP_V6_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EniIpV6").getter(getter(Hsm::eniIpV6)).setter(setter(Builder::eniIpV6))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EniIpV6").build()).build();

    private static final SdkField<String> HSM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("HsmId")
            .getter(getter(Hsm::hsmId)).setter(setter(Builder::hsmId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HsmId").build()).build();

    private static final SdkField<String> HSM_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HsmType").getter(getter(Hsm::hsmType)).setter(setter(Builder::hsmType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HsmType").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(Hsm::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> STATE_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StateMessage").getter(getter(Hsm::stateMessage)).setter(setter(Builder::stateMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONE_FIELD,
            CLUSTER_ID_FIELD, SUBNET_ID_FIELD, ENI_ID_FIELD, ENI_IP_FIELD, ENI_IP_V6_FIELD, HSM_ID_FIELD, HSM_TYPE_FIELD,
            STATE_FIELD, STATE_MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String availabilityZone;

    private final String clusterId;

    private final String subnetId;

    private final String eniId;

    private final String eniIp;

    private final String eniIpV6;

    private final String hsmId;

    private final String hsmType;

    private final String state;

    private final String stateMessage;

    private Hsm(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.clusterId = builder.clusterId;
        this.subnetId = builder.subnetId;
        this.eniId = builder.eniId;
        this.eniIp = builder.eniIp;
        this.eniIpV6 = builder.eniIpV6;
        this.hsmId = builder.hsmId;
        this.hsmType = builder.hsmType;
        this.state = builder.state;
        this.stateMessage = builder.stateMessage;
    }

    /**
     * <p>
     * The Availability Zone that contains the HSM.
     * </p>
     * 
     * @return The Availability Zone that contains the HSM.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The identifier (ID) of the cluster that contains the HSM.
     * </p>
     * 
     * @return The identifier (ID) of the cluster that contains the HSM.
     */
    public final String clusterId() {
        return clusterId;
    }

    /**
     * <p>
     * The subnet that contains the HSM's elastic network interface (ENI).
     * </p>
     * 
     * @return The subnet that contains the HSM's elastic network interface (ENI).
     */
    public final String subnetId() {
        return subnetId;
    }

    /**
     * <p>
     * The identifier (ID) of the HSM's elastic network interface (ENI).
     * </p>
     * 
     * @return The identifier (ID) of the HSM's elastic network interface (ENI).
     */
    public final String eniId() {
        return eniId;
    }

    /**
     * <p>
     * The IP address of the HSM's elastic network interface (ENI).
     * </p>
     * 
     * @return The IP address of the HSM's elastic network interface (ENI).
     */
    public final String eniIp() {
        return eniIp;
    }

    /**
     * <p>
     * The IPv6 address (if any) of the HSM's elastic network interface (ENI).
     * </p>
     * 
     * @return The IPv6 address (if any) of the HSM's elastic network interface (ENI).
     */
    public final String eniIpV6() {
        return eniIpV6;
    }

    /**
     * <p>
     * The HSM's identifier (ID).
     * </p>
     * 
     * @return The HSM's identifier (ID).
     */
    public final String hsmId() {
        return hsmId;
    }

    /**
     * <p>
     * The type of HSM.
     * </p>
     * 
     * @return The type of HSM.
     */
    public final String hsmType() {
        return hsmType;
    }

    /**
     * <p>
     * The HSM's state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link HsmState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The HSM's state.
     * @see HsmState
     */
    public final HsmState state() {
        return HsmState.fromValue(state);
    }

    /**
     * <p>
     * The HSM's state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link HsmState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The HSM's state.
     * @see HsmState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * A description of the HSM's state.
     * </p>
     * 
     * @return A description of the HSM's state.
     */
    public final String stateMessage() {
        return stateMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(eniId());
        hashCode = 31 * hashCode + Objects.hashCode(eniIp());
        hashCode = 31 * hashCode + Objects.hashCode(eniIpV6());
        hashCode = 31 * hashCode + Objects.hashCode(hsmId());
        hashCode = 31 * hashCode + Objects.hashCode(hsmType());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Hsm)) {
            return false;
        }
        Hsm other = (Hsm) obj;
        return Objects.equals(availabilityZone(), other.availabilityZone()) && Objects.equals(clusterId(), other.clusterId())
                && Objects.equals(subnetId(), other.subnetId()) && Objects.equals(eniId(), other.eniId())
                && Objects.equals(eniIp(), other.eniIp()) && Objects.equals(eniIpV6(), other.eniIpV6())
                && Objects.equals(hsmId(), other.hsmId()) && Objects.equals(hsmType(), other.hsmType())
                && Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(stateMessage(), other.stateMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Hsm").add("AvailabilityZone", availabilityZone()).add("ClusterId", clusterId())
                .add("SubnetId", subnetId()).add("EniId", eniId()).add("EniIp", eniIp()).add("EniIpV6", eniIpV6())
                .add("HsmId", hsmId()).add("HsmType", hsmType()).add("State", stateAsString())
                .add("StateMessage", stateMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "ClusterId":
            return Optional.ofNullable(clazz.cast(clusterId()));
        case "SubnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        case "EniId":
            return Optional.ofNullable(clazz.cast(eniId()));
        case "EniIp":
            return Optional.ofNullable(clazz.cast(eniIp()));
        case "EniIpV6":
            return Optional.ofNullable(clazz.cast(eniIpV6()));
        case "HsmId":
            return Optional.ofNullable(clazz.cast(hsmId()));
        case "HsmType":
            return Optional.ofNullable(clazz.cast(hsmType()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "StateMessage":
            return Optional.ofNullable(clazz.cast(stateMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("ClusterId", CLUSTER_ID_FIELD);
        map.put("SubnetId", SUBNET_ID_FIELD);
        map.put("EniId", ENI_ID_FIELD);
        map.put("EniIp", ENI_IP_FIELD);
        map.put("EniIpV6", ENI_IP_V6_FIELD);
        map.put("HsmId", HSM_ID_FIELD);
        map.put("HsmType", HSM_TYPE_FIELD);
        map.put("State", STATE_FIELD);
        map.put("StateMessage", STATE_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Hsm, T> g) {
        return obj -> g.apply((Hsm) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Hsm> {
        /**
         * <p>
         * The Availability Zone that contains the HSM.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone that contains the HSM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The identifier (ID) of the cluster that contains the HSM.
         * </p>
         * 
         * @param clusterId
         *        The identifier (ID) of the cluster that contains the HSM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterId(String clusterId);

        /**
         * <p>
         * The subnet that contains the HSM's elastic network interface (ENI).
         * </p>
         * 
         * @param subnetId
         *        The subnet that contains the HSM's elastic network interface (ENI).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * The identifier (ID) of the HSM's elastic network interface (ENI).
         * </p>
         * 
         * @param eniId
         *        The identifier (ID) of the HSM's elastic network interface (ENI).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eniId(String eniId);

        /**
         * <p>
         * The IP address of the HSM's elastic network interface (ENI).
         * </p>
         * 
         * @param eniIp
         *        The IP address of the HSM's elastic network interface (ENI).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eniIp(String eniIp);

        /**
         * <p>
         * The IPv6 address (if any) of the HSM's elastic network interface (ENI).
         * </p>
         * 
         * @param eniIpV6
         *        The IPv6 address (if any) of the HSM's elastic network interface (ENI).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eniIpV6(String eniIpV6);

        /**
         * <p>
         * The HSM's identifier (ID).
         * </p>
         * 
         * @param hsmId
         *        The HSM's identifier (ID).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hsmId(String hsmId);

        /**
         * <p>
         * The type of HSM.
         * </p>
         * 
         * @param hsmType
         *        The type of HSM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hsmType(String hsmType);

        /**
         * <p>
         * The HSM's state.
         * </p>
         * 
         * @param state
         *        The HSM's state.
         * @see HsmState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HsmState
         */
        Builder state(String state);

        /**
         * <p>
         * The HSM's state.
         * </p>
         * 
         * @param state
         *        The HSM's state.
         * @see HsmState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HsmState
         */
        Builder state(HsmState state);

        /**
         * <p>
         * A description of the HSM's state.
         * </p>
         * 
         * @param stateMessage
         *        A description of the HSM's state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateMessage(String stateMessage);
    }

    static final class BuilderImpl implements Builder {
        private String availabilityZone;

        private String clusterId;

        private String subnetId;

        private String eniId;

        private String eniIp;

        private String eniIpV6;

        private String hsmId;

        private String hsmType;

        private String state;

        private String stateMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(Hsm model) {
            availabilityZone(model.availabilityZone);
            clusterId(model.clusterId);
            subnetId(model.subnetId);
            eniId(model.eniId);
            eniIp(model.eniIp);
            eniIpV6(model.eniIpV6);
            hsmId(model.hsmId);
            hsmType(model.hsmType);
            state(model.state);
            stateMessage(model.stateMessage);
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getClusterId() {
            return clusterId;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final String getEniId() {
            return eniId;
        }

        public final void setEniId(String eniId) {
            this.eniId = eniId;
        }

        @Override
        public final Builder eniId(String eniId) {
            this.eniId = eniId;
            return this;
        }

        public final String getEniIp() {
            return eniIp;
        }

        public final void setEniIp(String eniIp) {
            this.eniIp = eniIp;
        }

        @Override
        public final Builder eniIp(String eniIp) {
            this.eniIp = eniIp;
            return this;
        }

        public final String getEniIpV6() {
            return eniIpV6;
        }

        public final void setEniIpV6(String eniIpV6) {
            this.eniIpV6 = eniIpV6;
        }

        @Override
        public final Builder eniIpV6(String eniIpV6) {
            this.eniIpV6 = eniIpV6;
            return this;
        }

        public final String getHsmId() {
            return hsmId;
        }

        public final void setHsmId(String hsmId) {
            this.hsmId = hsmId;
        }

        @Override
        public final Builder hsmId(String hsmId) {
            this.hsmId = hsmId;
            return this;
        }

        public final String getHsmType() {
            return hsmType;
        }

        public final void setHsmType(String hsmType) {
            this.hsmType = hsmType;
        }

        @Override
        public final Builder hsmType(String hsmType) {
            this.hsmType = hsmType;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(HsmState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getStateMessage() {
            return stateMessage;
        }

        public final void setStateMessage(String stateMessage) {
            this.stateMessage = stateMessage;
        }

        @Override
        public final Builder stateMessage(String stateMessage) {
            this.stateMessage = stateMessage;
            return this;
        }

        @Override
        public Hsm build() {
            return new Hsm(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
