/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsmv2;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.cloudhsmv2.CloudHsmV2AsyncClient;
import software.amazon.awssdk.services.cloudhsmv2.CloudHsmV2ServiceClientConfiguration;
import software.amazon.awssdk.services.cloudhsmv2.internal.CloudHsmV2ServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.cloudhsmv2.model.CloudHsmAccessDeniedException;
import software.amazon.awssdk.services.cloudhsmv2.model.CloudHsmInternalFailureException;
import software.amazon.awssdk.services.cloudhsmv2.model.CloudHsmInvalidRequestException;
import software.amazon.awssdk.services.cloudhsmv2.model.CloudHsmResourceLimitExceededException;
import software.amazon.awssdk.services.cloudhsmv2.model.CloudHsmResourceNotFoundException;
import software.amazon.awssdk.services.cloudhsmv2.model.CloudHsmServiceException;
import software.amazon.awssdk.services.cloudhsmv2.model.CloudHsmTagException;
import software.amazon.awssdk.services.cloudhsmv2.model.CloudHsmV2Exception;
import software.amazon.awssdk.services.cloudhsmv2.model.CopyBackupToRegionRequest;
import software.amazon.awssdk.services.cloudhsmv2.model.CopyBackupToRegionResponse;
import software.amazon.awssdk.services.cloudhsmv2.model.CreateClusterRequest;
import software.amazon.awssdk.services.cloudhsmv2.model.CreateClusterResponse;
import software.amazon.awssdk.services.cloudhsmv2.model.CreateHsmRequest;
import software.amazon.awssdk.services.cloudhsmv2.model.CreateHsmResponse;
import software.amazon.awssdk.services.cloudhsmv2.model.DeleteBackupRequest;
import software.amazon.awssdk.services.cloudhsmv2.model.DeleteBackupResponse;
import software.amazon.awssdk.services.cloudhsmv2.model.DeleteClusterRequest;
import software.amazon.awssdk.services.cloudhsmv2.model.DeleteClusterResponse;
import software.amazon.awssdk.services.cloudhsmv2.model.DeleteHsmRequest;
import software.amazon.awssdk.services.cloudhsmv2.model.DeleteHsmResponse;
import software.amazon.awssdk.services.cloudhsmv2.model.DeleteResourcePolicyRequest;
import software.amazon.awssdk.services.cloudhsmv2.model.DeleteResourcePolicyResponse;
import software.amazon.awssdk.services.cloudhsmv2.model.DescribeBackupsRequest;
import software.amazon.awssdk.services.cloudhsmv2.model.DescribeBackupsResponse;
import software.amazon.awssdk.services.cloudhsmv2.model.DescribeClustersRequest;
import software.amazon.awssdk.services.cloudhsmv2.model.DescribeClustersResponse;
import software.amazon.awssdk.services.cloudhsmv2.model.GetResourcePolicyRequest;
import software.amazon.awssdk.services.cloudhsmv2.model.GetResourcePolicyResponse;
import software.amazon.awssdk.services.cloudhsmv2.model.InitializeClusterRequest;
import software.amazon.awssdk.services.cloudhsmv2.model.InitializeClusterResponse;
import software.amazon.awssdk.services.cloudhsmv2.model.ListTagsRequest;
import software.amazon.awssdk.services.cloudhsmv2.model.ListTagsResponse;
import software.amazon.awssdk.services.cloudhsmv2.model.ModifyBackupAttributesRequest;
import software.amazon.awssdk.services.cloudhsmv2.model.ModifyBackupAttributesResponse;
import software.amazon.awssdk.services.cloudhsmv2.model.ModifyClusterRequest;
import software.amazon.awssdk.services.cloudhsmv2.model.ModifyClusterResponse;
import software.amazon.awssdk.services.cloudhsmv2.model.PutResourcePolicyRequest;
import software.amazon.awssdk.services.cloudhsmv2.model.PutResourcePolicyResponse;
import software.amazon.awssdk.services.cloudhsmv2.model.RestoreBackupRequest;
import software.amazon.awssdk.services.cloudhsmv2.model.RestoreBackupResponse;
import software.amazon.awssdk.services.cloudhsmv2.model.TagResourceRequest;
import software.amazon.awssdk.services.cloudhsmv2.model.TagResourceResponse;
import software.amazon.awssdk.services.cloudhsmv2.model.UntagResourceRequest;
import software.amazon.awssdk.services.cloudhsmv2.model.UntagResourceResponse;
import software.amazon.awssdk.services.cloudhsmv2.transform.CopyBackupToRegionRequestMarshaller;
import software.amazon.awssdk.services.cloudhsmv2.transform.CreateClusterRequestMarshaller;
import software.amazon.awssdk.services.cloudhsmv2.transform.CreateHsmRequestMarshaller;
import software.amazon.awssdk.services.cloudhsmv2.transform.DeleteBackupRequestMarshaller;
import software.amazon.awssdk.services.cloudhsmv2.transform.DeleteClusterRequestMarshaller;
import software.amazon.awssdk.services.cloudhsmv2.transform.DeleteHsmRequestMarshaller;
import software.amazon.awssdk.services.cloudhsmv2.transform.DeleteResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudhsmv2.transform.DescribeBackupsRequestMarshaller;
import software.amazon.awssdk.services.cloudhsmv2.transform.DescribeClustersRequestMarshaller;
import software.amazon.awssdk.services.cloudhsmv2.transform.GetResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudhsmv2.transform.InitializeClusterRequestMarshaller;
import software.amazon.awssdk.services.cloudhsmv2.transform.ListTagsRequestMarshaller;
import software.amazon.awssdk.services.cloudhsmv2.transform.ModifyBackupAttributesRequestMarshaller;
import software.amazon.awssdk.services.cloudhsmv2.transform.ModifyClusterRequestMarshaller;
import software.amazon.awssdk.services.cloudhsmv2.transform.PutResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudhsmv2.transform.RestoreBackupRequestMarshaller;
import software.amazon.awssdk.services.cloudhsmv2.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.cloudhsmv2.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultCloudHsmV2AsyncClient
implements CloudHsmV2AsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultCloudHsmV2AsyncClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultCloudHsmV2AsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"CloudHSM_V2#2.33.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public CompletableFuture<CopyBackupToRegionResponse> copyBackupToRegion(CopyBackupToRegionRequest copyBackupToRegionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)copyBackupToRegionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudHsmV2AsyncClient.resolveMetricPublishers(clientConfiguration, copyBackupToRegionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudHSM V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CopyBackupToRegion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CopyBackupToRegionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "CloudHsmInternalFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmInternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(CloudHsmInternalFailureException::builder).build());
                    }
                    case "CloudHsmTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmTagException::builder).build());
                    }
                    case "CloudHsmServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmServiceException::builder).build());
                    }
                    case "CloudHsmAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmAccessDeniedException::builder).build());
                    }
                    case "CloudHsmResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmResourceNotFoundException::builder).build());
                    }
                    case "CloudHsmInvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmInvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmInvalidRequestException::builder).build());
                    }
                    case "CloudHsmResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CopyBackupToRegion").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CopyBackupToRegionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)copyBackupToRegionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudHsmV2AsyncClient.lambda$copyBackupToRegion$2(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudHsmV2AsyncClient.lambda$copyBackupToRegion$3((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateClusterResponse> createCluster(CreateClusterRequest createClusterRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createClusterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudHsmV2AsyncClient.resolveMetricPublishers(clientConfiguration, createClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudHSM V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateCluster");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateClusterResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "CloudHsmInternalFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmInternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(CloudHsmInternalFailureException::builder).build());
                    }
                    case "CloudHsmTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmTagException::builder).build());
                    }
                    case "CloudHsmServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmServiceException::builder).build());
                    }
                    case "CloudHsmAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmAccessDeniedException::builder).build());
                    }
                    case "CloudHsmResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmResourceNotFoundException::builder).build());
                    }
                    case "CloudHsmInvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmInvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmInvalidRequestException::builder).build());
                    }
                    case "CloudHsmResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCluster").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateClusterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createClusterRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudHsmV2AsyncClient.lambda$createCluster$6(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudHsmV2AsyncClient.lambda$createCluster$7((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateHsmResponse> createHsm(CreateHsmRequest createHsmRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createHsmRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudHsmV2AsyncClient.resolveMetricPublishers(clientConfiguration, createHsmRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudHSM V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateHsm");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateHsmResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "CloudHsmInternalFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmInternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(CloudHsmInternalFailureException::builder).build());
                    }
                    case "CloudHsmTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmTagException::builder).build());
                    }
                    case "CloudHsmServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmServiceException::builder).build());
                    }
                    case "CloudHsmAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmAccessDeniedException::builder).build());
                    }
                    case "CloudHsmResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmResourceNotFoundException::builder).build());
                    }
                    case "CloudHsmInvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmInvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmInvalidRequestException::builder).build());
                    }
                    case "CloudHsmResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateHsm").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateHsmRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createHsmRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudHsmV2AsyncClient.lambda$createHsm$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudHsmV2AsyncClient.lambda$createHsm$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteBackupResponse> deleteBackup(DeleteBackupRequest deleteBackupRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteBackupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudHsmV2AsyncClient.resolveMetricPublishers(clientConfiguration, deleteBackupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudHSM V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteBackup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteBackupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "CloudHsmInternalFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmInternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(CloudHsmInternalFailureException::builder).build());
                    }
                    case "CloudHsmTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmTagException::builder).build());
                    }
                    case "CloudHsmServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmServiceException::builder).build());
                    }
                    case "CloudHsmAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmAccessDeniedException::builder).build());
                    }
                    case "CloudHsmResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmResourceNotFoundException::builder).build());
                    }
                    case "CloudHsmInvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmInvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmInvalidRequestException::builder).build());
                    }
                    case "CloudHsmResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBackup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteBackupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteBackupRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudHsmV2AsyncClient.lambda$deleteBackup$14(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudHsmV2AsyncClient.lambda$deleteBackup$15((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteClusterResponse> deleteCluster(DeleteClusterRequest deleteClusterRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteClusterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudHsmV2AsyncClient.resolveMetricPublishers(clientConfiguration, deleteClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudHSM V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteCluster");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteClusterResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "CloudHsmInternalFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmInternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(CloudHsmInternalFailureException::builder).build());
                    }
                    case "CloudHsmTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmTagException::builder).build());
                    }
                    case "CloudHsmServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmServiceException::builder).build());
                    }
                    case "CloudHsmAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmAccessDeniedException::builder).build());
                    }
                    case "CloudHsmResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmResourceNotFoundException::builder).build());
                    }
                    case "CloudHsmInvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmInvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmInvalidRequestException::builder).build());
                    }
                    case "CloudHsmResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCluster").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteClusterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteClusterRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudHsmV2AsyncClient.lambda$deleteCluster$18(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudHsmV2AsyncClient.lambda$deleteCluster$19((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteHsmResponse> deleteHsm(DeleteHsmRequest deleteHsmRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteHsmRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudHsmV2AsyncClient.resolveMetricPublishers(clientConfiguration, deleteHsmRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudHSM V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteHsm");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteHsmResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "CloudHsmInternalFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmInternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(CloudHsmInternalFailureException::builder).build());
                    }
                    case "CloudHsmTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmTagException::builder).build());
                    }
                    case "CloudHsmServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmServiceException::builder).build());
                    }
                    case "CloudHsmAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmAccessDeniedException::builder).build());
                    }
                    case "CloudHsmResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmResourceNotFoundException::builder).build());
                    }
                    case "CloudHsmInvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmInvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmInvalidRequestException::builder).build());
                    }
                    case "CloudHsmResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteHsm").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteHsmRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteHsmRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudHsmV2AsyncClient.lambda$deleteHsm$22(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudHsmV2AsyncClient.lambda$deleteHsm$23((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteResourcePolicyResponse> deleteResourcePolicy(DeleteResourcePolicyRequest deleteResourcePolicyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteResourcePolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudHsmV2AsyncClient.resolveMetricPublishers(clientConfiguration, deleteResourcePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudHSM V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteResourcePolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteResourcePolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "CloudHsmInternalFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmInternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(CloudHsmInternalFailureException::builder).build());
                    }
                    case "CloudHsmTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmTagException::builder).build());
                    }
                    case "CloudHsmServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmServiceException::builder).build());
                    }
                    case "CloudHsmAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmAccessDeniedException::builder).build());
                    }
                    case "CloudHsmResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmResourceNotFoundException::builder).build());
                    }
                    case "CloudHsmInvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmInvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmInvalidRequestException::builder).build());
                    }
                    case "CloudHsmResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteResourcePolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteResourcePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteResourcePolicyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudHsmV2AsyncClient.lambda$deleteResourcePolicy$26(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudHsmV2AsyncClient.lambda$deleteResourcePolicy$27((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeBackupsResponse> describeBackups(DescribeBackupsRequest describeBackupsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeBackupsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudHsmV2AsyncClient.resolveMetricPublishers(clientConfiguration, describeBackupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudHSM V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeBackups");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeBackupsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "CloudHsmInternalFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmInternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(CloudHsmInternalFailureException::builder).build());
                    }
                    case "CloudHsmTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmTagException::builder).build());
                    }
                    case "CloudHsmServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmServiceException::builder).build());
                    }
                    case "CloudHsmAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmAccessDeniedException::builder).build());
                    }
                    case "CloudHsmResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmResourceNotFoundException::builder).build());
                    }
                    case "CloudHsmInvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmInvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmInvalidRequestException::builder).build());
                    }
                    case "CloudHsmResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeBackups").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeBackupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeBackupsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudHsmV2AsyncClient.lambda$describeBackups$30(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudHsmV2AsyncClient.lambda$describeBackups$31((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeClustersResponse> describeClusters(DescribeClustersRequest describeClustersRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeClustersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudHsmV2AsyncClient.resolveMetricPublishers(clientConfiguration, describeClustersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudHSM V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeClusters");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeClustersResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "CloudHsmInternalFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmInternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(CloudHsmInternalFailureException::builder).build());
                    }
                    case "CloudHsmTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmTagException::builder).build());
                    }
                    case "CloudHsmServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmServiceException::builder).build());
                    }
                    case "CloudHsmAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmAccessDeniedException::builder).build());
                    }
                    case "CloudHsmResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmResourceNotFoundException::builder).build());
                    }
                    case "CloudHsmInvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmInvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmInvalidRequestException::builder).build());
                    }
                    case "CloudHsmResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeClusters").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeClustersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeClustersRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudHsmV2AsyncClient.lambda$describeClusters$34(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudHsmV2AsyncClient.lambda$describeClusters$35((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetResourcePolicyResponse> getResourcePolicy(GetResourcePolicyRequest getResourcePolicyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getResourcePolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudHsmV2AsyncClient.resolveMetricPublishers(clientConfiguration, getResourcePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudHSM V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetResourcePolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetResourcePolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "CloudHsmInternalFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmInternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(CloudHsmInternalFailureException::builder).build());
                    }
                    case "CloudHsmTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmTagException::builder).build());
                    }
                    case "CloudHsmServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmServiceException::builder).build());
                    }
                    case "CloudHsmAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmAccessDeniedException::builder).build());
                    }
                    case "CloudHsmResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmResourceNotFoundException::builder).build());
                    }
                    case "CloudHsmInvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmInvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmInvalidRequestException::builder).build());
                    }
                    case "CloudHsmResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetResourcePolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetResourcePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getResourcePolicyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudHsmV2AsyncClient.lambda$getResourcePolicy$38(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudHsmV2AsyncClient.lambda$getResourcePolicy$39((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<InitializeClusterResponse> initializeCluster(InitializeClusterRequest initializeClusterRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)initializeClusterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudHsmV2AsyncClient.resolveMetricPublishers(clientConfiguration, initializeClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudHSM V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"InitializeCluster");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, InitializeClusterResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "CloudHsmInternalFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmInternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(CloudHsmInternalFailureException::builder).build());
                    }
                    case "CloudHsmTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmTagException::builder).build());
                    }
                    case "CloudHsmServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmServiceException::builder).build());
                    }
                    case "CloudHsmAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmAccessDeniedException::builder).build());
                    }
                    case "CloudHsmResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmResourceNotFoundException::builder).build());
                    }
                    case "CloudHsmInvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmInvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmInvalidRequestException::builder).build());
                    }
                    case "CloudHsmResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("InitializeCluster").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new InitializeClusterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)initializeClusterRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudHsmV2AsyncClient.lambda$initializeCluster$42(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudHsmV2AsyncClient.lambda$initializeCluster$43((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTagsResponse> listTags(ListTagsRequest listTagsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudHsmV2AsyncClient.resolveMetricPublishers(clientConfiguration, listTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudHSM V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTags");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "CloudHsmInternalFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmInternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(CloudHsmInternalFailureException::builder).build());
                    }
                    case "CloudHsmTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmTagException::builder).build());
                    }
                    case "CloudHsmServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmServiceException::builder).build());
                    }
                    case "CloudHsmAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmAccessDeniedException::builder).build());
                    }
                    case "CloudHsmResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmResourceNotFoundException::builder).build());
                    }
                    case "CloudHsmInvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmInvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmInvalidRequestException::builder).build());
                    }
                    case "CloudHsmResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTags").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listTagsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudHsmV2AsyncClient.lambda$listTags$46(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudHsmV2AsyncClient.lambda$listTags$47((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ModifyBackupAttributesResponse> modifyBackupAttributes(ModifyBackupAttributesRequest modifyBackupAttributesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)modifyBackupAttributesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudHsmV2AsyncClient.resolveMetricPublishers(clientConfiguration, modifyBackupAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudHSM V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyBackupAttributes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ModifyBackupAttributesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "CloudHsmInternalFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmInternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(CloudHsmInternalFailureException::builder).build());
                    }
                    case "CloudHsmTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmTagException::builder).build());
                    }
                    case "CloudHsmServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmServiceException::builder).build());
                    }
                    case "CloudHsmAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmAccessDeniedException::builder).build());
                    }
                    case "CloudHsmResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmResourceNotFoundException::builder).build());
                    }
                    case "CloudHsmInvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmInvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmInvalidRequestException::builder).build());
                    }
                    case "CloudHsmResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyBackupAttributes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ModifyBackupAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)modifyBackupAttributesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudHsmV2AsyncClient.lambda$modifyBackupAttributes$50(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudHsmV2AsyncClient.lambda$modifyBackupAttributes$51((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ModifyClusterResponse> modifyCluster(ModifyClusterRequest modifyClusterRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)modifyClusterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudHsmV2AsyncClient.resolveMetricPublishers(clientConfiguration, modifyClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudHSM V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyCluster");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ModifyClusterResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "CloudHsmInternalFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmInternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(CloudHsmInternalFailureException::builder).build());
                    }
                    case "CloudHsmTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmTagException::builder).build());
                    }
                    case "CloudHsmServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmServiceException::builder).build());
                    }
                    case "CloudHsmAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmAccessDeniedException::builder).build());
                    }
                    case "CloudHsmResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmResourceNotFoundException::builder).build());
                    }
                    case "CloudHsmInvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmInvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmInvalidRequestException::builder).build());
                    }
                    case "CloudHsmResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyCluster").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ModifyClusterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)modifyClusterRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudHsmV2AsyncClient.lambda$modifyCluster$54(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudHsmV2AsyncClient.lambda$modifyCluster$55((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutResourcePolicyResponse> putResourcePolicy(PutResourcePolicyRequest putResourcePolicyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putResourcePolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudHsmV2AsyncClient.resolveMetricPublishers(clientConfiguration, putResourcePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudHSM V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutResourcePolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutResourcePolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "CloudHsmInternalFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmInternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(CloudHsmInternalFailureException::builder).build());
                    }
                    case "CloudHsmTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmTagException::builder).build());
                    }
                    case "CloudHsmServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmServiceException::builder).build());
                    }
                    case "CloudHsmAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmAccessDeniedException::builder).build());
                    }
                    case "CloudHsmResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmResourceNotFoundException::builder).build());
                    }
                    case "CloudHsmInvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmInvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmInvalidRequestException::builder).build());
                    }
                    case "CloudHsmResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutResourcePolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PutResourcePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putResourcePolicyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudHsmV2AsyncClient.lambda$putResourcePolicy$58(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudHsmV2AsyncClient.lambda$putResourcePolicy$59((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RestoreBackupResponse> restoreBackup(RestoreBackupRequest restoreBackupRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)restoreBackupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudHsmV2AsyncClient.resolveMetricPublishers(clientConfiguration, restoreBackupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudHSM V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RestoreBackup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RestoreBackupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "CloudHsmInternalFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmInternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(CloudHsmInternalFailureException::builder).build());
                    }
                    case "CloudHsmTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmTagException::builder).build());
                    }
                    case "CloudHsmServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmServiceException::builder).build());
                    }
                    case "CloudHsmAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmAccessDeniedException::builder).build());
                    }
                    case "CloudHsmResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmResourceNotFoundException::builder).build());
                    }
                    case "CloudHsmInvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmInvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmInvalidRequestException::builder).build());
                    }
                    case "CloudHsmResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RestoreBackup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RestoreBackupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)restoreBackupRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudHsmV2AsyncClient.lambda$restoreBackup$62(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudHsmV2AsyncClient.lambda$restoreBackup$63((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudHsmV2AsyncClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudHSM V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "CloudHsmInternalFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmInternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(CloudHsmInternalFailureException::builder).build());
                    }
                    case "CloudHsmTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmTagException::builder).build());
                    }
                    case "CloudHsmServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmServiceException::builder).build());
                    }
                    case "CloudHsmAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmAccessDeniedException::builder).build());
                    }
                    case "CloudHsmResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmResourceNotFoundException::builder).build());
                    }
                    case "CloudHsmInvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmInvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmInvalidRequestException::builder).build());
                    }
                    case "CloudHsmResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)tagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudHsmV2AsyncClient.lambda$tagResource$66(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudHsmV2AsyncClient.lambda$tagResource$67((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudHsmV2AsyncClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudHSM V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "CloudHsmInternalFailureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmInternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(CloudHsmInternalFailureException::builder).build());
                    }
                    case "CloudHsmTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmTagException::builder).build());
                    }
                    case "CloudHsmServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmServiceException::builder).build());
                    }
                    case "CloudHsmAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmAccessDeniedException::builder).build());
                    }
                    case "CloudHsmResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmResourceNotFoundException::builder).build());
                    }
                    case "CloudHsmInvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmInvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmInvalidRequestException::builder).build());
                    }
                    case "CloudHsmResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)untagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudHsmV2AsyncClient.lambda$untagResource$70(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudHsmV2AsyncClient.lambda$untagResource$71((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public final CloudHsmV2ServiceClientConfiguration serviceClientConfiguration() {
        return new CloudHsmV2ServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public final String serviceName() {
        return "cloudhsm";
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(CloudHsmV2Exception::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1");
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        CloudHsmV2ServiceClientConfigurationBuilder serviceConfigBuilder = new CloudHsmV2ServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$untagResource$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$70(List metricPublishers, MetricCollector apiCallMetricCollector, UntagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$tagResource$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$66(List metricPublishers, MetricCollector apiCallMetricCollector, TagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$restoreBackup$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$restoreBackup$62(List metricPublishers, MetricCollector apiCallMetricCollector, RestoreBackupResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putResourcePolicy$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putResourcePolicy$58(List metricPublishers, MetricCollector apiCallMetricCollector, PutResourcePolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$modifyCluster$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$modifyCluster$54(List metricPublishers, MetricCollector apiCallMetricCollector, ModifyClusterResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$modifyBackupAttributes$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$modifyBackupAttributes$50(List metricPublishers, MetricCollector apiCallMetricCollector, ModifyBackupAttributesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listTags$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTags$46(List metricPublishers, MetricCollector apiCallMetricCollector, ListTagsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$initializeCluster$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$initializeCluster$42(List metricPublishers, MetricCollector apiCallMetricCollector, InitializeClusterResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getResourcePolicy$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getResourcePolicy$38(List metricPublishers, MetricCollector apiCallMetricCollector, GetResourcePolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeClusters$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeClusters$34(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeClustersResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeBackups$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeBackups$30(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeBackupsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteResourcePolicy$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteResourcePolicy$26(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteResourcePolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteHsm$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteHsm$22(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteHsmResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteCluster$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteCluster$18(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteClusterResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteBackup$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteBackup$14(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteBackupResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createHsm$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createHsm$10(List metricPublishers, MetricCollector apiCallMetricCollector, CreateHsmResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createCluster$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createCluster$6(List metricPublishers, MetricCollector apiCallMetricCollector, CreateClusterResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$copyBackupToRegion$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$copyBackupToRegion$2(List metricPublishers, MetricCollector apiCallMetricCollector, CopyBackupToRegionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }
}

