/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container for the parameters to the <code><a>DeleteIndexField</a></code> operation. Specifies the name of the domain
 * you want to update and the name of the index field you want to delete.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteIndexFieldRequest extends CloudSearchRequest implements
        ToCopyableBuilder<DeleteIndexFieldRequest.Builder, DeleteIndexFieldRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(DeleteIndexFieldRequest::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()).build();

    private static final SdkField<String> INDEX_FIELD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexFieldName").getter(getter(DeleteIndexFieldRequest::indexFieldName))
            .setter(setter(Builder::indexFieldName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexFieldName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD,
            INDEX_FIELD_NAME_FIELD));

    private final String domainName;

    private final String indexFieldName;

    private DeleteIndexFieldRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.indexFieldName = builder.indexFieldName;
    }

    /**
     * Returns the value of the DomainName property for this object.
     * 
     * @return The value of the DomainName property for this object.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The name of the index field your want to remove from the domain's indexing options.
     * </p>
     * 
     * @return The name of the index field your want to remove from the domain's indexing options.
     */
    public final String indexFieldName() {
        return indexFieldName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(indexFieldName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteIndexFieldRequest)) {
            return false;
        }
        DeleteIndexFieldRequest other = (DeleteIndexFieldRequest) obj;
        return Objects.equals(domainName(), other.domainName()) && Objects.equals(indexFieldName(), other.indexFieldName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteIndexFieldRequest").add("DomainName", domainName())
                .add("IndexFieldName", indexFieldName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "IndexFieldName":
            return Optional.ofNullable(clazz.cast(indexFieldName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteIndexFieldRequest, T> g) {
        return obj -> g.apply((DeleteIndexFieldRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudSearchRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteIndexFieldRequest> {
        /**
         * Sets the value of the DomainName property for this object.
         *
         * @param domainName
         *        The new value for the DomainName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The name of the index field your want to remove from the domain's indexing options.
         * </p>
         * 
         * @param indexFieldName
         *        The name of the index field your want to remove from the domain's indexing options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexFieldName(String indexFieldName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudSearchRequest.BuilderImpl implements Builder {
        private String domainName;

        private String indexFieldName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteIndexFieldRequest model) {
            super(model);
            domainName(model.domainName);
            indexFieldName(model.indexFieldName);
        }

        public final String getDomainName() {
            return domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getIndexFieldName() {
            return indexFieldName;
        }

        @Override
        public final Builder indexFieldName(String indexFieldName) {
            this.indexFieldName = indexFieldName;
            return this;
        }

        public final void setIndexFieldName(String indexFieldName) {
            this.indexFieldName = indexFieldName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteIndexFieldRequest build() {
            return new DeleteIndexFieldRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
