/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result of a <code><a>DeleteIndexField</a></code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteIndexFieldResponse extends CloudSearchResponse implements
        ToCopyableBuilder<DeleteIndexFieldResponse.Builder, DeleteIndexFieldResponse> {
    private static final SdkField<IndexFieldStatus> INDEX_FIELD_FIELD = SdkField
            .<IndexFieldStatus> builder(MarshallingType.SDK_POJO).memberName("IndexField")
            .getter(getter(DeleteIndexFieldResponse::indexField)).setter(setter(Builder::indexField))
            .constructor(IndexFieldStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexField").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_FIELD_FIELD));

    private final IndexFieldStatus indexField;

    private DeleteIndexFieldResponse(BuilderImpl builder) {
        super(builder);
        this.indexField = builder.indexField;
    }

    /**
     * <p>
     * The status of the index field being deleted.
     * </p>
     * 
     * @return The status of the index field being deleted.
     */
    public final IndexFieldStatus indexField() {
        return indexField;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(indexField());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteIndexFieldResponse)) {
            return false;
        }
        DeleteIndexFieldResponse other = (DeleteIndexFieldResponse) obj;
        return Objects.equals(indexField(), other.indexField());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteIndexFieldResponse").add("IndexField", indexField()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IndexField":
            return Optional.ofNullable(clazz.cast(indexField()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteIndexFieldResponse, T> g) {
        return obj -> g.apply((DeleteIndexFieldResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudSearchResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeleteIndexFieldResponse> {
        /**
         * <p>
         * The status of the index field being deleted.
         * </p>
         * 
         * @param indexField
         *        The status of the index field being deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexField(IndexFieldStatus indexField);

        /**
         * <p>
         * The status of the index field being deleted.
         * </p>
         * This is a convenience method that creates an instance of the {@link IndexFieldStatus.Builder} avoiding the
         * need to create one manually via {@link IndexFieldStatus#builder()}.
         *
         * When the {@link Consumer} completes, {@link IndexFieldStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #indexField(IndexFieldStatus)}.
         * 
         * @param indexField
         *        a consumer that will call methods on {@link IndexFieldStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #indexField(IndexFieldStatus)
         */
        default Builder indexField(Consumer<IndexFieldStatus.Builder> indexField) {
            return indexField(IndexFieldStatus.builder().applyMutation(indexField).build());
        }
    }

    static final class BuilderImpl extends CloudSearchResponse.BuilderImpl implements Builder {
        private IndexFieldStatus indexField;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteIndexFieldResponse model) {
            super(model);
            indexField(model.indexField);
        }

        public final IndexFieldStatus.Builder getIndexField() {
            return indexField != null ? indexField.toBuilder() : null;
        }

        public final void setIndexField(IndexFieldStatus.BuilderImpl indexField) {
            this.indexField = indexField != null ? indexField.build() : null;
        }

        @Override
        public final Builder indexField(IndexFieldStatus indexField) {
            this.indexField = indexField;
            return this;
        }

        @Override
        public DeleteIndexFieldResponse build() {
            return new DeleteIndexFieldResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
