/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudsearch.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result of a <code>DescribeSuggesters</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSuggestersResponse extends CloudSearchResponse implements
        ToCopyableBuilder<DescribeSuggestersResponse.Builder, DescribeSuggestersResponse> {
    private static final SdkField<List<SuggesterStatus>> SUGGESTERS_FIELD = SdkField
            .<List<SuggesterStatus>> builder(MarshallingType.LIST)
            .memberName("Suggesters")
            .getter(getter(DescribeSuggestersResponse::suggesters))
            .setter(setter(Builder::suggesters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Suggesters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SuggesterStatus> builder(MarshallingType.SDK_POJO)
                                            .constructor(SuggesterStatus::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUGGESTERS_FIELD));

    private final List<SuggesterStatus> suggesters;

    private DescribeSuggestersResponse(BuilderImpl builder) {
        super(builder);
        this.suggesters = builder.suggesters;
    }

    /**
     * For responses, this returns true if the service returned a value for the Suggesters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSuggesters() {
        return suggesters != null && !(suggesters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The suggesters configured for the domain specified in the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSuggesters} method.
     * </p>
     * 
     * @return The suggesters configured for the domain specified in the request.
     */
    public final List<SuggesterStatus> suggesters() {
        return suggesters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSuggesters() ? suggesters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSuggestersResponse)) {
            return false;
        }
        DescribeSuggestersResponse other = (DescribeSuggestersResponse) obj;
        return hasSuggesters() == other.hasSuggesters() && Objects.equals(suggesters(), other.suggesters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeSuggestersResponse").add("Suggesters", hasSuggesters() ? suggesters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Suggesters":
            return Optional.ofNullable(clazz.cast(suggesters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSuggestersResponse, T> g) {
        return obj -> g.apply((DescribeSuggestersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudSearchResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeSuggestersResponse> {
        /**
         * <p>
         * The suggesters configured for the domain specified in the request.
         * </p>
         * 
         * @param suggesters
         *        The suggesters configured for the domain specified in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suggesters(Collection<SuggesterStatus> suggesters);

        /**
         * <p>
         * The suggesters configured for the domain specified in the request.
         * </p>
         * 
         * @param suggesters
         *        The suggesters configured for the domain specified in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suggesters(SuggesterStatus... suggesters);

        /**
         * <p>
         * The suggesters configured for the domain specified in the request.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SuggesterStatus>.Builder} avoiding the need
         * to create one manually via {@link List<SuggesterStatus>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SuggesterStatus>.Builder#build()} is called immediately and
         * its result is passed to {@link #suggesters(List<SuggesterStatus>)}.
         * 
         * @param suggesters
         *        a consumer that will call methods on {@link List<SuggesterStatus>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #suggesters(List<SuggesterStatus>)
         */
        Builder suggesters(Consumer<SuggesterStatus.Builder>... suggesters);
    }

    static final class BuilderImpl extends CloudSearchResponse.BuilderImpl implements Builder {
        private List<SuggesterStatus> suggesters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSuggestersResponse model) {
            super(model);
            suggesters(model.suggesters);
        }

        public final List<SuggesterStatus.Builder> getSuggesters() {
            List<SuggesterStatus.Builder> result = SuggesterStatusListCopier.copyToBuilder(this.suggesters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSuggesters(Collection<SuggesterStatus.BuilderImpl> suggesters) {
            this.suggesters = SuggesterStatusListCopier.copyFromBuilder(suggesters);
        }

        @Override
        @Transient
        public final Builder suggesters(Collection<SuggesterStatus> suggesters) {
            this.suggesters = SuggesterStatusListCopier.copy(suggesters);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder suggesters(SuggesterStatus... suggesters) {
            suggesters(Arrays.asList(suggesters));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder suggesters(Consumer<SuggesterStatus.Builder>... suggesters) {
            suggesters(Stream.of(suggesters).map(c -> SuggesterStatus.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeSuggestersResponse build() {
            return new DescribeSuggestersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
