/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudsearch.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Options for a search suggester.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DocumentSuggesterOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<DocumentSuggesterOptions.Builder, DocumentSuggesterOptions> {
    private static final SdkField<String> SOURCE_FIELD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceField").getter(getter(DocumentSuggesterOptions::sourceField)).setter(setter(Builder::sourceField))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceField").build()).build();

    private static final SdkField<String> FUZZY_MATCHING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FuzzyMatching").getter(getter(DocumentSuggesterOptions::fuzzyMatchingAsString))
            .setter(setter(Builder::fuzzyMatching))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FuzzyMatching").build()).build();

    private static final SdkField<String> SORT_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SortExpression").getter(getter(DocumentSuggesterOptions::sortExpression))
            .setter(setter(Builder::sortExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortExpression").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FIELD_FIELD,
            FUZZY_MATCHING_FIELD, SORT_EXPRESSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String sourceField;

    private final String fuzzyMatching;

    private final String sortExpression;

    private DocumentSuggesterOptions(BuilderImpl builder) {
        this.sourceField = builder.sourceField;
        this.fuzzyMatching = builder.fuzzyMatching;
        this.sortExpression = builder.sortExpression;
    }

    /**
     * <p>
     * The name of the index field you want to use for suggestions.
     * </p>
     * 
     * @return The name of the index field you want to use for suggestions.
     */
    public final String sourceField() {
        return sourceField;
    }

    /**
     * <p>
     * The level of fuzziness allowed when suggesting matches for a string: <code>none</code>, <code>low</code>, or
     * <code>high</code>. With none, the specified string is treated as an exact prefix. With low, suggestions must
     * differ from the specified string by no more than one character. With high, suggestions can differ by up to two
     * characters. The default is none.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fuzzyMatching}
     * will return {@link SuggesterFuzzyMatching#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #fuzzyMatchingAsString}.
     * </p>
     * 
     * @return The level of fuzziness allowed when suggesting matches for a string: <code>none</code>, <code>low</code>,
     *         or <code>high</code>. With none, the specified string is treated as an exact prefix. With low,
     *         suggestions must differ from the specified string by no more than one character. With high, suggestions
     *         can differ by up to two characters. The default is none.
     * @see SuggesterFuzzyMatching
     */
    public final SuggesterFuzzyMatching fuzzyMatching() {
        return SuggesterFuzzyMatching.fromValue(fuzzyMatching);
    }

    /**
     * <p>
     * The level of fuzziness allowed when suggesting matches for a string: <code>none</code>, <code>low</code>, or
     * <code>high</code>. With none, the specified string is treated as an exact prefix. With low, suggestions must
     * differ from the specified string by no more than one character. With high, suggestions can differ by up to two
     * characters. The default is none.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fuzzyMatching}
     * will return {@link SuggesterFuzzyMatching#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #fuzzyMatchingAsString}.
     * </p>
     * 
     * @return The level of fuzziness allowed when suggesting matches for a string: <code>none</code>, <code>low</code>,
     *         or <code>high</code>. With none, the specified string is treated as an exact prefix. With low,
     *         suggestions must differ from the specified string by no more than one character. With high, suggestions
     *         can differ by up to two characters. The default is none.
     * @see SuggesterFuzzyMatching
     */
    public final String fuzzyMatchingAsString() {
        return fuzzyMatching;
    }

    /**
     * <p>
     * An expression that computes a score for each suggestion to control how they are sorted. The scores are rounded to
     * the nearest integer, with a floor of 0 and a ceiling of 2^31-1. A document's relevance score is not computed for
     * suggestions, so sort expressions cannot reference the <code>_score</code> value. To sort suggestions using a
     * numeric field or existing expression, simply specify the name of the field or expression. If no expression is
     * configured for the suggester, the suggestions are sorted with the closest matches listed first.
     * </p>
     * 
     * @return An expression that computes a score for each suggestion to control how they are sorted. The scores are
     *         rounded to the nearest integer, with a floor of 0 and a ceiling of 2^31-1. A document's relevance score
     *         is not computed for suggestions, so sort expressions cannot reference the <code>_score</code> value. To
     *         sort suggestions using a numeric field or existing expression, simply specify the name of the field or
     *         expression. If no expression is configured for the suggester, the suggestions are sorted with the closest
     *         matches listed first.
     */
    public final String sortExpression() {
        return sortExpression;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceField());
        hashCode = 31 * hashCode + Objects.hashCode(fuzzyMatchingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortExpression());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentSuggesterOptions)) {
            return false;
        }
        DocumentSuggesterOptions other = (DocumentSuggesterOptions) obj;
        return Objects.equals(sourceField(), other.sourceField())
                && Objects.equals(fuzzyMatchingAsString(), other.fuzzyMatchingAsString())
                && Objects.equals(sortExpression(), other.sortExpression());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DocumentSuggesterOptions").add("SourceField", sourceField())
                .add("FuzzyMatching", fuzzyMatchingAsString()).add("SortExpression", sortExpression()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceField":
            return Optional.ofNullable(clazz.cast(sourceField()));
        case "FuzzyMatching":
            return Optional.ofNullable(clazz.cast(fuzzyMatchingAsString()));
        case "SortExpression":
            return Optional.ofNullable(clazz.cast(sortExpression()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DocumentSuggesterOptions, T> g) {
        return obj -> g.apply((DocumentSuggesterOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DocumentSuggesterOptions> {
        /**
         * <p>
         * The name of the index field you want to use for suggestions.
         * </p>
         * 
         * @param sourceField
         *        The name of the index field you want to use for suggestions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceField(String sourceField);

        /**
         * <p>
         * The level of fuzziness allowed when suggesting matches for a string: <code>none</code>, <code>low</code>, or
         * <code>high</code>. With none, the specified string is treated as an exact prefix. With low, suggestions must
         * differ from the specified string by no more than one character. With high, suggestions can differ by up to
         * two characters. The default is none.
         * </p>
         * 
         * @param fuzzyMatching
         *        The level of fuzziness allowed when suggesting matches for a string: <code>none</code>,
         *        <code>low</code>, or <code>high</code>. With none, the specified string is treated as an exact prefix.
         *        With low, suggestions must differ from the specified string by no more than one character. With high,
         *        suggestions can differ by up to two characters. The default is none.
         * @see SuggesterFuzzyMatching
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SuggesterFuzzyMatching
         */
        Builder fuzzyMatching(String fuzzyMatching);

        /**
         * <p>
         * The level of fuzziness allowed when suggesting matches for a string: <code>none</code>, <code>low</code>, or
         * <code>high</code>. With none, the specified string is treated as an exact prefix. With low, suggestions must
         * differ from the specified string by no more than one character. With high, suggestions can differ by up to
         * two characters. The default is none.
         * </p>
         * 
         * @param fuzzyMatching
         *        The level of fuzziness allowed when suggesting matches for a string: <code>none</code>,
         *        <code>low</code>, or <code>high</code>. With none, the specified string is treated as an exact prefix.
         *        With low, suggestions must differ from the specified string by no more than one character. With high,
         *        suggestions can differ by up to two characters. The default is none.
         * @see SuggesterFuzzyMatching
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SuggesterFuzzyMatching
         */
        Builder fuzzyMatching(SuggesterFuzzyMatching fuzzyMatching);

        /**
         * <p>
         * An expression that computes a score for each suggestion to control how they are sorted. The scores are
         * rounded to the nearest integer, with a floor of 0 and a ceiling of 2^31-1. A document's relevance score is
         * not computed for suggestions, so sort expressions cannot reference the <code>_score</code> value. To sort
         * suggestions using a numeric field or existing expression, simply specify the name of the field or expression.
         * If no expression is configured for the suggester, the suggestions are sorted with the closest matches listed
         * first.
         * </p>
         * 
         * @param sortExpression
         *        An expression that computes a score for each suggestion to control how they are sorted. The scores are
         *        rounded to the nearest integer, with a floor of 0 and a ceiling of 2^31-1. A document's relevance
         *        score is not computed for suggestions, so sort expressions cannot reference the <code>_score</code>
         *        value. To sort suggestions using a numeric field or existing expression, simply specify the name of
         *        the field or expression. If no expression is configured for the suggester, the suggestions are sorted
         *        with the closest matches listed first.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortExpression(String sortExpression);
    }

    static final class BuilderImpl implements Builder {
        private String sourceField;

        private String fuzzyMatching;

        private String sortExpression;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentSuggesterOptions model) {
            sourceField(model.sourceField);
            fuzzyMatching(model.fuzzyMatching);
            sortExpression(model.sortExpression);
        }

        public final String getSourceField() {
            return sourceField;
        }

        public final void setSourceField(String sourceField) {
            this.sourceField = sourceField;
        }

        @Override
        @Transient
        public final Builder sourceField(String sourceField) {
            this.sourceField = sourceField;
            return this;
        }

        public final String getFuzzyMatching() {
            return fuzzyMatching;
        }

        public final void setFuzzyMatching(String fuzzyMatching) {
            this.fuzzyMatching = fuzzyMatching;
        }

        @Override
        @Transient
        public final Builder fuzzyMatching(String fuzzyMatching) {
            this.fuzzyMatching = fuzzyMatching;
            return this;
        }

        @Override
        @Transient
        public final Builder fuzzyMatching(SuggesterFuzzyMatching fuzzyMatching) {
            this.fuzzyMatching(fuzzyMatching == null ? null : fuzzyMatching.toString());
            return this;
        }

        public final String getSortExpression() {
            return sortExpression;
        }

        public final void setSortExpression(String sortExpression) {
            this.sortExpression = sortExpression;
        }

        @Override
        @Transient
        public final Builder sortExpression(String sortExpression) {
            this.sortExpression = sortExpression;
            return this;
        }

        @Override
        public DocumentSuggesterOptions build() {
            return new DocumentSuggesterOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
