/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudsearch.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The domain's endpoint options.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DomainEndpointOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<DomainEndpointOptions.Builder, DomainEndpointOptions> {
    private static final SdkField<Boolean> ENFORCE_HTTPS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnforceHTTPS").getter(getter(DomainEndpointOptions::enforceHTTPS)).setter(setter(Builder::enforceHTTPS))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnforceHTTPS").build()).build();

    private static final SdkField<String> TLS_SECURITY_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TLSSecurityPolicy").getter(getter(DomainEndpointOptions::tlsSecurityPolicyAsString))
            .setter(setter(Builder::tlsSecurityPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TLSSecurityPolicy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENFORCE_HTTPS_FIELD,
            TLS_SECURITY_POLICY_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean enforceHTTPS;

    private final String tlsSecurityPolicy;

    private DomainEndpointOptions(BuilderImpl builder) {
        this.enforceHTTPS = builder.enforceHTTPS;
        this.tlsSecurityPolicy = builder.tlsSecurityPolicy;
    }

    /**
     * <p>
     * Whether the domain is HTTPS only enabled.
     * </p>
     * 
     * @return Whether the domain is HTTPS only enabled.
     */
    public final Boolean enforceHTTPS() {
        return enforceHTTPS;
    }

    /**
     * <p>
     * The minimum required TLS version
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tlsSecurityPolicy}
     * will return {@link TLSSecurityPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #tlsSecurityPolicyAsString}.
     * </p>
     * 
     * @return The minimum required TLS version
     * @see TLSSecurityPolicy
     */
    public final TLSSecurityPolicy tlsSecurityPolicy() {
        return TLSSecurityPolicy.fromValue(tlsSecurityPolicy);
    }

    /**
     * <p>
     * The minimum required TLS version
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tlsSecurityPolicy}
     * will return {@link TLSSecurityPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #tlsSecurityPolicyAsString}.
     * </p>
     * 
     * @return The minimum required TLS version
     * @see TLSSecurityPolicy
     */
    public final String tlsSecurityPolicyAsString() {
        return tlsSecurityPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enforceHTTPS());
        hashCode = 31 * hashCode + Objects.hashCode(tlsSecurityPolicyAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainEndpointOptions)) {
            return false;
        }
        DomainEndpointOptions other = (DomainEndpointOptions) obj;
        return Objects.equals(enforceHTTPS(), other.enforceHTTPS())
                && Objects.equals(tlsSecurityPolicyAsString(), other.tlsSecurityPolicyAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DomainEndpointOptions").add("EnforceHTTPS", enforceHTTPS())
                .add("TLSSecurityPolicy", tlsSecurityPolicyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EnforceHTTPS":
            return Optional.ofNullable(clazz.cast(enforceHTTPS()));
        case "TLSSecurityPolicy":
            return Optional.ofNullable(clazz.cast(tlsSecurityPolicyAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DomainEndpointOptions, T> g) {
        return obj -> g.apply((DomainEndpointOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DomainEndpointOptions> {
        /**
         * <p>
         * Whether the domain is HTTPS only enabled.
         * </p>
         * 
         * @param enforceHTTPS
         *        Whether the domain is HTTPS only enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enforceHTTPS(Boolean enforceHTTPS);

        /**
         * <p>
         * The minimum required TLS version
         * </p>
         * 
         * @param tlsSecurityPolicy
         *        The minimum required TLS version
         * @see TLSSecurityPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TLSSecurityPolicy
         */
        Builder tlsSecurityPolicy(String tlsSecurityPolicy);

        /**
         * <p>
         * The minimum required TLS version
         * </p>
         * 
         * @param tlsSecurityPolicy
         *        The minimum required TLS version
         * @see TLSSecurityPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TLSSecurityPolicy
         */
        Builder tlsSecurityPolicy(TLSSecurityPolicy tlsSecurityPolicy);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enforceHTTPS;

        private String tlsSecurityPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainEndpointOptions model) {
            enforceHTTPS(model.enforceHTTPS);
            tlsSecurityPolicy(model.tlsSecurityPolicy);
        }

        public final Boolean getEnforceHTTPS() {
            return enforceHTTPS;
        }

        public final void setEnforceHTTPS(Boolean enforceHTTPS) {
            this.enforceHTTPS = enforceHTTPS;
        }

        @Override
        @Transient
        public final Builder enforceHTTPS(Boolean enforceHTTPS) {
            this.enforceHTTPS = enforceHTTPS;
            return this;
        }

        public final String getTlsSecurityPolicy() {
            return tlsSecurityPolicy;
        }

        public final void setTlsSecurityPolicy(String tlsSecurityPolicy) {
            this.tlsSecurityPolicy = tlsSecurityPolicy;
        }

        @Override
        @Transient
        public final Builder tlsSecurityPolicy(String tlsSecurityPolicy) {
            this.tlsSecurityPolicy = tlsSecurityPolicy;
            return this;
        }

        @Override
        @Transient
        public final Builder tlsSecurityPolicy(TLSSecurityPolicy tlsSecurityPolicy) {
            this.tlsSecurityPolicy(tlsSecurityPolicy == null ? null : tlsSecurityPolicy.toString());
            return this;
        }

        @Override
        public DomainEndpointOptions build() {
            return new DomainEndpointOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
