/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudsearch.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class Limits implements SdkPojo, Serializable, ToCopyableBuilder<Limits.Builder, Limits> {
    private static final SdkField<Integer> MAXIMUM_REPLICATION_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaximumReplicationCount").getter(getter(Limits::maximumReplicationCount))
            .setter(setter(Builder::maximumReplicationCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumReplicationCount").build())
            .build();

    private static final SdkField<Integer> MAXIMUM_PARTITION_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaximumPartitionCount").getter(getter(Limits::maximumPartitionCount))
            .setter(setter(Builder::maximumPartitionCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumPartitionCount").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MAXIMUM_REPLICATION_COUNT_FIELD, MAXIMUM_PARTITION_COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer maximumReplicationCount;

    private final Integer maximumPartitionCount;

    private Limits(BuilderImpl builder) {
        this.maximumReplicationCount = builder.maximumReplicationCount;
        this.maximumPartitionCount = builder.maximumPartitionCount;
    }

    /**
     * Returns the value of the MaximumReplicationCount property for this object.
     * 
     * @return The value of the MaximumReplicationCount property for this object.
     */
    public final Integer maximumReplicationCount() {
        return maximumReplicationCount;
    }

    /**
     * Returns the value of the MaximumPartitionCount property for this object.
     * 
     * @return The value of the MaximumPartitionCount property for this object.
     */
    public final Integer maximumPartitionCount() {
        return maximumPartitionCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maximumReplicationCount());
        hashCode = 31 * hashCode + Objects.hashCode(maximumPartitionCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Limits)) {
            return false;
        }
        Limits other = (Limits) obj;
        return Objects.equals(maximumReplicationCount(), other.maximumReplicationCount())
                && Objects.equals(maximumPartitionCount(), other.maximumPartitionCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Limits").add("MaximumReplicationCount", maximumReplicationCount())
                .add("MaximumPartitionCount", maximumPartitionCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaximumReplicationCount":
            return Optional.ofNullable(clazz.cast(maximumReplicationCount()));
        case "MaximumPartitionCount":
            return Optional.ofNullable(clazz.cast(maximumPartitionCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Limits, T> g) {
        return obj -> g.apply((Limits) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Limits> {
        /**
         * Sets the value of the MaximumReplicationCount property for this object.
         *
         * @param maximumReplicationCount
         *        The new value for the MaximumReplicationCount property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumReplicationCount(Integer maximumReplicationCount);

        /**
         * Sets the value of the MaximumPartitionCount property for this object.
         *
         * @param maximumPartitionCount
         *        The new value for the MaximumPartitionCount property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumPartitionCount(Integer maximumPartitionCount);
    }

    static final class BuilderImpl implements Builder {
        private Integer maximumReplicationCount;

        private Integer maximumPartitionCount;

        private BuilderImpl() {
        }

        private BuilderImpl(Limits model) {
            maximumReplicationCount(model.maximumReplicationCount);
            maximumPartitionCount(model.maximumPartitionCount);
        }

        public final Integer getMaximumReplicationCount() {
            return maximumReplicationCount;
        }

        public final void setMaximumReplicationCount(Integer maximumReplicationCount) {
            this.maximumReplicationCount = maximumReplicationCount;
        }

        @Override
        @Transient
        public final Builder maximumReplicationCount(Integer maximumReplicationCount) {
            this.maximumReplicationCount = maximumReplicationCount;
            return this;
        }

        public final Integer getMaximumPartitionCount() {
            return maximumPartitionCount;
        }

        public final void setMaximumPartitionCount(Integer maximumPartitionCount) {
            this.maximumPartitionCount = maximumPartitionCount;
        }

        @Override
        @Transient
        public final Builder maximumPartitionCount(Integer maximumPartitionCount) {
            this.maximumPartitionCount = maximumPartitionCount;
            return this;
        }

        @Override
        public Limits build() {
            return new Limits(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
