/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudsearch.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * <p>
 * The type of field. The valid options for a field depend on the field type. For more information about the supported
 * field types, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-index-fields.html"
 * target="_blank">Configuring Index Fields</a> in the <i>Amazon CloudSearch Developer Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public enum IndexFieldType {
    INT("int"),

    DOUBLE("double"),

    LITERAL("literal"),

    TEXT("text"),

    DATE("date"),

    LATLON("latlon"),

    INT_ARRAY("int-array"),

    DOUBLE_ARRAY("double-array"),

    LITERAL_ARRAY("literal-array"),

    TEXT_ARRAY("text-array"),

    DATE_ARRAY("date-array"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, IndexFieldType> VALUE_MAP = EnumUtils.uniqueIndex(IndexFieldType.class,
            IndexFieldType::toString);

    private final String value;

    private IndexFieldType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return IndexFieldType corresponding to the value
     */
    public static IndexFieldType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link IndexFieldType}s
     */
    public static Set<IndexFieldType> knownValues() {
        Set<IndexFieldType> knownValues = EnumSet.allOf(IndexFieldType.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
