/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result of a <code>DefineSuggester</code> request. Contains the status of the newly-configured suggester.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DefineSuggesterResponse extends CloudSearchResponse implements
        ToCopyableBuilder<DefineSuggesterResponse.Builder, DefineSuggesterResponse> {
    private static final SdkField<SuggesterStatus> SUGGESTER_FIELD = SdkField.<SuggesterStatus> builder(MarshallingType.SDK_POJO)
            .memberName("Suggester").getter(getter(DefineSuggesterResponse::suggester)).setter(setter(Builder::suggester))
            .constructor(SuggesterStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Suggester").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUGGESTER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final SuggesterStatus suggester;

    private DefineSuggesterResponse(BuilderImpl builder) {
        super(builder);
        this.suggester = builder.suggester;
    }

    /**
     * Returns the value of the Suggester property for this object.
     * 
     * @return The value of the Suggester property for this object.
     */
    public final SuggesterStatus suggester() {
        return suggester;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(suggester());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefineSuggesterResponse)) {
            return false;
        }
        DefineSuggesterResponse other = (DefineSuggesterResponse) obj;
        return Objects.equals(suggester(), other.suggester());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DefineSuggesterResponse").add("Suggester", suggester()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Suggester":
            return Optional.ofNullable(clazz.cast(suggester()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Suggester", SUGGESTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DefineSuggesterResponse, T> g) {
        return obj -> g.apply((DefineSuggesterResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudSearchResponse.Builder, SdkPojo, CopyableBuilder<Builder, DefineSuggesterResponse> {
        /**
         * Sets the value of the Suggester property for this object.
         *
         * @param suggester
         *        The new value for the Suggester property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suggester(SuggesterStatus suggester);

        /**
         * Sets the value of the Suggester property for this object.
         *
         * This is a convenience method that creates an instance of the {@link SuggesterStatus.Builder} avoiding the
         * need to create one manually via {@link SuggesterStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SuggesterStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #suggester(SuggesterStatus)}.
         * 
         * @param suggester
         *        a consumer that will call methods on {@link SuggesterStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #suggester(SuggesterStatus)
         */
        default Builder suggester(Consumer<SuggesterStatus.Builder> suggester) {
            return suggester(SuggesterStatus.builder().applyMutation(suggester).build());
        }
    }

    static final class BuilderImpl extends CloudSearchResponse.BuilderImpl implements Builder {
        private SuggesterStatus suggester;

        private BuilderImpl() {
        }

        private BuilderImpl(DefineSuggesterResponse model) {
            super(model);
            suggester(model.suggester);
        }

        public final SuggesterStatus.Builder getSuggester() {
            return suggester != null ? suggester.toBuilder() : null;
        }

        public final void setSuggester(SuggesterStatus.BuilderImpl suggester) {
            this.suggester = suggester != null ? suggester.build() : null;
        }

        @Override
        public final Builder suggester(SuggesterStatus suggester) {
            this.suggester = suggester;
            return this;
        }

        @Override
        public DefineSuggesterResponse build() {
            return new DefineSuggesterResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
