/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result of a <code><a>DeleteExpression</a></code> request. Specifies the expression being deleted.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteExpressionResponse extends CloudSearchResponse implements
        ToCopyableBuilder<DeleteExpressionResponse.Builder, DeleteExpressionResponse> {
    private static final SdkField<ExpressionStatus> EXPRESSION_FIELD = SdkField
            .<ExpressionStatus> builder(MarshallingType.SDK_POJO).memberName("Expression")
            .getter(getter(DeleteExpressionResponse::expression)).setter(setter(Builder::expression))
            .constructor(ExpressionStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expression").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPRESSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ExpressionStatus expression;

    private DeleteExpressionResponse(BuilderImpl builder) {
        super(builder);
        this.expression = builder.expression;
    }

    /**
     * <p>
     * The status of the expression being deleted.
     * </p>
     * 
     * @return The status of the expression being deleted.
     */
    public final ExpressionStatus expression() {
        return expression;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(expression());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteExpressionResponse)) {
            return false;
        }
        DeleteExpressionResponse other = (DeleteExpressionResponse) obj;
        return Objects.equals(expression(), other.expression());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteExpressionResponse").add("Expression", expression()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Expression":
            return Optional.ofNullable(clazz.cast(expression()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Expression", EXPRESSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteExpressionResponse, T> g) {
        return obj -> g.apply((DeleteExpressionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudSearchResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeleteExpressionResponse> {
        /**
         * <p>
         * The status of the expression being deleted.
         * </p>
         * 
         * @param expression
         *        The status of the expression being deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expression(ExpressionStatus expression);

        /**
         * <p>
         * The status of the expression being deleted.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExpressionStatus.Builder} avoiding the
         * need to create one manually via {@link ExpressionStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExpressionStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #expression(ExpressionStatus)}.
         * 
         * @param expression
         *        a consumer that will call methods on {@link ExpressionStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #expression(ExpressionStatus)
         */
        default Builder expression(Consumer<ExpressionStatus.Builder> expression) {
            return expression(ExpressionStatus.builder().applyMutation(expression).build());
        }
    }

    static final class BuilderImpl extends CloudSearchResponse.BuilderImpl implements Builder {
        private ExpressionStatus expression;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteExpressionResponse model) {
            super(model);
            expression(model.expression);
        }

        public final ExpressionStatus.Builder getExpression() {
            return expression != null ? expression.toBuilder() : null;
        }

        public final void setExpression(ExpressionStatus.BuilderImpl expression) {
            this.expression = expression != null ? expression.build() : null;
        }

        @Override
        public final Builder expression(ExpressionStatus expression) {
            this.expression = expression;
            return this;
        }

        @Override
        public DeleteExpressionResponse build() {
            return new DeleteExpressionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
