/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudsearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The current status of the search domain.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DomainStatus implements SdkPojo, Serializable, ToCopyableBuilder<DomainStatus.Builder, DomainStatus> {
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainId").getter(getter(DomainStatus::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainId").build()).build();

    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(DomainStatus::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ARN")
            .getter(getter(DomainStatus::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARN").build()).build();

    private static final SdkField<Boolean> CREATED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Created").getter(getter(DomainStatus::created)).setter(setter(Builder::created))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Created").build()).build();

    private static final SdkField<Boolean> DELETED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Deleted").getter(getter(DomainStatus::deleted)).setter(setter(Builder::deleted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Deleted").build()).build();

    private static final SdkField<ServiceEndpoint> DOC_SERVICE_FIELD = SdkField
            .<ServiceEndpoint> builder(MarshallingType.SDK_POJO).memberName("DocService")
            .getter(getter(DomainStatus::docService)).setter(setter(Builder::docService)).constructor(ServiceEndpoint::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocService").build()).build();

    private static final SdkField<ServiceEndpoint> SEARCH_SERVICE_FIELD = SdkField
            .<ServiceEndpoint> builder(MarshallingType.SDK_POJO).memberName("SearchService")
            .getter(getter(DomainStatus::searchService)).setter(setter(Builder::searchService))
            .constructor(ServiceEndpoint::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchService").build()).build();

    private static final SdkField<Boolean> REQUIRES_INDEX_DOCUMENTS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RequiresIndexDocuments").getter(getter(DomainStatus::requiresIndexDocuments))
            .setter(setter(Builder::requiresIndexDocuments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequiresIndexDocuments").build())
            .build();

    private static final SdkField<Boolean> PROCESSING_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Processing").getter(getter(DomainStatus::processing)).setter(setter(Builder::processing))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Processing").build()).build();

    private static final SdkField<String> SEARCH_INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SearchInstanceType").getter(getter(DomainStatus::searchInstanceType))
            .setter(setter(Builder::searchInstanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchInstanceType").build())
            .build();

    private static final SdkField<Integer> SEARCH_PARTITION_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SearchPartitionCount").getter(getter(DomainStatus::searchPartitionCount))
            .setter(setter(Builder::searchPartitionCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchPartitionCount").build())
            .build();

    private static final SdkField<Integer> SEARCH_INSTANCE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SearchInstanceCount").getter(getter(DomainStatus::searchInstanceCount))
            .setter(setter(Builder::searchInstanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchInstanceCount").build())
            .build();

    private static final SdkField<Limits> LIMITS_FIELD = SdkField.<Limits> builder(MarshallingType.SDK_POJO).memberName("Limits")
            .getter(getter(DomainStatus::limits)).setter(setter(Builder::limits)).constructor(Limits::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limits").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_ID_FIELD,
            DOMAIN_NAME_FIELD, ARN_FIELD, CREATED_FIELD, DELETED_FIELD, DOC_SERVICE_FIELD, SEARCH_SERVICE_FIELD,
            REQUIRES_INDEX_DOCUMENTS_FIELD, PROCESSING_FIELD, SEARCH_INSTANCE_TYPE_FIELD, SEARCH_PARTITION_COUNT_FIELD,
            SEARCH_INSTANCE_COUNT_FIELD, LIMITS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String domainId;

    private final String domainName;

    private final String arn;

    private final Boolean created;

    private final Boolean deleted;

    private final ServiceEndpoint docService;

    private final ServiceEndpoint searchService;

    private final Boolean requiresIndexDocuments;

    private final Boolean processing;

    private final String searchInstanceType;

    private final Integer searchPartitionCount;

    private final Integer searchInstanceCount;

    private final Limits limits;

    private DomainStatus(BuilderImpl builder) {
        this.domainId = builder.domainId;
        this.domainName = builder.domainName;
        this.arn = builder.arn;
        this.created = builder.created;
        this.deleted = builder.deleted;
        this.docService = builder.docService;
        this.searchService = builder.searchService;
        this.requiresIndexDocuments = builder.requiresIndexDocuments;
        this.processing = builder.processing;
        this.searchInstanceType = builder.searchInstanceType;
        this.searchPartitionCount = builder.searchPartitionCount;
        this.searchInstanceCount = builder.searchInstanceCount;
        this.limits = builder.limits;
    }

    /**
     * Returns the value of the DomainId property for this object.
     * 
     * @return The value of the DomainId property for this object.
     */
    public final String domainId() {
        return domainId;
    }

    /**
     * Returns the value of the DomainName property for this object.
     * 
     * @return The value of the DomainName property for this object.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * Returns the value of the ARN property for this object.
     * 
     * @return The value of the ARN property for this object.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * True if the search domain is created. It can take several minutes to initialize a domain when <a>CreateDomain</a>
     * is called. Newly created search domains are returned from <a>DescribeDomains</a> with a false value for Created
     * until domain creation is complete.
     * </p>
     * 
     * @return True if the search domain is created. It can take several minutes to initialize a domain when
     *         <a>CreateDomain</a> is called. Newly created search domains are returned from <a>DescribeDomains</a> with
     *         a false value for Created until domain creation is complete.
     */
    public final Boolean created() {
        return created;
    }

    /**
     * <p>
     * True if the search domain has been deleted. The system must clean up resources dedicated to the search domain
     * when <a>DeleteDomain</a> is called. Newly deleted search domains are returned from <a>DescribeDomains</a> with a
     * true value for IsDeleted for several minutes until resource cleanup is complete.
     * </p>
     * 
     * @return True if the search domain has been deleted. The system must clean up resources dedicated to the search
     *         domain when <a>DeleteDomain</a> is called. Newly deleted search domains are returned from
     *         <a>DescribeDomains</a> with a true value for IsDeleted for several minutes until resource cleanup is
     *         complete.
     */
    public final Boolean deleted() {
        return deleted;
    }

    /**
     * <p>
     * The service endpoint for updating documents in a search domain.
     * </p>
     * 
     * @return The service endpoint for updating documents in a search domain.
     */
    public final ServiceEndpoint docService() {
        return docService;
    }

    /**
     * <p>
     * The service endpoint for requesting search results from a search domain.
     * </p>
     * 
     * @return The service endpoint for requesting search results from a search domain.
     */
    public final ServiceEndpoint searchService() {
        return searchService;
    }

    /**
     * <p>
     * True if <a>IndexDocuments</a> needs to be called to activate the current domain configuration.
     * </p>
     * 
     * @return True if <a>IndexDocuments</a> needs to be called to activate the current domain configuration.
     */
    public final Boolean requiresIndexDocuments() {
        return requiresIndexDocuments;
    }

    /**
     * <p>
     * True if processing is being done to activate the current domain configuration.
     * </p>
     * 
     * @return True if processing is being done to activate the current domain configuration.
     */
    public final Boolean processing() {
        return processing;
    }

    /**
     * <p>
     * The instance type that is being used to process search requests.
     * </p>
     * 
     * @return The instance type that is being used to process search requests.
     */
    public final String searchInstanceType() {
        return searchInstanceType;
    }

    /**
     * <p>
     * The number of partitions across which the search index is spread.
     * </p>
     * 
     * @return The number of partitions across which the search index is spread.
     */
    public final Integer searchPartitionCount() {
        return searchPartitionCount;
    }

    /**
     * <p>
     * The number of search instances that are available to process search requests.
     * </p>
     * 
     * @return The number of search instances that are available to process search requests.
     */
    public final Integer searchInstanceCount() {
        return searchInstanceCount;
    }

    /**
     * Returns the value of the Limits property for this object.
     * 
     * @return The value of the Limits property for this object.
     */
    public final Limits limits() {
        return limits;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(created());
        hashCode = 31 * hashCode + Objects.hashCode(deleted());
        hashCode = 31 * hashCode + Objects.hashCode(docService());
        hashCode = 31 * hashCode + Objects.hashCode(searchService());
        hashCode = 31 * hashCode + Objects.hashCode(requiresIndexDocuments());
        hashCode = 31 * hashCode + Objects.hashCode(processing());
        hashCode = 31 * hashCode + Objects.hashCode(searchInstanceType());
        hashCode = 31 * hashCode + Objects.hashCode(searchPartitionCount());
        hashCode = 31 * hashCode + Objects.hashCode(searchInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(limits());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainStatus)) {
            return false;
        }
        DomainStatus other = (DomainStatus) obj;
        return Objects.equals(domainId(), other.domainId()) && Objects.equals(domainName(), other.domainName())
                && Objects.equals(arn(), other.arn()) && Objects.equals(created(), other.created())
                && Objects.equals(deleted(), other.deleted()) && Objects.equals(docService(), other.docService())
                && Objects.equals(searchService(), other.searchService())
                && Objects.equals(requiresIndexDocuments(), other.requiresIndexDocuments())
                && Objects.equals(processing(), other.processing())
                && Objects.equals(searchInstanceType(), other.searchInstanceType())
                && Objects.equals(searchPartitionCount(), other.searchPartitionCount())
                && Objects.equals(searchInstanceCount(), other.searchInstanceCount()) && Objects.equals(limits(), other.limits());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DomainStatus").add("DomainId", domainId()).add("DomainName", domainName()).add("ARN", arn())
                .add("Created", created()).add("Deleted", deleted()).add("DocService", docService())
                .add("SearchService", searchService()).add("RequiresIndexDocuments", requiresIndexDocuments())
                .add("Processing", processing()).add("SearchInstanceType", searchInstanceType())
                .add("SearchPartitionCount", searchPartitionCount()).add("SearchInstanceCount", searchInstanceCount())
                .add("Limits", limits()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "ARN":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Created":
            return Optional.ofNullable(clazz.cast(created()));
        case "Deleted":
            return Optional.ofNullable(clazz.cast(deleted()));
        case "DocService":
            return Optional.ofNullable(clazz.cast(docService()));
        case "SearchService":
            return Optional.ofNullable(clazz.cast(searchService()));
        case "RequiresIndexDocuments":
            return Optional.ofNullable(clazz.cast(requiresIndexDocuments()));
        case "Processing":
            return Optional.ofNullable(clazz.cast(processing()));
        case "SearchInstanceType":
            return Optional.ofNullable(clazz.cast(searchInstanceType()));
        case "SearchPartitionCount":
            return Optional.ofNullable(clazz.cast(searchPartitionCount()));
        case "SearchInstanceCount":
            return Optional.ofNullable(clazz.cast(searchInstanceCount()));
        case "Limits":
            return Optional.ofNullable(clazz.cast(limits()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DomainId", DOMAIN_ID_FIELD);
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("ARN", ARN_FIELD);
        map.put("Created", CREATED_FIELD);
        map.put("Deleted", DELETED_FIELD);
        map.put("DocService", DOC_SERVICE_FIELD);
        map.put("SearchService", SEARCH_SERVICE_FIELD);
        map.put("RequiresIndexDocuments", REQUIRES_INDEX_DOCUMENTS_FIELD);
        map.put("Processing", PROCESSING_FIELD);
        map.put("SearchInstanceType", SEARCH_INSTANCE_TYPE_FIELD);
        map.put("SearchPartitionCount", SEARCH_PARTITION_COUNT_FIELD);
        map.put("SearchInstanceCount", SEARCH_INSTANCE_COUNT_FIELD);
        map.put("Limits", LIMITS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DomainStatus, T> g) {
        return obj -> g.apply((DomainStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DomainStatus> {
        /**
         * Sets the value of the DomainId property for this object.
         *
         * @param domainId
         *        The new value for the DomainId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * Sets the value of the DomainName property for this object.
         *
         * @param domainName
         *        The new value for the DomainName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * Sets the value of the ARN property for this object.
         *
         * @param arn
         *        The new value for the ARN property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * True if the search domain is created. It can take several minutes to initialize a domain when
         * <a>CreateDomain</a> is called. Newly created search domains are returned from <a>DescribeDomains</a> with a
         * false value for Created until domain creation is complete.
         * </p>
         * 
         * @param created
         *        True if the search domain is created. It can take several minutes to initialize a domain when
         *        <a>CreateDomain</a> is called. Newly created search domains are returned from <a>DescribeDomains</a>
         *        with a false value for Created until domain creation is complete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder created(Boolean created);

        /**
         * <p>
         * True if the search domain has been deleted. The system must clean up resources dedicated to the search domain
         * when <a>DeleteDomain</a> is called. Newly deleted search domains are returned from <a>DescribeDomains</a>
         * with a true value for IsDeleted for several minutes until resource cleanup is complete.
         * </p>
         * 
         * @param deleted
         *        True if the search domain has been deleted. The system must clean up resources dedicated to the search
         *        domain when <a>DeleteDomain</a> is called. Newly deleted search domains are returned from
         *        <a>DescribeDomains</a> with a true value for IsDeleted for several minutes until resource cleanup is
         *        complete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleted(Boolean deleted);

        /**
         * <p>
         * The service endpoint for updating documents in a search domain.
         * </p>
         * 
         * @param docService
         *        The service endpoint for updating documents in a search domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder docService(ServiceEndpoint docService);

        /**
         * <p>
         * The service endpoint for updating documents in a search domain.
         * </p>
         * This is a convenience method that creates an instance of the {@link ServiceEndpoint.Builder} avoiding the
         * need to create one manually via {@link ServiceEndpoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServiceEndpoint.Builder#build()} is called immediately and its
         * result is passed to {@link #docService(ServiceEndpoint)}.
         * 
         * @param docService
         *        a consumer that will call methods on {@link ServiceEndpoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #docService(ServiceEndpoint)
         */
        default Builder docService(Consumer<ServiceEndpoint.Builder> docService) {
            return docService(ServiceEndpoint.builder().applyMutation(docService).build());
        }

        /**
         * <p>
         * The service endpoint for requesting search results from a search domain.
         * </p>
         * 
         * @param searchService
         *        The service endpoint for requesting search results from a search domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchService(ServiceEndpoint searchService);

        /**
         * <p>
         * The service endpoint for requesting search results from a search domain.
         * </p>
         * This is a convenience method that creates an instance of the {@link ServiceEndpoint.Builder} avoiding the
         * need to create one manually via {@link ServiceEndpoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServiceEndpoint.Builder#build()} is called immediately and its
         * result is passed to {@link #searchService(ServiceEndpoint)}.
         * 
         * @param searchService
         *        a consumer that will call methods on {@link ServiceEndpoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #searchService(ServiceEndpoint)
         */
        default Builder searchService(Consumer<ServiceEndpoint.Builder> searchService) {
            return searchService(ServiceEndpoint.builder().applyMutation(searchService).build());
        }

        /**
         * <p>
         * True if <a>IndexDocuments</a> needs to be called to activate the current domain configuration.
         * </p>
         * 
         * @param requiresIndexDocuments
         *        True if <a>IndexDocuments</a> needs to be called to activate the current domain configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requiresIndexDocuments(Boolean requiresIndexDocuments);

        /**
         * <p>
         * True if processing is being done to activate the current domain configuration.
         * </p>
         * 
         * @param processing
         *        True if processing is being done to activate the current domain configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processing(Boolean processing);

        /**
         * <p>
         * The instance type that is being used to process search requests.
         * </p>
         * 
         * @param searchInstanceType
         *        The instance type that is being used to process search requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchInstanceType(String searchInstanceType);

        /**
         * <p>
         * The number of partitions across which the search index is spread.
         * </p>
         * 
         * @param searchPartitionCount
         *        The number of partitions across which the search index is spread.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchPartitionCount(Integer searchPartitionCount);

        /**
         * <p>
         * The number of search instances that are available to process search requests.
         * </p>
         * 
         * @param searchInstanceCount
         *        The number of search instances that are available to process search requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchInstanceCount(Integer searchInstanceCount);

        /**
         * Sets the value of the Limits property for this object.
         *
         * @param limits
         *        The new value for the Limits property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limits(Limits limits);

        /**
         * Sets the value of the Limits property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Limits.Builder} avoiding the need to
         * create one manually via {@link Limits#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Limits.Builder#build()} is called immediately and its result is
         * passed to {@link #limits(Limits)}.
         * 
         * @param limits
         *        a consumer that will call methods on {@link Limits.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #limits(Limits)
         */
        default Builder limits(Consumer<Limits.Builder> limits) {
            return limits(Limits.builder().applyMutation(limits).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String domainId;

        private String domainName;

        private String arn;

        private Boolean created;

        private Boolean deleted;

        private ServiceEndpoint docService;

        private ServiceEndpoint searchService;

        private Boolean requiresIndexDocuments;

        private Boolean processing;

        private String searchInstanceType;

        private Integer searchPartitionCount;

        private Integer searchInstanceCount;

        private Limits limits;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainStatus model) {
            domainId(model.domainId);
            domainName(model.domainName);
            arn(model.arn);
            created(model.created);
            deleted(model.deleted);
            docService(model.docService);
            searchService(model.searchService);
            requiresIndexDocuments(model.requiresIndexDocuments);
            processing(model.processing);
            searchInstanceType(model.searchInstanceType);
            searchPartitionCount(model.searchPartitionCount);
            searchInstanceCount(model.searchInstanceCount);
            limits(model.limits);
        }

        public final String getDomainId() {
            return domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Boolean getCreated() {
            return created;
        }

        public final void setCreated(Boolean created) {
            this.created = created;
        }

        @Override
        public final Builder created(Boolean created) {
            this.created = created;
            return this;
        }

        public final Boolean getDeleted() {
            return deleted;
        }

        public final void setDeleted(Boolean deleted) {
            this.deleted = deleted;
        }

        @Override
        public final Builder deleted(Boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        public final ServiceEndpoint.Builder getDocService() {
            return docService != null ? docService.toBuilder() : null;
        }

        public final void setDocService(ServiceEndpoint.BuilderImpl docService) {
            this.docService = docService != null ? docService.build() : null;
        }

        @Override
        public final Builder docService(ServiceEndpoint docService) {
            this.docService = docService;
            return this;
        }

        public final ServiceEndpoint.Builder getSearchService() {
            return searchService != null ? searchService.toBuilder() : null;
        }

        public final void setSearchService(ServiceEndpoint.BuilderImpl searchService) {
            this.searchService = searchService != null ? searchService.build() : null;
        }

        @Override
        public final Builder searchService(ServiceEndpoint searchService) {
            this.searchService = searchService;
            return this;
        }

        public final Boolean getRequiresIndexDocuments() {
            return requiresIndexDocuments;
        }

        public final void setRequiresIndexDocuments(Boolean requiresIndexDocuments) {
            this.requiresIndexDocuments = requiresIndexDocuments;
        }

        @Override
        public final Builder requiresIndexDocuments(Boolean requiresIndexDocuments) {
            this.requiresIndexDocuments = requiresIndexDocuments;
            return this;
        }

        public final Boolean getProcessing() {
            return processing;
        }

        public final void setProcessing(Boolean processing) {
            this.processing = processing;
        }

        @Override
        public final Builder processing(Boolean processing) {
            this.processing = processing;
            return this;
        }

        public final String getSearchInstanceType() {
            return searchInstanceType;
        }

        public final void setSearchInstanceType(String searchInstanceType) {
            this.searchInstanceType = searchInstanceType;
        }

        @Override
        public final Builder searchInstanceType(String searchInstanceType) {
            this.searchInstanceType = searchInstanceType;
            return this;
        }

        public final Integer getSearchPartitionCount() {
            return searchPartitionCount;
        }

        public final void setSearchPartitionCount(Integer searchPartitionCount) {
            this.searchPartitionCount = searchPartitionCount;
        }

        @Override
        public final Builder searchPartitionCount(Integer searchPartitionCount) {
            this.searchPartitionCount = searchPartitionCount;
            return this;
        }

        public final Integer getSearchInstanceCount() {
            return searchInstanceCount;
        }

        public final void setSearchInstanceCount(Integer searchInstanceCount) {
            this.searchInstanceCount = searchInstanceCount;
        }

        @Override
        public final Builder searchInstanceCount(Integer searchInstanceCount) {
            this.searchInstanceCount = searchInstanceCount;
            return this;
        }

        public final Limits.Builder getLimits() {
            return limits != null ? limits.toBuilder() : null;
        }

        public final void setLimits(Limits.BuilderImpl limits) {
            this.limits = limits != null ? limits.build() : null;
        }

        @Override
        public final Builder limits(Limits limits) {
            this.limits = limits;
            return this;
        }

        @Override
        public DomainStatus build() {
            return new DomainStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
