/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result of an <code>IndexDocuments</code> request. Contains the status of the indexing operation, including the
 * fields being indexed.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IndexDocumentsResponse extends CloudSearchResponse implements
        ToCopyableBuilder<IndexDocumentsResponse.Builder, IndexDocumentsResponse> {
    private static final SdkField<List<String>> FIELD_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("FieldNames")
            .getter(getter(IndexDocumentsResponse::fieldNames))
            .setter(setter(Builder::fieldNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_NAMES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> fieldNames;

    private IndexDocumentsResponse(BuilderImpl builder) {
        super(builder);
        this.fieldNames = builder.fieldNames;
    }

    /**
     * For responses, this returns true if the service returned a value for the FieldNames property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFieldNames() {
        return fieldNames != null && !(fieldNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The names of the fields that are currently being indexed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFieldNames} method.
     * </p>
     * 
     * @return The names of the fields that are currently being indexed.
     */
    public final List<String> fieldNames() {
        return fieldNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFieldNames() ? fieldNames() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IndexDocumentsResponse)) {
            return false;
        }
        IndexDocumentsResponse other = (IndexDocumentsResponse) obj;
        return hasFieldNames() == other.hasFieldNames() && Objects.equals(fieldNames(), other.fieldNames());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IndexDocumentsResponse").add("FieldNames", hasFieldNames() ? fieldNames() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FieldNames":
            return Optional.ofNullable(clazz.cast(fieldNames()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FieldNames", FIELD_NAMES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IndexDocumentsResponse, T> g) {
        return obj -> g.apply((IndexDocumentsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudSearchResponse.Builder, SdkPojo, CopyableBuilder<Builder, IndexDocumentsResponse> {
        /**
         * <p>
         * The names of the fields that are currently being indexed.
         * </p>
         * 
         * @param fieldNames
         *        The names of the fields that are currently being indexed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldNames(Collection<String> fieldNames);

        /**
         * <p>
         * The names of the fields that are currently being indexed.
         * </p>
         * 
         * @param fieldNames
         *        The names of the fields that are currently being indexed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldNames(String... fieldNames);
    }

    static final class BuilderImpl extends CloudSearchResponse.BuilderImpl implements Builder {
        private List<String> fieldNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IndexDocumentsResponse model) {
            super(model);
            fieldNames(model.fieldNames);
        }

        public final Collection<String> getFieldNames() {
            if (fieldNames instanceof SdkAutoConstructList) {
                return null;
            }
            return fieldNames;
        }

        public final void setFieldNames(Collection<String> fieldNames) {
            this.fieldNames = FieldNameListCopier.copy(fieldNames);
        }

        @Override
        public final Builder fieldNames(Collection<String> fieldNames) {
            this.fieldNames = FieldNameListCopier.copy(fieldNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldNames(String... fieldNames) {
            fieldNames(Arrays.asList(fieldNames));
            return this;
        }

        @Override
        public IndexDocumentsResponse build() {
            return new IndexDocumentsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
