/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container for the parameters to the <code><a>UpdateAvailabilityOptions</a></code> operation. Specifies the name of
 * the domain you want to update and the Multi-AZ availability option.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAvailabilityOptionsRequest extends CloudSearchRequest implements
        ToCopyableBuilder<UpdateAvailabilityOptionsRequest.Builder, UpdateAvailabilityOptionsRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(UpdateAvailabilityOptionsRequest::domainName))
            .setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()).build();

    private static final SdkField<Boolean> MULTI_AZ_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("MultiAZ").getter(getter(UpdateAvailabilityOptionsRequest::multiAZ)).setter(setter(Builder::multiAZ))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiAZ").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD,
            MULTI_AZ_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String domainName;

    private final Boolean multiAZ;

    private UpdateAvailabilityOptionsRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.multiAZ = builder.multiAZ;
    }

    /**
     * Returns the value of the DomainName property for this object.
     * 
     * @return The value of the DomainName property for this object.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * You expand an existing search domain to a second Availability Zone by setting the Multi-AZ option to true.
     * Similarly, you can turn off the Multi-AZ option to downgrade the domain to a single Availability Zone by setting
     * the Multi-AZ option to <code>false</code>.
     * </p>
     * 
     * @return You expand an existing search domain to a second Availability Zone by setting the Multi-AZ option to
     *         true. Similarly, you can turn off the Multi-AZ option to downgrade the domain to a single Availability
     *         Zone by setting the Multi-AZ option to <code>false</code>.
     */
    public final Boolean multiAZ() {
        return multiAZ;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(multiAZ());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAvailabilityOptionsRequest)) {
            return false;
        }
        UpdateAvailabilityOptionsRequest other = (UpdateAvailabilityOptionsRequest) obj;
        return Objects.equals(domainName(), other.domainName()) && Objects.equals(multiAZ(), other.multiAZ());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAvailabilityOptionsRequest").add("DomainName", domainName()).add("MultiAZ", multiAZ())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "MultiAZ":
            return Optional.ofNullable(clazz.cast(multiAZ()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("MultiAZ", MULTI_AZ_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAvailabilityOptionsRequest, T> g) {
        return obj -> g.apply((UpdateAvailabilityOptionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudSearchRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateAvailabilityOptionsRequest> {
        /**
         * Sets the value of the DomainName property for this object.
         *
         * @param domainName
         *        The new value for the DomainName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * You expand an existing search domain to a second Availability Zone by setting the Multi-AZ option to true.
         * Similarly, you can turn off the Multi-AZ option to downgrade the domain to a single Availability Zone by
         * setting the Multi-AZ option to <code>false</code>.
         * </p>
         * 
         * @param multiAZ
         *        You expand an existing search domain to a second Availability Zone by setting the Multi-AZ option to
         *        true. Similarly, you can turn off the Multi-AZ option to downgrade the domain to a single Availability
         *        Zone by setting the Multi-AZ option to <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiAZ(Boolean multiAZ);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudSearchRequest.BuilderImpl implements Builder {
        private String domainName;

        private Boolean multiAZ;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAvailabilityOptionsRequest model) {
            super(model);
            domainName(model.domainName);
            multiAZ(model.multiAZ);
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final Boolean getMultiAZ() {
            return multiAZ;
        }

        public final void setMultiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
        }

        @Override
        public final Builder multiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAvailabilityOptionsRequest build() {
            return new UpdateAvailabilityOptionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
