/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudsearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Options for a field that contains an array of text strings. Present if <code>IndexFieldType</code> specifies the
 * field is of type <code>text-array</code>. A <code>text-array</code> field is always searchable. All options are
 * enabled by default.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TextArrayOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<TextArrayOptions.Builder, TextArrayOptions> {
    private static final SdkField<String> DEFAULT_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultValue").getter(getter(TextArrayOptions::defaultValue)).setter(setter(Builder::defaultValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultValue").build()).build();

    private static final SdkField<String> SOURCE_FIELDS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceFields").getter(getter(TextArrayOptions::sourceFields)).setter(setter(Builder::sourceFields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceFields").build()).build();

    private static final SdkField<Boolean> RETURN_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ReturnEnabled").getter(getter(TextArrayOptions::returnEnabled)).setter(setter(Builder::returnEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReturnEnabled").build()).build();

    private static final SdkField<Boolean> HIGHLIGHT_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("HighlightEnabled").getter(getter(TextArrayOptions::highlightEnabled))
            .setter(setter(Builder::highlightEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HighlightEnabled").build()).build();

    private static final SdkField<String> ANALYSIS_SCHEME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AnalysisScheme").getter(getter(TextArrayOptions::analysisScheme))
            .setter(setter(Builder::analysisScheme))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisScheme").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_VALUE_FIELD,
            SOURCE_FIELDS_FIELD, RETURN_ENABLED_FIELD, HIGHLIGHT_ENABLED_FIELD, ANALYSIS_SCHEME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String defaultValue;

    private final String sourceFields;

    private final Boolean returnEnabled;

    private final Boolean highlightEnabled;

    private final String analysisScheme;

    private TextArrayOptions(BuilderImpl builder) {
        this.defaultValue = builder.defaultValue;
        this.sourceFields = builder.sourceFields;
        this.returnEnabled = builder.returnEnabled;
        this.highlightEnabled = builder.highlightEnabled;
        this.analysisScheme = builder.analysisScheme;
    }

    /**
     * A value to use for the field if the field isn't specified for a document.
     * 
     * @return A value to use for the field if the field isn't specified for a document.
     */
    public final String defaultValue() {
        return defaultValue;
    }

    /**
     * <p>
     * A list of source fields to map to the field.
     * </p>
     * 
     * @return A list of source fields to map to the field.
     */
    public final String sourceFields() {
        return sourceFields;
    }

    /**
     * <p>
     * Whether the contents of the field can be returned in the search results.
     * </p>
     * 
     * @return Whether the contents of the field can be returned in the search results.
     */
    public final Boolean returnEnabled() {
        return returnEnabled;
    }

    /**
     * <p>
     * Whether highlights can be returned for the field.
     * </p>
     * 
     * @return Whether highlights can be returned for the field.
     */
    public final Boolean highlightEnabled() {
        return highlightEnabled;
    }

    /**
     * <p>
     * The name of an analysis scheme for a <code>text-array</code> field.
     * </p>
     * 
     * @return The name of an analysis scheme for a <code>text-array</code> field.
     */
    public final String analysisScheme() {
        return analysisScheme;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(defaultValue());
        hashCode = 31 * hashCode + Objects.hashCode(sourceFields());
        hashCode = 31 * hashCode + Objects.hashCode(returnEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(highlightEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(analysisScheme());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TextArrayOptions)) {
            return false;
        }
        TextArrayOptions other = (TextArrayOptions) obj;
        return Objects.equals(defaultValue(), other.defaultValue()) && Objects.equals(sourceFields(), other.sourceFields())
                && Objects.equals(returnEnabled(), other.returnEnabled())
                && Objects.equals(highlightEnabled(), other.highlightEnabled())
                && Objects.equals(analysisScheme(), other.analysisScheme());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TextArrayOptions").add("DefaultValue", defaultValue()).add("SourceFields", sourceFields())
                .add("ReturnEnabled", returnEnabled()).add("HighlightEnabled", highlightEnabled())
                .add("AnalysisScheme", analysisScheme()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DefaultValue":
            return Optional.ofNullable(clazz.cast(defaultValue()));
        case "SourceFields":
            return Optional.ofNullable(clazz.cast(sourceFields()));
        case "ReturnEnabled":
            return Optional.ofNullable(clazz.cast(returnEnabled()));
        case "HighlightEnabled":
            return Optional.ofNullable(clazz.cast(highlightEnabled()));
        case "AnalysisScheme":
            return Optional.ofNullable(clazz.cast(analysisScheme()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DefaultValue", DEFAULT_VALUE_FIELD);
        map.put("SourceFields", SOURCE_FIELDS_FIELD);
        map.put("ReturnEnabled", RETURN_ENABLED_FIELD);
        map.put("HighlightEnabled", HIGHLIGHT_ENABLED_FIELD);
        map.put("AnalysisScheme", ANALYSIS_SCHEME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TextArrayOptions, T> g) {
        return obj -> g.apply((TextArrayOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TextArrayOptions> {
        /**
         * A value to use for the field if the field isn't specified for a document.
         * 
         * @param defaultValue
         *        A value to use for the field if the field isn't specified for a document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultValue(String defaultValue);

        /**
         * <p>
         * A list of source fields to map to the field.
         * </p>
         * 
         * @param sourceFields
         *        A list of source fields to map to the field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceFields(String sourceFields);

        /**
         * <p>
         * Whether the contents of the field can be returned in the search results.
         * </p>
         * 
         * @param returnEnabled
         *        Whether the contents of the field can be returned in the search results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder returnEnabled(Boolean returnEnabled);

        /**
         * <p>
         * Whether highlights can be returned for the field.
         * </p>
         * 
         * @param highlightEnabled
         *        Whether highlights can be returned for the field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder highlightEnabled(Boolean highlightEnabled);

        /**
         * <p>
         * The name of an analysis scheme for a <code>text-array</code> field.
         * </p>
         * 
         * @param analysisScheme
         *        The name of an analysis scheme for a <code>text-array</code> field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analysisScheme(String analysisScheme);
    }

    static final class BuilderImpl implements Builder {
        private String defaultValue;

        private String sourceFields;

        private Boolean returnEnabled;

        private Boolean highlightEnabled;

        private String analysisScheme;

        private BuilderImpl() {
        }

        private BuilderImpl(TextArrayOptions model) {
            defaultValue(model.defaultValue);
            sourceFields(model.sourceFields);
            returnEnabled(model.returnEnabled);
            highlightEnabled(model.highlightEnabled);
            analysisScheme(model.analysisScheme);
        }

        public final String getDefaultValue() {
            return defaultValue;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final String getSourceFields() {
            return sourceFields;
        }

        public final void setSourceFields(String sourceFields) {
            this.sourceFields = sourceFields;
        }

        @Override
        public final Builder sourceFields(String sourceFields) {
            this.sourceFields = sourceFields;
            return this;
        }

        public final Boolean getReturnEnabled() {
            return returnEnabled;
        }

        public final void setReturnEnabled(Boolean returnEnabled) {
            this.returnEnabled = returnEnabled;
        }

        @Override
        public final Builder returnEnabled(Boolean returnEnabled) {
            this.returnEnabled = returnEnabled;
            return this;
        }

        public final Boolean getHighlightEnabled() {
            return highlightEnabled;
        }

        public final void setHighlightEnabled(Boolean highlightEnabled) {
            this.highlightEnabled = highlightEnabled;
        }

        @Override
        public final Builder highlightEnabled(Boolean highlightEnabled) {
            this.highlightEnabled = highlightEnabled;
            return this;
        }

        public final String getAnalysisScheme() {
            return analysisScheme;
        }

        public final void setAnalysisScheme(String analysisScheme) {
            this.analysisScheme = analysisScheme;
        }

        @Override
        public final Builder analysisScheme(String analysisScheme) {
            this.analysisScheme = analysisScheme;
            return this;
        }

        @Override
        public TextArrayOptions build() {
            return new TextArrayOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
