/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container for the parameters to the <code><a>UpdateScalingParameters</a></code> operation. Specifies the name of the
 * domain you want to update and the scaling parameters you want to configure.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateScalingParametersRequest extends CloudSearchRequest implements
        ToCopyableBuilder<UpdateScalingParametersRequest.Builder, UpdateScalingParametersRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(UpdateScalingParametersRequest::domainName))
            .setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()).build();

    private static final SdkField<ScalingParameters> SCALING_PARAMETERS_FIELD = SdkField
            .<ScalingParameters> builder(MarshallingType.SDK_POJO).memberName("ScalingParameters")
            .getter(getter(UpdateScalingParametersRequest::scalingParameters)).setter(setter(Builder::scalingParameters))
            .constructor(ScalingParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingParameters").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD,
            SCALING_PARAMETERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String domainName;

    private final ScalingParameters scalingParameters;

    private UpdateScalingParametersRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.scalingParameters = builder.scalingParameters;
    }

    /**
     * Returns the value of the DomainName property for this object.
     * 
     * @return The value of the DomainName property for this object.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * Returns the value of the ScalingParameters property for this object.
     * 
     * @return The value of the ScalingParameters property for this object.
     */
    public final ScalingParameters scalingParameters() {
        return scalingParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(scalingParameters());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateScalingParametersRequest)) {
            return false;
        }
        UpdateScalingParametersRequest other = (UpdateScalingParametersRequest) obj;
        return Objects.equals(domainName(), other.domainName()) && Objects.equals(scalingParameters(), other.scalingParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateScalingParametersRequest").add("DomainName", domainName())
                .add("ScalingParameters", scalingParameters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "ScalingParameters":
            return Optional.ofNullable(clazz.cast(scalingParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("ScalingParameters", SCALING_PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateScalingParametersRequest, T> g) {
        return obj -> g.apply((UpdateScalingParametersRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudSearchRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateScalingParametersRequest> {
        /**
         * Sets the value of the DomainName property for this object.
         *
         * @param domainName
         *        The new value for the DomainName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * Sets the value of the ScalingParameters property for this object.
         *
         * @param scalingParameters
         *        The new value for the ScalingParameters property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalingParameters(ScalingParameters scalingParameters);

        /**
         * Sets the value of the ScalingParameters property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ScalingParameters.Builder} avoiding the
         * need to create one manually via {@link ScalingParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScalingParameters.Builder#build()} is called immediately and its
         * result is passed to {@link #scalingParameters(ScalingParameters)}.
         * 
         * @param scalingParameters
         *        a consumer that will call methods on {@link ScalingParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scalingParameters(ScalingParameters)
         */
        default Builder scalingParameters(Consumer<ScalingParameters.Builder> scalingParameters) {
            return scalingParameters(ScalingParameters.builder().applyMutation(scalingParameters).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudSearchRequest.BuilderImpl implements Builder {
        private String domainName;

        private ScalingParameters scalingParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateScalingParametersRequest model) {
            super(model);
            domainName(model.domainName);
            scalingParameters(model.scalingParameters);
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final ScalingParameters.Builder getScalingParameters() {
            return scalingParameters != null ? scalingParameters.toBuilder() : null;
        }

        public final void setScalingParameters(ScalingParameters.BuilderImpl scalingParameters) {
            this.scalingParameters = scalingParameters != null ? scalingParameters.build() : null;
        }

        @Override
        public final Builder scalingParameters(ScalingParameters scalingParameters) {
            this.scalingParameters = scalingParameters;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateScalingParametersRequest build() {
            return new UpdateScalingParametersRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
