/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result of a <code>DeleteAnalysisScheme</code> request. Contains the status of the deleted analysis scheme.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteAnalysisSchemeResponse extends CloudSearchResponse implements
        ToCopyableBuilder<DeleteAnalysisSchemeResponse.Builder, DeleteAnalysisSchemeResponse> {
    private static final SdkField<AnalysisSchemeStatus> ANALYSIS_SCHEME_FIELD = SdkField
            .<AnalysisSchemeStatus> builder(MarshallingType.SDK_POJO).memberName("AnalysisScheme")
            .getter(getter(DeleteAnalysisSchemeResponse::analysisScheme)).setter(setter(Builder::analysisScheme))
            .constructor(AnalysisSchemeStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisScheme").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANALYSIS_SCHEME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final AnalysisSchemeStatus analysisScheme;

    private DeleteAnalysisSchemeResponse(BuilderImpl builder) {
        super(builder);
        this.analysisScheme = builder.analysisScheme;
    }

    /**
     * <p>
     * The status of the analysis scheme being deleted.
     * </p>
     * 
     * @return The status of the analysis scheme being deleted.
     */
    public final AnalysisSchemeStatus analysisScheme() {
        return analysisScheme;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(analysisScheme());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAnalysisSchemeResponse)) {
            return false;
        }
        DeleteAnalysisSchemeResponse other = (DeleteAnalysisSchemeResponse) obj;
        return Objects.equals(analysisScheme(), other.analysisScheme());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteAnalysisSchemeResponse").add("AnalysisScheme", analysisScheme()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AnalysisScheme":
            return Optional.ofNullable(clazz.cast(analysisScheme()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AnalysisScheme", ANALYSIS_SCHEME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteAnalysisSchemeResponse, T> g) {
        return obj -> g.apply((DeleteAnalysisSchemeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudSearchResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeleteAnalysisSchemeResponse> {
        /**
         * <p>
         * The status of the analysis scheme being deleted.
         * </p>
         * 
         * @param analysisScheme
         *        The status of the analysis scheme being deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analysisScheme(AnalysisSchemeStatus analysisScheme);

        /**
         * <p>
         * The status of the analysis scheme being deleted.
         * </p>
         * This is a convenience method that creates an instance of the {@link AnalysisSchemeStatus.Builder} avoiding
         * the need to create one manually via {@link AnalysisSchemeStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AnalysisSchemeStatus.Builder#build()} is called immediately and
         * its result is passed to {@link #analysisScheme(AnalysisSchemeStatus)}.
         * 
         * @param analysisScheme
         *        a consumer that will call methods on {@link AnalysisSchemeStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #analysisScheme(AnalysisSchemeStatus)
         */
        default Builder analysisScheme(Consumer<AnalysisSchemeStatus.Builder> analysisScheme) {
            return analysisScheme(AnalysisSchemeStatus.builder().applyMutation(analysisScheme).build());
        }
    }

    static final class BuilderImpl extends CloudSearchResponse.BuilderImpl implements Builder {
        private AnalysisSchemeStatus analysisScheme;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAnalysisSchemeResponse model) {
            super(model);
            analysisScheme(model.analysisScheme);
        }

        public final AnalysisSchemeStatus.Builder getAnalysisScheme() {
            return analysisScheme != null ? analysisScheme.toBuilder() : null;
        }

        public final void setAnalysisScheme(AnalysisSchemeStatus.BuilderImpl analysisScheme) {
            this.analysisScheme = analysisScheme != null ? analysisScheme.build() : null;
        }

        @Override
        public final Builder analysisScheme(AnalysisSchemeStatus analysisScheme) {
            this.analysisScheme = analysisScheme;
            return this;
        }

        @Override
        public DeleteAnalysisSchemeResponse build() {
            return new DeleteAnalysisSchemeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
