/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudsearchdomain.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container for the suggestion information returned in a <code>SuggestResponse</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SuggestModel implements SdkPojo, Serializable, ToCopyableBuilder<SuggestModel.Builder, SuggestModel> {
    private static final SdkField<String> QUERY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("query")
            .getter(getter(SuggestModel::query)).setter(setter(Builder::query))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("query").build()).build();

    private static final SdkField<Long> FOUND_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("found")
            .getter(getter(SuggestModel::found)).setter(setter(Builder::found))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("found").build()).build();

    private static final SdkField<List<SuggestionMatch>> SUGGESTIONS_FIELD = SdkField
            .<List<SuggestionMatch>> builder(MarshallingType.LIST)
            .memberName("suggestions")
            .getter(getter(SuggestModel::suggestions))
            .setter(setter(Builder::suggestions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suggestions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SuggestionMatch> builder(MarshallingType.SDK_POJO)
                                            .constructor(SuggestionMatch::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_FIELD, FOUND_FIELD,
            SUGGESTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String query;

    private final Long found;

    private final List<SuggestionMatch> suggestions;

    private SuggestModel(BuilderImpl builder) {
        this.query = builder.query;
        this.found = builder.found;
        this.suggestions = builder.suggestions;
    }

    /**
     * <p>
     * The query string specified in the suggest request.
     * </p>
     * 
     * @return The query string specified in the suggest request.
     */
    public final String query() {
        return query;
    }

    /**
     * <p>
     * The number of documents that were found to match the query string.
     * </p>
     * 
     * @return The number of documents that were found to match the query string.
     */
    public final Long found() {
        return found;
    }

    /**
     * For responses, this returns true if the service returned a value for the Suggestions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSuggestions() {
        return suggestions != null && !(suggestions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The documents that match the query string.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSuggestions} method.
     * </p>
     * 
     * @return The documents that match the query string.
     */
    public final List<SuggestionMatch> suggestions() {
        return suggestions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(query());
        hashCode = 31 * hashCode + Objects.hashCode(found());
        hashCode = 31 * hashCode + Objects.hashCode(hasSuggestions() ? suggestions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SuggestModel)) {
            return false;
        }
        SuggestModel other = (SuggestModel) obj;
        return Objects.equals(query(), other.query()) && Objects.equals(found(), other.found())
                && hasSuggestions() == other.hasSuggestions() && Objects.equals(suggestions(), other.suggestions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SuggestModel").add("Query", query()).add("Found", found())
                .add("Suggestions", hasSuggestions() ? suggestions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "query":
            return Optional.ofNullable(clazz.cast(query()));
        case "found":
            return Optional.ofNullable(clazz.cast(found()));
        case "suggestions":
            return Optional.ofNullable(clazz.cast(suggestions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SuggestModel, T> g) {
        return obj -> g.apply((SuggestModel) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SuggestModel> {
        /**
         * <p>
         * The query string specified in the suggest request.
         * </p>
         * 
         * @param query
         *        The query string specified in the suggest request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder query(String query);

        /**
         * <p>
         * The number of documents that were found to match the query string.
         * </p>
         * 
         * @param found
         *        The number of documents that were found to match the query string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder found(Long found);

        /**
         * <p>
         * The documents that match the query string.
         * </p>
         * 
         * @param suggestions
         *        The documents that match the query string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suggestions(Collection<SuggestionMatch> suggestions);

        /**
         * <p>
         * The documents that match the query string.
         * </p>
         * 
         * @param suggestions
         *        The documents that match the query string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suggestions(SuggestionMatch... suggestions);

        /**
         * <p>
         * The documents that match the query string.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SuggestionMatch>.Builder} avoiding the need
         * to create one manually via {@link List<SuggestionMatch>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SuggestionMatch>.Builder#build()} is called immediately and
         * its result is passed to {@link #suggestions(List<SuggestionMatch>)}.
         * 
         * @param suggestions
         *        a consumer that will call methods on {@link List<SuggestionMatch>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #suggestions(List<SuggestionMatch>)
         */
        Builder suggestions(Consumer<SuggestionMatch.Builder>... suggestions);
    }

    static final class BuilderImpl implements Builder {
        private String query;

        private Long found;

        private List<SuggestionMatch> suggestions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SuggestModel model) {
            query(model.query);
            found(model.found);
            suggestions(model.suggestions);
        }

        public final String getQuery() {
            return query;
        }

        public final void setQuery(String query) {
            this.query = query;
        }

        @Override
        @Transient
        public final Builder query(String query) {
            this.query = query;
            return this;
        }

        public final Long getFound() {
            return found;
        }

        public final void setFound(Long found) {
            this.found = found;
        }

        @Override
        @Transient
        public final Builder found(Long found) {
            this.found = found;
            return this;
        }

        public final List<SuggestionMatch.Builder> getSuggestions() {
            List<SuggestionMatch.Builder> result = SuggestionsCopier.copyToBuilder(this.suggestions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSuggestions(Collection<SuggestionMatch.BuilderImpl> suggestions) {
            this.suggestions = SuggestionsCopier.copyFromBuilder(suggestions);
        }

        @Override
        @Transient
        public final Builder suggestions(Collection<SuggestionMatch> suggestions) {
            this.suggestions = SuggestionsCopier.copy(suggestions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder suggestions(SuggestionMatch... suggestions) {
            suggestions(Arrays.asList(suggestions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder suggestions(Consumer<SuggestionMatch.Builder>... suggestions) {
            suggestions(Stream.of(suggestions).map(c -> SuggestionMatch.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public SuggestModel build() {
            return new SuggestModel(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
