/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudsearchdomain.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container for the parameters to the <code>Suggest</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SuggestRequest extends CloudSearchDomainRequest implements
        ToCopyableBuilder<SuggestRequest.Builder, SuggestRequest> {
    private static final SdkField<String> QUERY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("query")
            .getter(getter(SuggestRequest::query)).setter(setter(Builder::query))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("q").build()).build();

    private static final SdkField<String> SUGGESTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("suggester").getter(getter(SuggestRequest::suggester)).setter(setter(Builder::suggester))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("suggester").build()).build();

    private static final SdkField<Long> SIZE_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("size")
            .getter(getter(SuggestRequest::size)).setter(setter(Builder::size))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("size").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_FIELD, SUGGESTER_FIELD,
            SIZE_FIELD));

    private final String query;

    private final String suggester;

    private final Long size;

    private SuggestRequest(BuilderImpl builder) {
        super(builder);
        this.query = builder.query;
        this.suggester = builder.suggester;
        this.size = builder.size;
    }

    /**
     * <p>
     * Specifies the string for which you want to get suggestions.
     * </p>
     * 
     * @return Specifies the string for which you want to get suggestions.
     */
    public final String query() {
        return query;
    }

    /**
     * <p>
     * Specifies the name of the suggester to use to find suggested matches.
     * </p>
     * 
     * @return Specifies the name of the suggester to use to find suggested matches.
     */
    public final String suggester() {
        return suggester;
    }

    /**
     * <p>
     * Specifies the maximum number of suggestions to return.
     * </p>
     * 
     * @return Specifies the maximum number of suggestions to return.
     */
    public final Long size() {
        return size;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(query());
        hashCode = 31 * hashCode + Objects.hashCode(suggester());
        hashCode = 31 * hashCode + Objects.hashCode(size());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SuggestRequest)) {
            return false;
        }
        SuggestRequest other = (SuggestRequest) obj;
        return Objects.equals(query(), other.query()) && Objects.equals(suggester(), other.suggester())
                && Objects.equals(size(), other.size());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SuggestRequest").add("Query", query()).add("Suggester", suggester()).add("Size", size()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "query":
            return Optional.ofNullable(clazz.cast(query()));
        case "suggester":
            return Optional.ofNullable(clazz.cast(suggester()));
        case "size":
            return Optional.ofNullable(clazz.cast(size()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SuggestRequest, T> g) {
        return obj -> g.apply((SuggestRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudSearchDomainRequest.Builder, SdkPojo, CopyableBuilder<Builder, SuggestRequest> {
        /**
         * <p>
         * Specifies the string for which you want to get suggestions.
         * </p>
         * 
         * @param query
         *        Specifies the string for which you want to get suggestions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder query(String query);

        /**
         * <p>
         * Specifies the name of the suggester to use to find suggested matches.
         * </p>
         * 
         * @param suggester
         *        Specifies the name of the suggester to use to find suggested matches.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suggester(String suggester);

        /**
         * <p>
         * Specifies the maximum number of suggestions to return.
         * </p>
         * 
         * @param size
         *        Specifies the maximum number of suggestions to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder size(Long size);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudSearchDomainRequest.BuilderImpl implements Builder {
        private String query;

        private String suggester;

        private Long size;

        private BuilderImpl() {
        }

        private BuilderImpl(SuggestRequest model) {
            super(model);
            query(model.query);
            suggester(model.suggester);
            size(model.size);
        }

        public final String getQuery() {
            return query;
        }

        public final void setQuery(String query) {
            this.query = query;
        }

        @Override
        @Transient
        public final Builder query(String query) {
            this.query = query;
            return this;
        }

        public final String getSuggester() {
            return suggester;
        }

        public final void setSuggester(String suggester) {
            this.suggester = suggester;
        }

        @Override
        @Transient
        public final Builder suggester(String suggester) {
            this.suggester = suggester;
            return this;
        }

        public final Long getSize() {
            return size;
        }

        public final void setSize(Long size) {
            this.size = size;
        }

        @Override
        @Transient
        public final Builder size(Long size) {
            this.size = size;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SuggestRequest build() {
            return new SuggestRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
