/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudsearchdomain.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a <code>Suggest</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SuggestResponse extends CloudSearchDomainResponse implements
        ToCopyableBuilder<SuggestResponse.Builder, SuggestResponse> {
    private static final SdkField<SuggestStatus> STATUS_FIELD = SdkField.<SuggestStatus> builder(MarshallingType.SDK_POJO)
            .memberName("status").getter(getter(SuggestResponse::status)).setter(setter(Builder::status))
            .constructor(SuggestStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<SuggestModel> SUGGEST_FIELD = SdkField.<SuggestModel> builder(MarshallingType.SDK_POJO)
            .memberName("suggest").getter(getter(SuggestResponse::suggest)).setter(setter(Builder::suggest))
            .constructor(SuggestModel::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suggest").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, SUGGEST_FIELD));

    private final SuggestStatus status;

    private final SuggestModel suggest;

    private SuggestResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.suggest = builder.suggest;
    }

    /**
     * <p>
     * The status of a <code>SuggestRequest</code>. Contains the resource ID (<code>rid</code>) and how long it took to
     * process the request (<code>timems</code>).
     * </p>
     * 
     * @return The status of a <code>SuggestRequest</code>. Contains the resource ID (<code>rid</code>) and how long it
     *         took to process the request (<code>timems</code>).
     */
    public final SuggestStatus status() {
        return status;
    }

    /**
     * <p>
     * Container for the matching search suggestion information.
     * </p>
     * 
     * @return Container for the matching search suggestion information.
     */
    public final SuggestModel suggest() {
        return suggest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(suggest());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SuggestResponse)) {
            return false;
        }
        SuggestResponse other = (SuggestResponse) obj;
        return Objects.equals(status(), other.status()) && Objects.equals(suggest(), other.suggest());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SuggestResponse").add("Status", status()).add("Suggest", suggest()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "suggest":
            return Optional.ofNullable(clazz.cast(suggest()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SuggestResponse, T> g) {
        return obj -> g.apply((SuggestResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudSearchDomainResponse.Builder, SdkPojo, CopyableBuilder<Builder, SuggestResponse> {
        /**
         * <p>
         * The status of a <code>SuggestRequest</code>. Contains the resource ID (<code>rid</code>) and how long it took
         * to process the request (<code>timems</code>).
         * </p>
         * 
         * @param status
         *        The status of a <code>SuggestRequest</code>. Contains the resource ID (<code>rid</code>) and how long
         *        it took to process the request (<code>timems</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(SuggestStatus status);

        /**
         * <p>
         * The status of a <code>SuggestRequest</code>. Contains the resource ID (<code>rid</code>) and how long it took
         * to process the request (<code>timems</code>).
         * </p>
         * This is a convenience that creates an instance of the {@link SuggestStatus.Builder} avoiding the need to
         * create one manually via {@link SuggestStatus#builder()}.
         *
         * When the {@link Consumer} completes, {@link SuggestStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #status(SuggestStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link SuggestStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(SuggestStatus)
         */
        default Builder status(Consumer<SuggestStatus.Builder> status) {
            return status(SuggestStatus.builder().applyMutation(status).build());
        }

        /**
         * <p>
         * Container for the matching search suggestion information.
         * </p>
         * 
         * @param suggest
         *        Container for the matching search suggestion information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suggest(SuggestModel suggest);

        /**
         * <p>
         * Container for the matching search suggestion information.
         * </p>
         * This is a convenience that creates an instance of the {@link SuggestModel.Builder} avoiding the need to
         * create one manually via {@link SuggestModel#builder()}.
         *
         * When the {@link Consumer} completes, {@link SuggestModel.Builder#build()} is called immediately and its
         * result is passed to {@link #suggest(SuggestModel)}.
         * 
         * @param suggest
         *        a consumer that will call methods on {@link SuggestModel.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #suggest(SuggestModel)
         */
        default Builder suggest(Consumer<SuggestModel.Builder> suggest) {
            return suggest(SuggestModel.builder().applyMutation(suggest).build());
        }
    }

    static final class BuilderImpl extends CloudSearchDomainResponse.BuilderImpl implements Builder {
        private SuggestStatus status;

        private SuggestModel suggest;

        private BuilderImpl() {
        }

        private BuilderImpl(SuggestResponse model) {
            super(model);
            status(model.status);
            suggest(model.suggest);
        }

        public final SuggestStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        public final void setStatus(SuggestStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        @Transient
        public final Builder status(SuggestStatus status) {
            this.status = status;
            return this;
        }

        public final SuggestModel.Builder getSuggest() {
            return suggest != null ? suggest.toBuilder() : null;
        }

        public final void setSuggest(SuggestModel.BuilderImpl suggest) {
            this.suggest = suggest != null ? suggest.build() : null;
        }

        @Override
        @Transient
        public final Builder suggest(SuggestModel suggest) {
            this.suggest = suggest;
            return this;
        }

        @Override
        public SuggestResponse build() {
            return new SuggestResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
