/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudsearchdomain.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container for the parameters to the <code>UploadDocuments</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UploadDocumentsRequest extends CloudSearchDomainRequest implements
        ToCopyableBuilder<UploadDocumentsRequest.Builder, UploadDocumentsRequest> {
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("contentType").getter(getter(UploadDocumentsRequest::contentTypeAsString))
            .setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Type").build()).build();

    private static final SdkField<Long> CONTENT_LENGTH_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ContentLength").getter(getter(UploadDocumentsRequest::contentLength))
            .setter(setter(Builder::contentLength))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Length").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_TYPE_FIELD,
            CONTENT_LENGTH_FIELD));

    private final String contentType;

    private final Long contentLength;

    private UploadDocumentsRequest(BuilderImpl builder) {
        super(builder);
        this.contentType = builder.contentType;
        this.contentLength = builder.contentLength;
    }

    /**
     * <p>
     * The format of the batch you are uploading. Amazon CloudSearch supports two document batch formats:
     * </p>
     * <ul>
     * <li>application/json</li>
     * <li>application/xml</li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #contentType} will
     * return {@link ContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #contentTypeAsString}.
     * </p>
     * 
     * @return The format of the batch you are uploading. Amazon CloudSearch supports two document batch formats:</p>
     *         <ul>
     *         <li>application/json</li>
     *         <li>application/xml</li>
     * @see ContentType
     */
    public final ContentType contentType() {
        return ContentType.fromValue(contentType);
    }

    /**
     * <p>
     * The format of the batch you are uploading. Amazon CloudSearch supports two document batch formats:
     * </p>
     * <ul>
     * <li>application/json</li>
     * <li>application/xml</li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #contentType} will
     * return {@link ContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #contentTypeAsString}.
     * </p>
     * 
     * @return The format of the batch you are uploading. Amazon CloudSearch supports two document batch formats:</p>
     *         <ul>
     *         <li>application/json</li>
     *         <li>application/xml</li>
     * @see ContentType
     */
    public final String contentTypeAsString() {
        return contentType;
    }

    /**
     * Returns the value of the ContentLength property for this object.
     * 
     * @return The value of the ContentLength property for this object.
     */
    public final Long contentLength() {
        return contentLength;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(contentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(contentLength());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UploadDocumentsRequest)) {
            return false;
        }
        UploadDocumentsRequest other = (UploadDocumentsRequest) obj;
        return Objects.equals(contentTypeAsString(), other.contentTypeAsString())
                && Objects.equals(contentLength(), other.contentLength());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UploadDocumentsRequest").add("ContentType", contentTypeAsString())
                .add("ContentLength", contentLength()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "contentType":
            return Optional.ofNullable(clazz.cast(contentTypeAsString()));
        case "ContentLength":
            return Optional.ofNullable(clazz.cast(contentLength()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UploadDocumentsRequest, T> g) {
        return obj -> g.apply((UploadDocumentsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudSearchDomainRequest.Builder, SdkPojo, CopyableBuilder<Builder, UploadDocumentsRequest> {
        /**
         * <p>
         * The format of the batch you are uploading. Amazon CloudSearch supports two document batch formats:
         * </p>
         * <ul>
         * <li>application/json</li>
         * <li>application/xml</li>
         * </ul>
         * 
         * @param contentType
         *        The format of the batch you are uploading. Amazon CloudSearch supports two document batch formats:</p>
         *        <ul>
         *        <li>application/json</li>
         *        <li>application/xml</li>
         * @see ContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContentType
         */
        Builder contentType(String contentType);

        /**
         * <p>
         * The format of the batch you are uploading. Amazon CloudSearch supports two document batch formats:
         * </p>
         * <ul>
         * <li>application/json</li>
         * <li>application/xml</li>
         * </ul>
         * 
         * @param contentType
         *        The format of the batch you are uploading. Amazon CloudSearch supports two document batch formats:</p>
         *        <ul>
         *        <li>application/json</li>
         *        <li>application/xml</li>
         * @see ContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContentType
         */
        Builder contentType(ContentType contentType);

        /**
         * Sets the value of the ContentLength property for this object.
         *
         * @param contentLength
         *        The new value for the ContentLength property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentLength(Long contentLength);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudSearchDomainRequest.BuilderImpl implements Builder {
        private String contentType;

        private Long contentLength;

        private BuilderImpl() {
        }

        private BuilderImpl(UploadDocumentsRequest model) {
            super(model);
            contentType(model.contentType);
            contentLength(model.contentLength);
        }

        public final String getContentType() {
            return contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        @Transient
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        @Override
        @Transient
        public final Builder contentType(ContentType contentType) {
            this.contentType(contentType == null ? null : contentType.toString());
            return this;
        }

        public final Long getContentLength() {
            return contentLength;
        }

        public final void setContentLength(Long contentLength) {
            this.contentLength = contentLength;
        }

        @Override
        @Transient
        public final Builder contentLength(Long contentLength) {
            this.contentLength = contentLength;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UploadDocumentsRequest build() {
            return new UploadDocumentsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
