/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearchdomain.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum QueryParser {
    SIMPLE("simple"),
    STRUCTURED("structured"),
    LUCENE("lucene"),
    DISMAX("dismax"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, QueryParser> VALUE_MAP;
    private final String value;

    private QueryParser(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static QueryParser fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<QueryParser> knownValues() {
        EnumSet<QueryParser> knownValues = EnumSet.allOf(QueryParser.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(QueryParser.class, QueryParser::toString);
    }
}

