/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudsearchdomain.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to an <code>UploadDocuments</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UploadDocumentsResponse extends CloudSearchDomainResponse implements
        ToCopyableBuilder<UploadDocumentsResponse.Builder, UploadDocumentsResponse> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(UploadDocumentsResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Long> ADDS_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("adds")
            .getter(getter(UploadDocumentsResponse::adds)).setter(setter(Builder::adds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adds").build()).build();

    private static final SdkField<Long> DELETES_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("deletes")
            .getter(getter(UploadDocumentsResponse::deletes)).setter(setter(Builder::deletes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deletes").build()).build();

    private static final SdkField<List<DocumentServiceWarning>> WARNINGS_FIELD = SdkField
            .<List<DocumentServiceWarning>> builder(MarshallingType.LIST)
            .memberName("warnings")
            .getter(getter(UploadDocumentsResponse::warnings))
            .setter(setter(Builder::warnings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("warnings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DocumentServiceWarning> builder(MarshallingType.SDK_POJO)
                                            .constructor(DocumentServiceWarning::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, ADDS_FIELD,
            DELETES_FIELD, WARNINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String status;

    private final Long adds;

    private final Long deletes;

    private final List<DocumentServiceWarning> warnings;

    private UploadDocumentsResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.adds = builder.adds;
        this.deletes = builder.deletes;
        this.warnings = builder.warnings;
    }

    /**
     * <p>
     * The status of an <code>UploadDocumentsRequest</code>.
     * </p>
     * 
     * @return The status of an <code>UploadDocumentsRequest</code>.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The number of documents that were added to the search domain.
     * </p>
     * 
     * @return The number of documents that were added to the search domain.
     */
    public final Long adds() {
        return adds;
    }

    /**
     * <p>
     * The number of documents that were deleted from the search domain.
     * </p>
     * 
     * @return The number of documents that were deleted from the search domain.
     */
    public final Long deletes() {
        return deletes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Warnings property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasWarnings() {
        return warnings != null && !(warnings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any warnings returned by the document service about the documents being uploaded.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWarnings} method.
     * </p>
     * 
     * @return Any warnings returned by the document service about the documents being uploaded.
     */
    public final List<DocumentServiceWarning> warnings() {
        return warnings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(adds());
        hashCode = 31 * hashCode + Objects.hashCode(deletes());
        hashCode = 31 * hashCode + Objects.hashCode(hasWarnings() ? warnings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UploadDocumentsResponse)) {
            return false;
        }
        UploadDocumentsResponse other = (UploadDocumentsResponse) obj;
        return Objects.equals(status(), other.status()) && Objects.equals(adds(), other.adds())
                && Objects.equals(deletes(), other.deletes()) && hasWarnings() == other.hasWarnings()
                && Objects.equals(warnings(), other.warnings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UploadDocumentsResponse").add("Status", status()).add("Adds", adds()).add("Deletes", deletes())
                .add("Warnings", hasWarnings() ? warnings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "adds":
            return Optional.ofNullable(clazz.cast(adds()));
        case "deletes":
            return Optional.ofNullable(clazz.cast(deletes()));
        case "warnings":
            return Optional.ofNullable(clazz.cast(warnings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("status", STATUS_FIELD);
        map.put("adds", ADDS_FIELD);
        map.put("deletes", DELETES_FIELD);
        map.put("warnings", WARNINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UploadDocumentsResponse, T> g) {
        return obj -> g.apply((UploadDocumentsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudSearchDomainResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UploadDocumentsResponse> {
        /**
         * <p>
         * The status of an <code>UploadDocumentsRequest</code>.
         * </p>
         * 
         * @param status
         *        The status of an <code>UploadDocumentsRequest</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The number of documents that were added to the search domain.
         * </p>
         * 
         * @param adds
         *        The number of documents that were added to the search domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adds(Long adds);

        /**
         * <p>
         * The number of documents that were deleted from the search domain.
         * </p>
         * 
         * @param deletes
         *        The number of documents that were deleted from the search domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletes(Long deletes);

        /**
         * <p>
         * Any warnings returned by the document service about the documents being uploaded.
         * </p>
         * 
         * @param warnings
         *        Any warnings returned by the document service about the documents being uploaded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warnings(Collection<DocumentServiceWarning> warnings);

        /**
         * <p>
         * Any warnings returned by the document service about the documents being uploaded.
         * </p>
         * 
         * @param warnings
         *        Any warnings returned by the document service about the documents being uploaded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warnings(DocumentServiceWarning... warnings);

        /**
         * <p>
         * Any warnings returned by the document service about the documents being uploaded.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudsearchdomain.model.DocumentServiceWarning.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.cloudsearchdomain.model.DocumentServiceWarning#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudsearchdomain.model.DocumentServiceWarning.Builder#build()} is
         * called immediately and its result is passed to {@link #warnings(List<DocumentServiceWarning>)}.
         * 
         * @param warnings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudsearchdomain.model.DocumentServiceWarning.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #warnings(java.util.Collection<DocumentServiceWarning>)
         */
        Builder warnings(Consumer<DocumentServiceWarning.Builder>... warnings);
    }

    static final class BuilderImpl extends CloudSearchDomainResponse.BuilderImpl implements Builder {
        private String status;

        private Long adds;

        private Long deletes;

        private List<DocumentServiceWarning> warnings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UploadDocumentsResponse model) {
            super(model);
            status(model.status);
            adds(model.adds);
            deletes(model.deletes);
            warnings(model.warnings);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Long getAdds() {
            return adds;
        }

        public final void setAdds(Long adds) {
            this.adds = adds;
        }

        @Override
        public final Builder adds(Long adds) {
            this.adds = adds;
            return this;
        }

        public final Long getDeletes() {
            return deletes;
        }

        public final void setDeletes(Long deletes) {
            this.deletes = deletes;
        }

        @Override
        public final Builder deletes(Long deletes) {
            this.deletes = deletes;
            return this;
        }

        public final List<DocumentServiceWarning.Builder> getWarnings() {
            List<DocumentServiceWarning.Builder> result = DocumentServiceWarningsCopier.copyToBuilder(this.warnings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWarnings(Collection<DocumentServiceWarning.BuilderImpl> warnings) {
            this.warnings = DocumentServiceWarningsCopier.copyFromBuilder(warnings);
        }

        @Override
        public final Builder warnings(Collection<DocumentServiceWarning> warnings) {
            this.warnings = DocumentServiceWarningsCopier.copy(warnings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder warnings(DocumentServiceWarning... warnings) {
            warnings(Arrays.asList(warnings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder warnings(Consumer<DocumentServiceWarning.Builder>... warnings) {
            warnings(Stream.of(warnings).map(c -> DocumentServiceWarning.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public UploadDocumentsResponse build() {
            return new UploadDocumentsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
