/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudtrail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutEventSelectorsResponse extends CloudTrailResponse implements
        ToCopyableBuilder<PutEventSelectorsResponse.Builder, PutEventSelectorsResponse> {
    private static final SdkField<String> TRAIL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutEventSelectorsResponse::trailARN)).setter(setter(Builder::trailARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrailARN").build()).build();

    private static final SdkField<List<EventSelector>> EVENT_SELECTORS_FIELD = SdkField
            .<List<EventSelector>> builder(MarshallingType.LIST)
            .getter(getter(PutEventSelectorsResponse::eventSelectors))
            .setter(setter(Builder::eventSelectors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventSelectors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EventSelector> builder(MarshallingType.SDK_POJO)
                                            .constructor(EventSelector::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAIL_ARN_FIELD,
            EVENT_SELECTORS_FIELD));

    private final String trailARN;

    private final List<EventSelector> eventSelectors;

    private PutEventSelectorsResponse(BuilderImpl builder) {
        super(builder);
        this.trailARN = builder.trailARN;
        this.eventSelectors = builder.eventSelectors;
    }

    /**
     * <p>
     * Specifies the ARN of the trail that was updated with event selectors. The format of a trail ARN is:
     * </p>
     * <p>
     * <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
     * </p>
     * 
     * @return Specifies the ARN of the trail that was updated with event selectors. The format of a trail ARN is:</p>
     *         <p>
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
     */
    public String trailARN() {
        return trailARN;
    }

    /**
     * <p>
     * Specifies the event selectors configured for your trail.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Specifies the event selectors configured for your trail.
     */
    public List<EventSelector> eventSelectors() {
        return eventSelectors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(trailARN());
        hashCode = 31 * hashCode + Objects.hashCode(eventSelectors());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutEventSelectorsResponse)) {
            return false;
        }
        PutEventSelectorsResponse other = (PutEventSelectorsResponse) obj;
        return Objects.equals(trailARN(), other.trailARN()) && Objects.equals(eventSelectors(), other.eventSelectors());
    }

    @Override
    public String toString() {
        return ToString.builder("PutEventSelectorsResponse").add("TrailARN", trailARN()).add("EventSelectors", eventSelectors())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrailARN":
            return Optional.ofNullable(clazz.cast(trailARN()));
        case "EventSelectors":
            return Optional.ofNullable(clazz.cast(eventSelectors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutEventSelectorsResponse, T> g) {
        return obj -> g.apply((PutEventSelectorsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudTrailResponse.Builder, SdkPojo, CopyableBuilder<Builder, PutEventSelectorsResponse> {
        /**
         * <p>
         * Specifies the ARN of the trail that was updated with event selectors. The format of a trail ARN is:
         * </p>
         * <p>
         * <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
         * </p>
         * 
         * @param trailARN
         *        Specifies the ARN of the trail that was updated with event selectors. The format of a trail ARN
         *        is:</p>
         *        <p>
         *        <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trailARN(String trailARN);

        /**
         * <p>
         * Specifies the event selectors configured for your trail.
         * </p>
         * 
         * @param eventSelectors
         *        Specifies the event selectors configured for your trail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventSelectors(Collection<EventSelector> eventSelectors);

        /**
         * <p>
         * Specifies the event selectors configured for your trail.
         * </p>
         * 
         * @param eventSelectors
         *        Specifies the event selectors configured for your trail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventSelectors(EventSelector... eventSelectors);

        /**
         * <p>
         * Specifies the event selectors configured for your trail.
         * </p>
         * This is a convenience that creates an instance of the {@link List<EventSelector>.Builder} avoiding the need
         * to create one manually via {@link List<EventSelector>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EventSelector>.Builder#build()} is called immediately and
         * its result is passed to {@link #eventSelectors(List<EventSelector>)}.
         * 
         * @param eventSelectors
         *        a consumer that will call methods on {@link List<EventSelector>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventSelectors(List<EventSelector>)
         */
        Builder eventSelectors(Consumer<EventSelector.Builder>... eventSelectors);
    }

    static final class BuilderImpl extends CloudTrailResponse.BuilderImpl implements Builder {
        private String trailARN;

        private List<EventSelector> eventSelectors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutEventSelectorsResponse model) {
            super(model);
            trailARN(model.trailARN);
            eventSelectors(model.eventSelectors);
        }

        public final String getTrailARN() {
            return trailARN;
        }

        @Override
        public final Builder trailARN(String trailARN) {
            this.trailARN = trailARN;
            return this;
        }

        public final void setTrailARN(String trailARN) {
            this.trailARN = trailARN;
        }

        public final Collection<EventSelector.Builder> getEventSelectors() {
            return eventSelectors != null ? eventSelectors.stream().map(EventSelector::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder eventSelectors(Collection<EventSelector> eventSelectors) {
            this.eventSelectors = EventSelectorsCopier.copy(eventSelectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventSelectors(EventSelector... eventSelectors) {
            eventSelectors(Arrays.asList(eventSelectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventSelectors(Consumer<EventSelector.Builder>... eventSelectors) {
            eventSelectors(Stream.of(eventSelectors).map(c -> EventSelector.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setEventSelectors(Collection<EventSelector.BuilderImpl> eventSelectors) {
            this.eventSelectors = EventSelectorsCopier.copyFromBuilder(eventSelectors);
        }

        @Override
        public PutEventSelectorsResponse build() {
            return new PutEventSelectorsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
